/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.DispType;
import org.yccheok.jstock.engine.Observer;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.StockInfoDatabase;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.gui.AjaxAutoCompleteJComboBox;
import org.yccheok.jstock.gui.JComboBoxLayerUI;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.JTableUtilities;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;
import org.yccheok.jstock.network.Utils;

public class StockDatabaseJDialog
extends JDialog {
    private final StockInfoDatabase stockInfoDatabase;
    private StockInfoDatabase result = null;
    private static final Log log = LogFactory.getLog(StockDatabaseJDialog.class);
    private JButton jButton3;
    private JButton jButton4;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JTable jTable2;
    private JTextField jTextField1;
    private JXHeader jXHeader1;

    public StockDatabaseJDialog(Frame parent, StockInfoDatabase stockInfoDatabase, boolean modal) {
        super(parent, modal);
        this.stockInfoDatabase = stockInfoDatabase;
        this.initComponents();
        this.initJXLayerOnJComboBox();
        this.jComboBox1.requestFocus();
        ((AjaxAutoCompleteJComboBox)this.jComboBox1).attachDispObserver(this.getDispObserver());
    }

    private void initJXLayerOnJComboBox() {
        JXLayer layer = new JXLayer((Component)this.jComboBox1);
        JComboBoxLayerUI<AjaxAutoCompleteJComboBox> jComboBoxLayerUI = new JComboBoxLayerUI<AjaxAutoCompleteJComboBox>();
        layer.setUI(jComboBoxLayerUI);
        ((AjaxAutoCompleteJComboBox)this.jComboBox1).attachBusyObserver(jComboBoxLayerUI);
        this.jPanel5.add((Component)layer);
    }

    private void initComponents() {
        this.jComboBox1 = new AjaxAutoCompleteJComboBox();
        this.jPanel6 = new JPanel();
        this.jXHeader1 = new JXHeader();
        this.jPanel4 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel3 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTable2 = new JTable();
        this.jPanel5 = new JPanel();
        this.jPanel10 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel9 = new JPanel();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setPreferredSize(new Dimension(160, 24));
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("StockDatabaseJDialog_StockDatabase"));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StockDatabaseJDialog.this.formMouseClicked(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                StockDatabaseJDialog.this.formWindowClosed(evt);
            }
        });
        this.jPanel6.setLayout(new BorderLayout(5, 5));
        this.jXHeader1.setDescription(bundle.getString("StockDatabaseJDialog_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/64x64/db_add.png")));
        this.jXHeader1.setTitle(bundle.getString("StockDatabaseJDialog_StockDatabase"));
        this.jPanel6.add((Component)this.jXHeader1, "Center");
        this.getContentPane().add((Component)this.jPanel6, "North");
        this.jPanel4.setLayout(new GridLayout(1, 0));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(bundle.getString("StockDatabaseJDialog_StockExchangeServer")));
        this.jPanel1.setLayout(new BorderLayout());
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(this.getSystemDefinedStockInfoTableModel());
        this.jTable1.setDefaultRenderer(Symbol.class, new StockTableCellRenderer());
        this.jTable1.setDefaultRenderer(Code.class, new StockTableCellRenderer());
        if (JStock.instance().getJStockOptions().useLargeFont()) {
            this.jTable1.setRowHeight((int)((double)this.jTable1.getRowHeight() * 1.2));
        }
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jTextField1.setColumns(10);
        this.jTextField1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                StockDatabaseJDialog.this.newFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                StockDatabaseJDialog.this.newFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                StockDatabaseJDialog.this.newFilter();
            }
        });
        this.jPanel3.add(this.jTextField1);
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.jPanel4.add(this.jPanel1);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("StockDatabaseJDialog_UserDefined")));
        this.jPanel2.setLayout(new BorderLayout());
        this.jScrollPane2.addMouseListener(new TableRowPopupListener(true));
        this.jTable2.setAutoCreateRowSorter(true);
        this.jTable2.setModel(this.getUserDefinedStockInfoTableModel());
        this.jTable2.addMouseListener(new TableRowPopupListener());
        this.jTable2.setDefaultRenderer(Code.class, new StockTableCellRenderer());
        this.jTable2.setDefaultRenderer(Symbol.class, new StockTableCellRenderer());
        this.jTable2.setDefaultEditor(Code.class, this.getCellEditor(Code.class));
        this.jTable2.setDefaultEditor(Symbol.class, this.getCellEditor(Symbol.class));
        if (JStock.instance().getJStockOptions().useLargeFont()) {
            this.jTable2.setRowHeight((int)((double)this.jTable2.getRowHeight() * 1.2));
        }
        this.jTable2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                StockDatabaseJDialog.this.jTable2KeyPressed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTable2);
        this.jPanel2.add((Component)this.jScrollPane2, "Center");
        this.jPanel2.add((Component)this.jPanel5, "North");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont((float)this.jLabel2.getFont().getSize() - 1.0f));
        this.jLabel2.setText(bundle.getString("StockDatabaseJDialog_NeedHelpVisit"));
        this.jPanel10.add(this.jLabel2);
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont((float)this.jLabel3.getFont().getSize() - 1.0f));
        this.jLabel3.setText(bundle.getString("StockDatabaseJDialog_HelpURL"));
        this.jLabel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StockDatabaseJDialog.this.jLabel3MouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                StockDatabaseJDialog.this.jLabel3MouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                StockDatabaseJDialog.this.jLabel3MouseExited(evt);
            }
        });
        this.jPanel10.add(this.jLabel3);
        this.jPanel2.add((Component)this.jPanel10, "South");
        this.jPanel4.add(this.jPanel2);
        this.getContentPane().add((Component)this.jPanel4, "Center");
        this.jPanel7.setLayout(new BorderLayout());
        this.jLabel1.setForeground(new Color(0, 0, 255));
        this.jLabel1.setText(this.getTotalStockString());
        this.jPanel8.add(this.jLabel1);
        this.jPanel7.add((Component)this.jPanel8, "North");
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        this.jButton3.setText(bundle.getString("StockDatabaseJDialog_OK"));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StockDatabaseJDialog.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.jButton3);
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton4.setText(bundle.getString("StockDatabaseJDialog_Cancel"));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StockDatabaseJDialog.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.jButton4);
        this.jPanel7.add((Component)this.jPanel9, "Center");
        this.getContentPane().add((Component)this.jPanel7, "Last");
        this.pack();
    }

    private void formMouseClicked(MouseEvent evt) {
        this.clearAllTablesSelection();
    }

    private void jTable2KeyPressed(KeyEvent evt) {
        if (127 == evt.getKeyCode()) {
            this.deleteSelectedUserDefinedDatabase();
        }
    }

    public StockInfoDatabase getResult() {
        return this.result;
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        ((AjaxAutoCompleteJComboBox)this.jComboBox1).dettachAll();
        this.result = null;
        this.setVisible(false);
        this.dispose();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        boolean status;
        ((AjaxAutoCompleteJComboBox)this.jComboBox1).dettachAll();
        TableCellEditor tableCellEditor = this.jTable2.getCellEditor();
        if (tableCellEditor != null && !(status = tableCellEditor.stopCellEditing())) {
            return;
        }
        StockInfoTableModel model = (StockInfoTableModel)this.jTable2.getModel();
        List<StockInfo> stockInfos = model.getStockInfos();
        this.stockInfoDatabase.removeAllUserDefinedStockInfos();
        for (StockInfo stockInfo : stockInfos) {
            String codeStr = stockInfo.code.toString().trim();
            if (codeStr.length() <= 0) continue;
            String symbolStr = stockInfo.symbol.toString().trim();
            if (symbolStr.length() <= 0) {
                symbolStr = codeStr;
            }
            this.stockInfoDatabase.addUserDefinedStockInfo(StockInfo.newInstance(Code.newInstance(codeStr), Symbol.newInstance(symbolStr)));
        }
        this.result = this.stockInfoDatabase;
        this.setVisible(false);
        this.dispose();
    }

    private void jLabel3MouseClicked(MouseEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.HELP_STOCK_DATABASE_HTML));
    }

    private void jLabel3MouseEntered(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void jLabel3MouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void formWindowClosed(WindowEvent evt) {
        ((AjaxAutoCompleteJComboBox)this.jComboBox1).dettachAll();
        ((AjaxAutoCompleteJComboBox)this.jComboBox1).stop();
    }

    private void deleteSelectedUserDefinedDatabase() {
        int[] rows = this.jTable2.getSelectedRows();
        StockInfoTableModel codeSymbolTableModel = (StockInfoTableModel)this.jTable2.getModel();
        Arrays.sort(rows);
        for (int i = rows.length - 1; i >= 0; --i) {
            int row = rows[i];
            if (row < 0) continue;
            int modelIndex = this.jTable2.getRowSorter().convertRowIndexToModel(row);
            codeSymbolTableModel.removeRow(modelIndex);
        }
    }

    private void clearAllTablesSelection() {
        this.jTable1.getSelectionModel().clearSelection();
        this.jTable2.getSelectionModel().clearSelection();
    }

    private void selectUserDefinedDatabaseTable(int modelIndex) {
        this.clearAllTablesSelection();
        int selectedViewIndex = this.jTable2.getRowSorter().convertRowIndexToView(modelIndex);
        this.jTable2.getSelectionModel().setSelectionInterval(selectedViewIndex, selectedViewIndex);
        JTableUtilities.scrollToVisible(this.jTable2, selectedViewIndex, 0);
    }

    private void selectStockExchangeServerDatabaseTable(int modelIndex) {
        this.clearAllTablesSelection();
        int selectedViewIndex = this.jTable1.getRowSorter().convertRowIndexToView(modelIndex);
        this.jTable1.getSelectionModel().setSelectionInterval(selectedViewIndex, selectedViewIndex);
        JTableUtilities.scrollToVisible(this.jTable1, selectedViewIndex, 0);
    }

    private void addNewStockInfo() {
        StockInfoTableModel model = (StockInfoTableModel)this.jTable2.getModel();
        int selectedModelIndex = model.addNewStockInfo();
        this.selectUserDefinedDatabaseTable(selectedModelIndex);
    }

    private void addNewStockInfo(DispType result) {
        StockInfoTableModel model = (StockInfoTableModel)this.jTable2.getModel();
        int selectedModelIndex = model.addNewStockInfo(result);
        this.selectUserDefinedDatabaseTable(selectedModelIndex);
    }

    private Observer<AjaxAutoCompleteJComboBox, DispType> getDispObserver() {
        return new Observer<AjaxAutoCompleteJComboBox, DispType>(){

            @Override
            public void update(AjaxAutoCompleteJComboBox subject, DispType arg) {
                assert (arg != null);
                assert (SwingUtilities.isEventDispatchThread());
                DispType result = org.yccheok.jstock.engine.Utils.rectifyDisp(arg);
                if (result == null) {
                    return;
                }
                String message_string = result.getDispCode();
                IndexEx indexEx = StockDatabaseJDialog.this.getIndexEx(result.getDispCode(), Code.class);
                if (indexEx != null) {
                    if (indexEx.table == StockDatabaseJDialog.this.jTable1) {
                        StockDatabaseJDialog.this.selectStockExchangeServerDatabaseTable(indexEx.index);
                    } else {
                        assert (indexEx.table == StockDatabaseJDialog.this.jTable2);
                        StockDatabaseJDialog.this.selectUserDefinedDatabaseTable(indexEx.index);
                    }
                    final String message = MessageFormat.format(MessagesBundle.getString("warning_message_duplicated_stock_template"), message_string);
                    final String title = MessagesBundle.getString("warning_title_duplicated_stock");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(StockDatabaseJDialog.this, message, title, 1);
                        }
                    });
                    return;
                }
                StockDatabaseJDialog.this.addNewStockInfo(result);
            }
        };
    }

    private JPopupMenu getMyJTablePopupMenu(boolean newMenuItemOnly) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("New", new ImageIcon(this.getClass().getResource("/images/16x16/filenew.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockDatabaseJDialog.this.addNewStockInfo();
            }
        });
        popup.add(menuItem);
        if (newMenuItemOnly) {
            return popup;
        }
        if (this.jTable2.getSelectedRowCount() >= 1) {
            popup.addSeparator();
            menuItem = new JMenuItem("Delete", new ImageIcon(this.getClass().getResource("/images/16x16/editdelete.png")));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StockDatabaseJDialog.this.deleteSelectedUserDefinedDatabase();
                }
            });
            popup.add(menuItem);
        }
        return popup;
    }

    private TableModel getUserDefinedStockInfoTableModel() {
        return new StockInfoTableModel(Type.UserDefined);
    }

    private TableModel getSystemDefinedStockInfoTableModel() {
        return new StockInfoTableModel(Type.SystemDefined);
    }

    private void newFilter() {
        RowFilter rf;
        final String text = this.jTextField1.getText();
        try {
            rf = RowFilter.regexFilter("^(?i)" + Pattern.quote(text), new int[0]);
        }
        catch (PatternSyntaxException e) {
            return;
        }
        if (!org.yccheok.jstock.engine.Utils.isPinyinTSTSearchEngineRequiredForSymbol()) {
            ((TableRowSorter)this.jTable1.getRowSorter()).setRowFilter(rf);
        } else {
            ((TableRowSorter)this.jTable1.getRowSorter()).setRowFilter(new RowFilter<StockInfoTableModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends StockInfoTableModel, ? extends Integer> entry) {
                    if (rf.include(entry)) {
                        return true;
                    }
                    String lower_text = text.toLowerCase();
                    StockInfoTableModel model = entry.getModel();
                    Symbol symbol = model.getStockInfos().get((int)entry.getIdentifier().intValue()).symbol;
                    List<String> pinyins = Utils.toHanyuPinyin(symbol.toString());
                    for (String pinyin : pinyins) {
                        if (!pinyin.startsWith(lower_text)) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    private TableCellEditor getCellEditor(Class c) {
        return new MyTableCellEditor(c);
    }

    private String getTotalStockString() {
        return MessageFormat.format(GUIBundle.getString("StockDatabaseJDialog_TotalStock_template"), this.stockInfoDatabase.size());
    }

    private IndexEx getIndexEx(String string, Class c) {
        int modelIndex2;
        int modelIndex1;
        StockInfoTableModel model1 = (StockInfoTableModel)this.jTable1.getModel();
        int n = modelIndex1 = Code.class == c ? model1.findStockInfoByCode(string) : model1.findStockInfoBySymbol(string);
        if (modelIndex1 >= 0) {
            return IndexEx.newInstance(modelIndex1, this.jTable1);
        }
        StockInfoTableModel model2 = (StockInfoTableModel)this.jTable2.getModel();
        int n2 = modelIndex2 = Code.class == c ? model2.findStockInfoByCode(string) : model2.findStockInfoBySymbol(string);
        if (modelIndex2 >= 0) {
            return IndexEx.newInstance(modelIndex2, this.jTable2);
        }
        return null;
    }

    private static class IndexEx {
        public final int index;
        public final JTable table;

        private IndexEx(int index, JTable table) {
            this.index = index;
            this.table = table;
        }

        public static IndexEx newInstance(int index, JTable table) {
            return new IndexEx(index, table);
        }
    }

    private class MyTableCellEditor
    extends DefaultCellEditor {
        private final Class c;

        public MyTableCellEditor(Class c) {
            super(new JTextField());
            this.c = c;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            JTextField textField = (JTextField)this.getComponent();
            String str = textField.getText();
            if (str == null) {
                return null;
            }
            str = str.trim();
            try {
                Method method = this.c.getMethod("newInstance", String.class);
                return method.invoke(null, this.c == Code.class ? str.toUpperCase() : str);
            }
            catch (Exception ex) {
                log.error(null, (Throwable)ex);
                return null;
            }
        }

        @Override
        public boolean stopCellEditing() {
            String string = this.c == Code.class ? ((String)super.getCellEditorValue()).trim().toUpperCase() : ((String)super.getCellEditorValue()).trim();
            if (0 == string.length()) {
                return super.stopCellEditing();
            }
            IndexEx indexEx = StockDatabaseJDialog.this.getIndexEx(string, this.c);
            if (indexEx != null) {
                if (indexEx.table == StockDatabaseJDialog.this.jTable2 && indexEx.index == StockDatabaseJDialog.this.jTable2.convertRowIndexToModel(StockDatabaseJDialog.this.jTable2.getEditingRow())) {
                    return super.stopCellEditing();
                }
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                if (indexEx.table == StockDatabaseJDialog.this.jTable1) {
                    StockDatabaseJDialog.this.selectStockExchangeServerDatabaseTable(indexEx.index);
                } else {
                    assert (indexEx.table == StockDatabaseJDialog.this.jTable2);
                    StockDatabaseJDialog.this.selectUserDefinedDatabaseTable(indexEx.index);
                }
                String message = MessageFormat.format(MessagesBundle.getString("warning_message_duplicated_stock_template"), string);
                String title = MessagesBundle.getString("warning_title_duplicated_stock");
                JOptionPane.showMessageDialog(StockDatabaseJDialog.this, message, title, 1);
                return false;
            }
            return super.stopCellEditing();
        }
    }

    private class StockInfoTableModel
    extends AbstractTableModel {
        private final List<StockInfo> stockInfos;
        private final Type type;
        private final String[] columnNames = new String[]{"Code", "Symbol"};
        private final Class[] columnClasses = new Class[]{Code.class, Symbol.class};

        public Type getType() {
            return this.type;
        }

        public List<StockInfo> getStockInfos() {
            return Collections.unmodifiableList(this.stockInfos);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return !this.isReadOnly();
        }

        private boolean isReadOnly() {
            return this.type != Type.UserDefined;
        }

        public void removeRow(int index) {
            if (this.isReadOnly()) {
                return;
            }
            this.stockInfos.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public StockInfoTableModel(Type type) {
            this.type = type;
            this.stockInfos = this.type == Type.UserDefined ? StockDatabaseJDialog.this.stockInfoDatabase.getUserDefinedStockInfos() : StockDatabaseJDialog.this.stockInfoDatabase.getNonUserDefinedStockInfos();
        }

        @Override
        public int getRowCount() {
            return this.stockInfos.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.stockInfos.get((int)rowIndex).code;
                }
                case 1: {
                    return this.stockInfos.get((int)rowIndex).symbol;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int c) {
            return this.columnClasses[c];
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (this.isReadOnly()) {
                super.setValueAt(value, row, col);
                return;
            }
            if (value instanceof Symbol) {
                Symbol symbol = (Symbol)value;
                Code code = this.stockInfos.remove((int)row).code;
                this.stockInfos.add(row, StockInfo.newInstance(code, symbol));
            } else if (value instanceof Code) {
                Code code = (Code)value;
                Symbol symbol = this.stockInfos.remove((int)row).symbol;
                this.stockInfos.add(row, StockInfo.newInstance(code, symbol));
            } else assert (false);
            this.fireTableCellUpdated(row, col);
        }

        public int findStockInfoBySymbol(String string) {
            int index = -1;
            int size = this.stockInfos.size();
            for (int i = 0; i < size; ++i) {
                if (!this.stockInfos.get((int)i).symbol.toString().equalsIgnoreCase(string)) continue;
                index = i;
                break;
            }
            return index;
        }

        public int findStockInfoByCode(String string) {
            int index = -1;
            int size = this.stockInfos.size();
            for (int i = 0; i < size; ++i) {
                if (!this.stockInfos.get((int)i).code.toString().equalsIgnoreCase(string)) continue;
                index = i;
                break;
            }
            return index;
        }

        public int addNewStockInfo() {
            Code code = Code.newInstance("");
            Symbol symbol = Symbol.newInstance("");
            this.stockInfos.add(StockInfo.newInstance(code, symbol));
            int index = this.stockInfos.size() - 1;
            this.fireTableRowsInserted(index, index);
            return index;
        }

        public int addNewStockInfo(DispType result) {
            Code code = Code.newInstance(result.getDispCode());
            Symbol symbol = Symbol.newInstance(result.getDispName());
            this.stockInfos.add(StockInfo.newInstance(code, symbol));
            int index = this.stockInfos.size() - 1;
            this.fireTableRowsInserted(index, index);
            return index;
        }
    }

    private static enum Type {
        UserDefined,
        SystemDefined;

    }

    private static final class StockTableCellRenderer
    extends DefaultTableCellRenderer {
        private Color getBackgroundColor(int row) {
            JStockOptions jStockOptions = JStock.instance().getJStockOptions();
            if (row % 2 == 0) {
                return jStockOptions.getFirstRowBackgroundColor();
            }
            return jStockOptions.getSecondRowBackgroundColor();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, color, isSelected, hasFocus, row, column);
            if (isSelected || hasFocus) {
                return c;
            }
            JStockOptions jStockOptions = JStock.instance().getJStockOptions();
            c.setForeground(jStockOptions.getNormalTextForegroundColor());
            c.setBackground(this.getBackgroundColor(row));
            return c;
        }
    }

    private class TableRowPopupListener
    extends MouseAdapter {
        private boolean newMenuItemOnly = false;

        public TableRowPopupListener(boolean newMenuItemOnly) {
            this.newMenuItemOnly = newMenuItemOnly;
        }

        public TableRowPopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                StockDatabaseJDialog.this.getMyJTablePopupMenu(this.newMenuItemOnly).show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

