/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.analysis.OperatorIndicator;
import org.yccheok.jstock.gui.IndicatorProjectManager;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.internationalization.GUIBundle;

public class WizardSelectIndicatorJPanel
extends JPanel {
    private IndicatorProjectManager alertIndicatorProjectManager;
    private JLabel jLabel1;
    private JList jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JXHeader jXHeader1;

    public WizardSelectIndicatorJPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jXHeader1 = new JXHeader();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel1 = new JLabel();
        this.setLayout(new BorderLayout(5, 5));
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jXHeader1.setDescription(bundle.getString("Main_WizardSelectIndicatorJPanel_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/64x64/viewmag.png")));
        this.jXHeader1.setTitle(bundle.getString("Main_WizardSelectIndicatorJPanel_SelectStockIndicators"));
        this.add((Component)this.jXHeader1, "North");
        this.jList1.setModel(new DefaultListModel());
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                WizardSelectIndicatorJPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jLabel1.setForeground(new Color(255, 0, 0));
        this.jLabel1.setText(bundle.getString("Main_WizardSelectIndicatorJPanel_NoIndicatorBeingSelected"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 508, Short.MAX_VALUE).addComponent(this.jLabel1)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 149, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 24, Short.MAX_VALUE).addComponent(this.jLabel1).addContainerGap()));
        this.add((Component)this.jPanel1, "Center");
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        int numOfSelectedItems = this.getSelectedProjects().size();
        if (numOfSelectedItems == 0) {
            this.jLabel1.setForeground(Color.RED);
            this.jLabel1.setText(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("Main_WizardSelectIndicatorJPanel_NoIndicatorBeingSelected"));
        } else {
            this.jLabel1.setForeground(Color.BLUE);
            String template = GUIBundle.getString("Main_WizardSelectIndicatorJPanel_Indicator(s)BeingSelected_template");
            String message = MessageFormat.format(template, numOfSelectedItems);
            this.jLabel1.setText(message);
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.jList1.addListSelectionListener(listener);
    }

    public List<String> getSelectedProjects() {
        ListModel listModel = this.jList1.getModel();
        DefaultListModel defaultListModel = (DefaultListModel)listModel;
        Object[] selected = this.jList1.getSelectedValues();
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : selected) {
            list.add(o.toString());
        }
        return list;
    }

    public void updateAlertIndicatorProjectManager() {
        if (this.alertIndicatorProjectManager != null) {
            return;
        }
        JStock m = JStock.instance();
        this.alertIndicatorProjectManager = m.getAlertIndicatorProjectManager();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ListModel listModel = WizardSelectIndicatorJPanel.this.jList1.getModel();
                DefaultListModel defaultListModel = (DefaultListModel)listModel;
                defaultListModel.removeAllElements();
                int numOfProject = WizardSelectIndicatorJPanel.this.alertIndicatorProjectManager.getNumOfProject();
                for (int i = 0; i < numOfProject; ++i) {
                    String project = WizardSelectIndicatorJPanel.this.alertIndicatorProjectManager.getProject(i);
                    OperatorIndicator operatorIndicator = WizardSelectIndicatorJPanel.this.alertIndicatorProjectManager.getOperatorIndicator(project);
                    if (operatorIndicator == null || operatorIndicator.getType() != OperatorIndicator.Type.AlertIndicator) continue;
                    defaultListModel.addElement(project);
                }
            }
        });
    }
}

