/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.analysis;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import com.l2fprod.common.propertysheet.PropertyEditorRegistry;
import com.l2fprod.common.propertysheet.PropertyRendererRegistry;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.gui.EnumComboBoxPropertyEditor;

public class ObjectInspectorJPanel
extends PropertySheetPanel {
    private Object bean;
    private static final Log log = LogFactory.getLog(ObjectInspectorJPanel.class);

    public ObjectInspectorJPanel(Object bean) {
        this.bean = bean;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException exp) {
            log.error(null, (Throwable)exp);
        }
        this.getTable().setEditorFactory((PropertyEditorFactory)new PropertyEditorRegistryEx());
        PropertyEditorRegistry editor = (PropertyEditorRegistry)this.getTable().getEditorFactory();
        PropertyRendererRegistry renderer = (PropertyRendererRegistry)this.getTable().getRendererFactory();
        editor.registerEditor(Enum.class, (PropertyEditor)((Object)new EnumComboBoxPropertyEditor()));
        DefaultCellRenderer r = new DefaultCellRenderer();
        r.setShowOddAndEvenRows(false);
        renderer.registerRenderer(Enum.class, (TableCellRenderer)r);
        this.setMode(0);
        this.setToolBarVisible(false);
        this.setDescriptionVisible(false);
        this.setToolBarVisible(true);
        this.setBeanInfo(beanInfo);
        Property[] properties = this.getProperties();
        int c = properties.length;
        for (int i = 0; i < c; ++i) {
            properties[i].readFromObject(bean);
        }
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Property prop = (Property)evt.getSource();
                prop.writeToObject(ObjectInspectorJPanel.this.bean);
            }
        };
        this.addPropertySheetChangeListener(listener);
    }

    public void setBean(Object bean) {
        this.bean = bean;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException exp) {
            log.error(null, (Throwable)exp);
        }
        this.setBeanInfo(beanInfo);
        Property[] properties = this.getProperties();
        int c = properties.length;
        for (int i = 0; i < c; ++i) {
            properties[i].readFromObject(bean);
        }
    }

    public Object getBean() {
        return this.bean;
    }

    public boolean stopCellEditing() {
        TableCellEditor editor = this.getTable().getCellEditor();
        if (editor != null) {
            return editor.stopCellEditing();
        }
        return true;
    }

    private static class PropertyEditorRegistryEx
    extends PropertyEditorRegistry {
        private PropertyEditorRegistryEx() {
        }

        public synchronized PropertyEditor getEditor(Class type) {
            PropertyEditor editor = super.getEditor(type);
            Class c = type;
            while (editor == null) {
                if ((c = c.getSuperclass()) == null) {
                    return editor;
                }
                editor = super.getEditor(c);
            }
            return editor;
        }
    }
}

