/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.charting;

import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.charting.InvestmentFlowChartJDialog;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;
import org.yccheok.jstock.portfolio.Activities;
import org.yccheok.jstock.portfolio.Activity;
import org.yccheok.jstock.portfolio.DecimalPlace;

public class InvestmentFlowLayerUI<V extends JComponent>
extends AbstractLayerUI<V> {
    private Point2D investPoint = null;
    private int investPointIndex = -1;
    private Point2D ROIPoint = null;
    private int ROIPointIndex = -1;
    private final Rectangle2D drawArea = new Rectangle();
    private final InvestmentFlowChartJDialog investmentFlowChartJDialog;
    private static final Color COLOR_BLUE = new Color(85, 85, 255);
    private static final Color COLOR_RED = new Color(255, 85, 85);
    private static final Color COLOR_RED_BORDER = new Color(255, 85, 85);
    private static final Color COLOR_RED_BACKGROUND = new Color(255, 255, 153);
    private static final Color COLOR_BLUE_BORDER = new Color(85, 85, 255);
    private static final Color COLOR_BLUE_BACKGROUND = new Color(255, 255, 153);
    private static final Color COLOR_BACKGROUND = new Color(255, 255, 153);
    private static final Color COLOR_BORDER = new Color(255, 204, 0);
    private final List<String> ROIValues = new ArrayList<String>();
    private final List<String> ROIParams = new ArrayList<String>();
    private final Rectangle2D ROIRect = new Rectangle();
    private double totalROIValue = 0.0;
    private final List<String> investValues = new ArrayList<String>();
    private final List<String> investParams = new ArrayList<String>();
    private final Rectangle2D investRect = new Rectangle();
    private double totalInvestValue = 0.0;

    public InvestmentFlowLayerUI(InvestmentFlowChartJDialog cashFlowChartJDialog) {
        this.investmentFlowChartJDialog = cashFlowChartJDialog;
    }

    private void drawTitle(Graphics2D g2) {
        Object oldValueAntiAlias = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Color oldColor = g2.getColor();
        Font oldFont = g2.getFont();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font titleFont = oldFont.deriveFont(oldFont.getStyle() | 1, (float)oldFont.getSize() * 1.5f);
        int margin = 5;
        FontMetrics titleFontMetrics = g2.getFontMetrics(titleFont);
        FontMetrics oldFontMetrics = g2.getFontMetrics(oldFont);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        double totalInvestValue = this.investmentFlowChartJDialog.getTotalInvestValue();
        double totalROIValue = this.investmentFlowChartJDialog.getTotalROIValue();
        DecimalPlace decimalPlace = JStock.instance().getJStockOptions().getDecimalPlace();
        String invest = org.yccheok.jstock.portfolio.Utils.toCurrencyWithSymbol(decimalPlace, totalInvestValue);
        String roi = org.yccheok.jstock.portfolio.Utils.toCurrencyWithSymbol(decimalPlace, totalROIValue);
        double gain = totalROIValue - totalInvestValue;
        double percentage = totalInvestValue > 0.0 ? gain / totalInvestValue * 100.0 : 0.0;
        String gain_str = org.yccheok.jstock.portfolio.Utils.toCurrencyWithSymbol(decimalPlace, gain);
        String percentage_str = numberFormat.format(percentage);
        String SELECTED = this.investmentFlowChartJDialog.getCurrentSelectedString();
        String INVEST = GUIBundle.getString("InvestmentFlowLayerUI_Invest");
        String RETURN = GUIBundle.getString("InvestmentFlowLayerUI_Return");
        String GAIN = (SELECTED.length() > 0 ? SELECTED + " " : "") + GUIBundle.getString("InvestmentFlowLayerUI_Gain");
        String LOSS = (SELECTED.length() > 0 ? SELECTED + " " : "") + GUIBundle.getString("InvestmentFlowLayerUI_Loss");
        int string_width = oldFontMetrics.stringWidth(INVEST + ": ") + titleFontMetrics.stringWidth(invest + " ") + oldFontMetrics.stringWidth(RETURN + ": ") + titleFontMetrics.stringWidth(roi + " ") + oldFontMetrics.stringWidth((gain >= 0.0 ? GAIN : LOSS) + ": ") + titleFontMetrics.stringWidth(gain_str + " (" + percentage_str + "%)");
        int x = this.investmentFlowChartJDialog.getChartPanel().getWidth() - string_width >> 1;
        int y = 5 + titleFontMetrics.getAscent();
        g2.setFont(oldFont);
        g2.drawString(INVEST + ": ", x, y);
        g2.setFont(titleFont);
        g2.drawString(invest + " ", x += oldFontMetrics.stringWidth(INVEST + ": "), y);
        g2.setFont(oldFont);
        g2.drawString(RETURN + ": ", x += titleFontMetrics.stringWidth(invest + " "), y);
        g2.setFont(titleFont);
        g2.drawString(roi + " ", x += oldFontMetrics.stringWidth(RETURN + ": "), y);
        x += titleFontMetrics.stringWidth(roi + " ");
        g2.setFont(oldFont);
        if (gain >= 0.0) {
            if (gain > 0.0) {
                if (org.yccheok.jstock.engine.Utils.isFallBelowAndRiseAboveColorReverse()) {
                    g2.setColor(JStock.instance().getJStockOptions().getLowerNumericalValueForegroundColor());
                } else {
                    g2.setColor(JStock.instance().getJStockOptions().getHigherNumericalValueForegroundColor());
                }
            }
            g2.drawString(GAIN + ": ", x, y);
            x += oldFontMetrics.stringWidth(GAIN + ": ");
        } else {
            if (org.yccheok.jstock.engine.Utils.isFallBelowAndRiseAboveColorReverse()) {
                g2.setColor(JStock.instance().getJStockOptions().getHigherNumericalValueForegroundColor());
            } else {
                g2.setColor(JStock.instance().getJStockOptions().getLowerNumericalValueForegroundColor());
            }
            g2.drawString(LOSS + ": ", x, y);
            x += oldFontMetrics.stringWidth(LOSS + ": ");
        }
        g2.setFont(titleFont);
        g2.drawString(gain_str + " (" + percentage_str + "%)", x, y);
        g2.setColor(oldColor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldValueAntiAlias);
        g2.setFont(oldFont);
    }

    private void drawInformationBox(Graphics2D g2, Activities activities, Rectangle2D rect, List<String> params, List<String> values, String totalParam, double totalValue, Color background_color, Color border_color) {
        Font oldFont;
        Font paramFont = oldFont = g2.getFont();
        FontMetrics paramFontMetrics = g2.getFontMetrics(paramFont);
        Font valueFont = oldFont.deriveFont(oldFont.getStyle() | 1, (float)oldFont.getSize() + 1.0f);
        FontMetrics valueFontMetrics = g2.getFontMetrics(valueFont);
        Font dateFont = oldFont.deriveFont((float)oldFont.getSize() - 1.0f);
        FontMetrics dateFontMetrics = g2.getFontMetrics(dateFont);
        int x = (int)rect.getX();
        int y = (int)rect.getY();
        int width = (int)rect.getWidth();
        int height = (int)rect.getHeight();
        Object oldValueAntiAlias = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Composite oldComposite = g2.getComposite();
        Color oldColor = g2.getColor();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(border_color);
        g2.drawRoundRect(x - 1, y - 1, width + 1, height + 1, 15, 15);
        g2.setColor(background_color);
        g2.setComposite(Utils.makeComposite(0.75f));
        g2.fillRoundRect(x, y, width, height, 15, 15);
        g2.setComposite(oldComposite);
        g2.setColor(oldColor);
        Date date = activities.getDate().getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE, MMMM d, yyyy");
        String dateString = simpleDateFormat.format(date);
        int padding = 5;
        int yy = y + 5 + dateFontMetrics.getAscent();
        g2.setFont(dateFont);
        g2.setColor(COLOR_BLUE);
        g2.drawString(dateString, (width - dateFontMetrics.stringWidth(dateString) >> 1) + x, yy);
        int index = 0;
        int dateInfoHeightMargin = 5;
        int infoTotalHeightMargin = 5;
        boolean paramValueHeightMargin = false;
        yy += dateFontMetrics.getDescent() + 5 + Math.max(paramFontMetrics.getAscent(), valueFontMetrics.getAscent());
        for (String param : params) {
            String value = values.get(index++);
            g2.setColor(Color.BLACK);
            g2.setFont(paramFont);
            g2.drawString(param + ":", 5 + x, yy);
            g2.setFont(valueFont);
            g2.drawString(value, width - 5 - valueFontMetrics.stringWidth(value) + x, yy);
            yy += 0 + Math.max(paramFontMetrics.getHeight(), valueFontMetrics.getHeight());
        }
        if (values.size() > 1) {
            yy += 0;
            yy += 5;
            if (totalValue > 0.0) {
                g2.setColor(JStockOptions.DEFAULT_HIGHER_NUMERICAL_VALUE_FOREGROUND_COLOR);
            } else if (totalValue < 0.0) {
                g2.setColor(JStockOptions.DEFAULT_LOWER_NUMERICAL_VALUE_FOREGROUND_COLOR);
            }
            g2.setFont(paramFont);
            g2.drawString(totalParam + ":", 5 + x, yy);
            g2.setFont(valueFont);
            DecimalPlace decimalPlace = JStock.instance().getJStockOptions().getDecimalPlace();
            String totalValueStr = org.yccheok.jstock.portfolio.Utils.toCurrencyWithSymbol(decimalPlace, totalValue);
            g2.drawString(totalValueStr, width - 5 - valueFontMetrics.stringWidth(totalValueStr) + x, yy);
        }
        g2.setColor(oldColor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldValueAntiAlias);
        g2.setFont(oldFont);
    }

    private double convertToPoundIfNecessary(Code code, double value) {
        boolean shouldConvertPenceToPound = org.yccheok.jstock.portfolio.Utils.shouldConvertPenceToPound(this.investmentFlowChartJDialog.getPortfolioRealTimeInfo(), code);
        if (!shouldConvertPenceToPound) {
            return value;
        }
        return value / 100.0;
    }

    private void updateROIInformationBox(Graphics2D g2) {
        double bestBorderX;
        Font oldFont;
        Font paramFont = oldFont = g2.getFont();
        FontMetrics paramFontMetrics = g2.getFontMetrics(paramFont);
        Font valueFont = oldFont.deriveFont(oldFont.getStyle() | 1, (float)oldFont.getSize() + 1.0f);
        FontMetrics valueFontMetrics = g2.getFontMetrics(valueFont);
        Font dateFont = oldFont.deriveFont((float)oldFont.getSize() - 1.0f);
        FontMetrics dateFontMetrics = g2.getFontMetrics(dateFont);
        Activities activities = this.investmentFlowChartJDialog.getROIActivities(this.ROIPointIndex);
        this.ROIValues.clear();
        this.ROIParams.clear();
        this.totalROIValue = 0.0;
        DecimalPlace decimalPlace = JStock.instance().getJStockOptions().getDecimalPlace();
        int size = activities.size();
        for (int i = 0; i < size; ++i) {
            double amount;
            StockInfo stockInfo;
            Activity activity = activities.get(i);
            if (activity.getType() == Activity.Type.Buy) {
                double quantity = (Double)activity.get(Activity.Param.Quantity);
                stockInfo = (StockInfo)activity.get(Activity.Param.StockInfo);
                this.ROIParams.add(GUIBundle.getString("InvestmentFlowLayerUI_Own") + " " + org.yccheok.jstock.portfolio.Utils.toQuantity(quantity) + " " + stockInfo.symbol);
                amount = this.convertToPoundIfNecessary(stockInfo.code, quantity * this.investmentFlowChartJDialog.getStockPrice(stockInfo.code));
                this.totalROIValue += amount;
                this.ROIValues.add(org.yccheok.jstock.portfolio.Utils.toCurrencyWithSymbol(decimalPlace, amount));
                continue;
            }
            if (activity.getType() == Activity.Type.Sell) {
                double quantity = (Double)activity.get(Activity.Param.Quantity);
                stockInfo = (StockInfo)activity.get(Activity.Param.StockInfo);
                this.ROIParams.add((Object)((Object)activity.getType()) + " " + org.yccheok.jstock.portfolio.Utils.toQuantity(quantity) + " " + stockInfo.symbol);
                amount = this.convertToPoundIfNecessary(stockInfo.code, activity.getAmount());
                this.totalROIValue += amount;
                this.ROIValues.add(org.yccheok.jstock.portfolio.Utils.toCurrencyWithSymbol(decimalPlace, amount));
                continue;
            }
            if (activity.getType() == Activity.Type.Dividend) {
                StockInfo stockInfo2 = (StockInfo)activity.get(Activity.Param.StockInfo);
                this.ROIParams.add((Object)((Object)activity.getType()) + " " + stockInfo2.symbol);
                double amount2 = activity.getAmount();
                this.totalROIValue += amount2;
                this.ROIValues.add(org.yccheok.jstock.portfolio.Utils.toCurrencyWithSymbol(decimalPlace, amount2));
                continue;
            }
            assert (false);
        }
        boolean isTotalNeeded = this.ROIParams.size() > 1;
        String totalParam = GUIBundle.getString("InvestmentFlowLayerUI_Total_Return");
        String totalValue = org.yccheok.jstock.portfolio.Utils.toCurrencyWithSymbol(decimalPlace, this.totalROIValue);
        int totalHeight = 0;
        assert (this.ROIParams.size() == this.ROIValues.size());
        int index = 0;
        int paramValueWidthMargin = 10;
        boolean paramValueHeightMargin = false;
        int maxInfoWidth = -1;
        int totalInfoHeight = Math.max(paramFontMetrics.getHeight(), valueFontMetrics.getHeight()) * this.ROIValues.size() + 0 * (this.ROIValues.size() - 1);
        for (String param : this.ROIParams) {
            String value = this.ROIValues.get(index++);
            int paramStringWidth = paramFontMetrics.stringWidth(param + ":") + 10 + valueFontMetrics.stringWidth(value);
            if (maxInfoWidth >= paramStringWidth) continue;
            maxInfoWidth = paramStringWidth;
        }
        if (isTotalNeeded) {
            int tmp = paramFontMetrics.stringWidth(totalParam + ":") + 10 + valueFontMetrics.stringWidth(totalValue);
            if (maxInfoWidth < tmp) {
                maxInfoWidth = tmp;
            }
            totalHeight = Math.max(paramFontMetrics.getHeight(), valueFontMetrics.getHeight());
        }
        Date date = activities.getDate().getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE, MMMM d, yyyy");
        String dateString = simpleDateFormat.format(date);
        int dateStringWidth = dateFontMetrics.stringWidth(dateString);
        int dateStringHeight = dateFontMetrics.getHeight();
        int maxStringWidth = Math.max(dateStringWidth, maxInfoWidth);
        int dateInfoHeightMargin = 5;
        int infoTotalHeightMargin = 5;
        int maxStringHeight = isTotalNeeded ? dateStringHeight + 5 + totalInfoHeight + 5 + totalHeight : dateStringHeight + 5 + totalInfoHeight;
        int padding = 5;
        int boxPointMargin = 8;
        int width = maxStringWidth + 10;
        int height = maxStringHeight + 10;
        int borderWidth = width + 2;
        int borderHeight = height + 2;
        double suggestedBorderX = this.ROIPoint.getX() - (double)borderWidth - 8.0;
        double suggestedBorderY = this.ROIPoint.getY() - (double)(borderHeight >> 1);
        double d = suggestedBorderX > this.drawArea.getX() ? (suggestedBorderX + (double)borderWidth < this.drawArea.getX() + this.drawArea.getWidth() ? suggestedBorderX : this.drawArea.getX() + this.drawArea.getWidth() - (double)borderWidth - 8.0) : (bestBorderX = this.ROIPoint.getX() + 8.0);
        double bestBorderY = suggestedBorderY > this.drawArea.getY() ? (suggestedBorderY + (double)borderHeight < this.drawArea.getY() + this.drawArea.getHeight() ? suggestedBorderY : this.drawArea.getY() + this.drawArea.getHeight() - (double)borderHeight - 8.0) : this.drawArea.getY() + 8.0;
        double x = bestBorderX + 1.0;
        double y = bestBorderY + 1.0;
        this.ROIRect.setRect(x, y, width, height);
    }

    private void updateInvestInformationBox(Graphics2D g2) {
        int x;
        Font oldFont;
        Font paramFont = oldFont = g2.getFont();
        FontMetrics paramFontMetrics = g2.getFontMetrics(paramFont);
        Font valueFont = oldFont.deriveFont(oldFont.getStyle() | 1, (float)oldFont.getSize() + 1.0f);
        FontMetrics valueFontMetrics = g2.getFontMetrics(valueFont);
        Font dateFont = oldFont.deriveFont((float)oldFont.getSize() - 1.0f);
        FontMetrics dateFontMetrics = g2.getFontMetrics(dateFont);
        Activities activities = this.investmentFlowChartJDialog.getInvestActivities(this.investPointIndex);
        this.investValues.clear();
        this.investParams.clear();
        this.totalInvestValue = 0.0;
        DecimalPlace decimalPlace = JStock.instance().getJStockOptions().getDecimalPlace();
        int size = activities.size();
        for (int i = 0; i < size; ++i) {
            Activity activity = activities.get(i);
            this.investParams.add((Object)((Object)activity.getType()) + " " + org.yccheok.jstock.portfolio.Utils.toQuantity(activity.get(Activity.Param.Quantity)) + " " + ((StockInfo)activity.get((Activity.Param)Activity.Param.StockInfo)).symbol);
            if (activity.getType() == Activity.Type.Buy) {
                StockInfo stockInfo = (StockInfo)activity.get(Activity.Param.StockInfo);
                double amount = this.convertToPoundIfNecessary(stockInfo.code, activity.getAmount());
                this.totalInvestValue += amount;
                this.investValues.add(org.yccheok.jstock.portfolio.Utils.toCurrencyWithSymbol(decimalPlace, amount));
                continue;
            }
            assert (false);
        }
        boolean isTotalNeeded = this.investParams.size() > 1;
        String totalParam = GUIBundle.getString("InvestmentFlowLayerUI_Total_Invest");
        String totalValue = org.yccheok.jstock.portfolio.Utils.toCurrencyWithSymbol(decimalPlace, this.totalInvestValue);
        int totalHeight = 0;
        assert (this.investValues.size() == this.investParams.size());
        int index = 0;
        int paramValueWidthMargin = 10;
        boolean paramValueHeightMargin = false;
        int maxInfoWidth = -1;
        int totalInfoHeight = Math.max(paramFontMetrics.getHeight(), valueFontMetrics.getHeight()) * this.investValues.size() + 0 * (this.investValues.size() - 1);
        for (String param : this.investParams) {
            String value = this.investValues.get(index++);
            int paramStringWidth = paramFontMetrics.stringWidth(param + ":") + 10 + valueFontMetrics.stringWidth(value);
            if (maxInfoWidth >= paramStringWidth) continue;
            maxInfoWidth = paramStringWidth;
        }
        if (isTotalNeeded) {
            int tmp = paramFontMetrics.stringWidth(totalParam + ":") + 10 + valueFontMetrics.stringWidth(totalValue);
            if (maxInfoWidth < tmp) {
                maxInfoWidth = tmp;
            }
            totalHeight = Math.max(paramFontMetrics.getHeight(), valueFontMetrics.getHeight());
        }
        Date date = activities.getDate().getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE, MMMM d, yyyy");
        String dateString = simpleDateFormat.format(date);
        int dateStringWidth = dateFontMetrics.stringWidth(dateString);
        int dateStringHeight = dateFontMetrics.getHeight();
        int maxStringWidth = Math.max(dateStringWidth, maxInfoWidth);
        int dateInfoHeightMargin = 5;
        int infoTotalHeightMargin = 5;
        int maxStringHeight = isTotalNeeded ? dateStringHeight + 5 + totalInfoHeight + 5 + totalHeight : dateStringHeight + 5 + totalInfoHeight;
        int padding = 5;
        int boxPointMargin = 8;
        int width = maxStringWidth + 10;
        int height = maxStringHeight + 10;
        int suggestedX = (int)(this.investPoint.getX() - (double)width - 8.0);
        int suggestedY = (int)(this.investPoint.getY() - (double)(height >> 1));
        int n = (double)suggestedX > this.drawArea.getX() ? ((double)(suggestedX + width) < this.drawArea.getX() + this.drawArea.getWidth() ? suggestedX : (int)(this.drawArea.getX() + this.drawArea.getWidth() - (double)width - 8.0)) : (x = (int)(this.investPoint.getX() + 8.0));
        int y = (double)suggestedY > this.drawArea.getY() ? ((double)(suggestedY + height) < this.drawArea.getY() + this.drawArea.getHeight() ? suggestedY : (int)(this.drawArea.getY() + this.drawArea.getHeight() - (double)height - 8.0)) : (int)(this.drawArea.getY() + 8.0);
        this.investRect.setRect(x, y, width, height);
    }

    private boolean updateROIPoint(Point2D _ROIPoint) {
        if (_ROIPoint == null) {
            return false;
        }
        ChartPanel chartPanel = this.investmentFlowChartJDialog.getChartPanel();
        JFreeChart chart = chartPanel.getChart();
        XYPlot plot = (XYPlot)chart.getPlot();
        TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)plot.getDataset(1);
        TimeSeries timeSeries = timeSeriesCollection.getSeries(0);
        Rectangle2D _plotArea = chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
        if (_plotArea.getWidth() == 0.0 && _plotArea.getHeight() == 0.0) {
            return true;
        }
        ValueAxis domainAxis = plot.getDomainAxis();
        RectangleEdge domainAxisEdge = plot.getDomainAxisEdge();
        ValueAxis rangeAxis = plot.getRangeAxis();
        RectangleEdge rangeAxisEdge = plot.getRangeAxisEdge();
        double coordinateX = domainAxis.java2DToValue(_ROIPoint.getX(), _plotArea, domainAxisEdge);
        int low = 0;
        int high = timeSeries.getItemCount() - 1;
        Date date = new Date((long)coordinateX);
        long time = date.getTime();
        long bestDistance = Long.MAX_VALUE;
        int bestMid = 0;
        while (low <= high) {
            long abs_cmp;
            int mid = low + high >>> 1;
            TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(mid);
            Day day = (Day)timeSeriesDataItem.getPeriod();
            long search = day.getFirstMillisecond();
            long cmp = search - time;
            if (cmp < 0L) {
                low = mid + 1;
            } else if (cmp > 0L) {
                high = mid - 1;
            } else {
                bestDistance = 0L;
                bestMid = mid;
                break;
            }
            if ((abs_cmp = Math.abs(cmp)) >= bestDistance) continue;
            bestDistance = abs_cmp;
            bestMid = mid;
        }
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(bestMid);
        double xValue = timeSeriesDataItem.getPeriod().getFirstMillisecond();
        double yValue = timeSeriesDataItem.getValue().doubleValue();
        double xJava2D = domainAxis.valueToJava2D(xValue, _plotArea, domainAxisEdge);
        double yJava2D = rangeAxis.valueToJava2D(yValue, _plotArea, rangeAxisEdge);
        int tmpIndex = bestMid;
        Point2D.Double tmpPoint = new Point2D.Double(xJava2D, yJava2D);
        this.drawArea.setRect(_plotArea);
        if (this.drawArea.contains(tmpPoint)) {
            this.ROIPointIndex = tmpIndex;
            this.ROIPoint = tmpPoint;
            return true;
        }
        return false;
    }

    public void updateROIPoint() {
        if (!this.updateROIPoint(this.ROIPoint)) {
            this.ROIPoint = null;
            this.ROIPointIndex = -1;
        }
        this.setDirty(true);
    }

    public void updateInvestPoint() {
        if (!this.updateInvestPoint(this.investPoint)) {
            this.investPoint = null;
            this.investPointIndex = -1;
        }
        this.setDirty(true);
    }

    private boolean updateInvestPoint(Point2D _investPoint) {
        if (_investPoint == null) {
            return false;
        }
        ChartPanel chartPanel = this.investmentFlowChartJDialog.getChartPanel();
        JFreeChart chart = chartPanel.getChart();
        XYPlot plot = (XYPlot)chart.getPlot();
        TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)plot.getDataset();
        TimeSeries timeSeries = timeSeriesCollection.getSeries(0);
        Rectangle2D _plotArea = chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
        if (_plotArea.getWidth() == 0.0 && _plotArea.getHeight() == 0.0) {
            return true;
        }
        ValueAxis domainAxis = plot.getDomainAxis();
        RectangleEdge domainAxisEdge = plot.getDomainAxisEdge();
        ValueAxis rangeAxis = plot.getRangeAxis();
        RectangleEdge rangeAxisEdge = plot.getRangeAxisEdge();
        double coordinateX = domainAxis.java2DToValue(_investPoint.getX(), _plotArea, domainAxisEdge);
        int low = 0;
        int high = timeSeries.getItemCount() - 1;
        Date date = new Date((long)coordinateX);
        long time = date.getTime();
        long bestDistance = Long.MAX_VALUE;
        int bestMid = 0;
        while (low <= high) {
            long abs_cmp;
            int mid = low + high >>> 1;
            TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(mid);
            Day day = (Day)timeSeriesDataItem.getPeriod();
            long search = day.getFirstMillisecond();
            long cmp = search - time;
            if (cmp < 0L) {
                low = mid + 1;
            } else if (cmp > 0L) {
                high = mid - 1;
            } else {
                bestDistance = 0L;
                bestMid = mid;
                break;
            }
            if ((abs_cmp = Math.abs(cmp)) >= bestDistance) continue;
            bestDistance = abs_cmp;
            bestMid = mid;
        }
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(bestMid);
        double xValue = timeSeriesDataItem.getPeriod().getFirstMillisecond();
        double yValue = timeSeriesDataItem.getValue().doubleValue();
        double xJava2D = domainAxis.valueToJava2D(xValue, _plotArea, domainAxisEdge);
        double yJava2D = rangeAxis.valueToJava2D(yValue, _plotArea, rangeAxisEdge);
        int tmpIndex = bestMid;
        Point2D.Double tmpPoint = new Point2D.Double(xJava2D, yJava2D);
        this.drawArea.setRect(_plotArea);
        if (this.drawArea.contains(tmpPoint)) {
            this.investPointIndex = tmpIndex;
            this.investPoint = tmpPoint;
            return true;
        }
        return false;
    }

    private void processEvent(MouseEvent e, JXLayer layer) {
        if (506 == e.getID()) {
            return;
        }
        if (500 == e.getID()) {
            this.investmentFlowChartJDialog.getChartPanel().requestFocus();
        }
        Point mousePoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), (Component)layer);
        boolean status0 = this.updateInvestPoint(mousePoint);
        boolean status1 = this.updateROIPoint(mousePoint);
        if (status0 || status1) {
            this.setDirty(true);
        }
    }

    public void setDirty(boolean isDirty) {
        super.setDirty(isDirty);
    }

    private void drawBusyBox(Graphics2D g2, JXLayer<? extends V> layer) {
        Font oldFont;
        Font font = oldFont = g2.getFont();
        FontMetrics fontMetrics = g2.getFontMetrics(font);
        boolean imgWidth = false;
        boolean imgHeight = false;
        boolean imgMessageWidthMargin = false;
        String message = MessagesBundle.getString("info_message_retrieving_latest_stock_price");
        int maxWidth = 0 + fontMetrics.stringWidth(message);
        int maxHeight = Math.max(0, fontMetrics.getHeight());
        int padding = 5;
        int width = maxWidth + 10;
        int height = maxHeight + 10;
        int x = (int)this.drawArea.getX() + ((int)this.drawArea.getWidth() - width >> 1);
        int y = (int)this.drawArea.getY() + ((int)this.drawArea.getHeight() - height >> 1);
        Object oldValueAntiAlias = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Composite oldComposite = g2.getComposite();
        Color oldColor = g2.getColor();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(COLOR_BORDER);
        g2.drawRoundRect(x - 1, y - 1, width + 1, height + 1, 15, 15);
        g2.setColor(COLOR_BACKGROUND);
        g2.setComposite(Utils.makeComposite(0.75f));
        g2.fillRoundRect(x, y, width, height, 15, 15);
        g2.setComposite(oldComposite);
        g2.setColor(oldColor);
        g2.setFont(font);
        g2.setColor(COLOR_BLUE);
        int yy = y + (height - fontMetrics.getHeight() >> 1) + fontMetrics.getAscent();
        g2.setFont(font);
        g2.setColor(COLOR_BLUE);
        g2.drawString(message, x + 5 + 0 + 0, yy);
        g2.setColor(oldColor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldValueAntiAlias);
        g2.setFont(oldFont);
    }

    protected void paintLayer(Graphics2D g2, JXLayer<? extends V> layer) {
        Color oldColor;
        Object oldValueAntiAlias;
        int RADIUS;
        super.paintLayer(g2, layer);
        ChartPanel chartPanel = (ChartPanel)layer.getView();
        Rectangle2D _plotArea = chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
        this.drawArea.setRect(_plotArea);
        if (!this.investmentFlowChartJDialog.isFinishLookUpPrice()) {
            this.drawBusyBox(g2, layer);
        }
        if (this.investPoint != null) {
            RADIUS = 8;
            oldValueAntiAlias = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            oldColor = g2.getColor();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(COLOR_RED);
            g2.fillOval((int)(this.investPoint.getX() - 4.0 + 0.5), (int)(this.investPoint.getY() - 4.0 + 0.5), 8, 8);
            g2.setColor(oldColor);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldValueAntiAlias);
            this.updateInvestInformationBox(g2);
        }
        if (this.ROIPoint != null) {
            RADIUS = 8;
            oldValueAntiAlias = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            oldColor = g2.getColor();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(COLOR_BLUE);
            g2.fillOval((int)(this.ROIPoint.getX() - 4.0 + 0.5), (int)(this.ROIPoint.getY() - 4.0 + 0.5), 8, 8);
            g2.setColor(oldColor);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldValueAntiAlias);
            this.updateROIInformationBox(g2);
        }
        this.solveConflict();
        if (this.investPoint != null) {
            this.drawInformationBox(g2, this.investmentFlowChartJDialog.getInvestActivities(this.investPointIndex), this.investRect, this.investParams, this.investValues, GUIBundle.getString("InvestmentFlowLayerUI_Total_Invest"), this.totalInvestValue, COLOR_RED_BACKGROUND, COLOR_RED_BORDER);
        }
        if (this.ROIPoint != null) {
            this.drawInformationBox(g2, this.investmentFlowChartJDialog.getROIActivities(this.ROIPointIndex), this.ROIRect, this.ROIParams, this.ROIValues, GUIBundle.getString("InvestmentFlowLayerUI_Total_Return"), this.totalROIValue, COLOR_BLUE_BACKGROUND, COLOR_BLUE_BORDER);
        }
        this.drawTitle(g2);
    }

    private void solveConflict() {
        if (this.investPoint == null || this.ROIPoint == null) {
            return;
        }
        Rectangle ROIRectWithBorder = new Rectangle((Rectangle)this.ROIRect);
        Rectangle investRectWithBorder = new Rectangle((Rectangle)this.investRect);
        ROIRectWithBorder.setLocation((int)ROIRectWithBorder.getX() - 1, (int)ROIRectWithBorder.getY() - 1);
        ROIRectWithBorder.setSize((int)ROIRectWithBorder.getWidth() + 2, (int)ROIRectWithBorder.getHeight() + 2);
        investRectWithBorder.setLocation((int)investRectWithBorder.getX() - 1, (int)investRectWithBorder.getY() - 1);
        investRectWithBorder.setSize((int)investRectWithBorder.getWidth() + 2, (int)investRectWithBorder.getHeight() + 2);
        if (!ROIRectWithBorder.intersects(investRectWithBorder)) {
            return;
        }
        Rectangle oldROIRect = new Rectangle((Rectangle)this.ROIRect);
        Rectangle oldInvestRect = new Rectangle((Rectangle)this.investRect);
        if (this.ROIRect.getY() > this.investRect.getY()) {
            ((Rectangle)this.ROIRect).translate(0, (int)(this.investRect.getY() + this.investRect.getHeight() - this.ROIRect.getY() + 4.0));
        } else {
            ((Rectangle)this.investRect).translate(0, (int)(this.ROIRect.getY() + this.ROIRect.getHeight() - this.investRect.getY() + 4.0));
        }
        if (this.drawArea.getY() + this.drawArea.getHeight() > this.ROIRect.getY() + this.ROIRect.getHeight() && this.drawArea.getY() + this.drawArea.getHeight() > this.investRect.getY() + this.investRect.getHeight()) {
            return;
        }
        this.ROIRect.setRect(oldROIRect);
        this.investRect.setRect(oldInvestRect);
        if (this.ROIRect.getY() > this.investRect.getY()) {
            ((Rectangle)this.investRect).translate(0, -((int)(this.investRect.getY() + this.investRect.getHeight() - this.ROIRect.getY() + 4.0)));
        } else {
            ((Rectangle)this.ROIRect).translate(0, -((int)(this.ROIRect.getY() + this.ROIRect.getHeight() - this.investRect.getY() + 4.0)));
        }
        if (this.drawArea.getY() < this.ROIRect.getY() && this.drawArea.getY() < this.investRect.getY()) {
            return;
        }
        this.ROIRect.setRect(oldROIRect);
        this.investRect.setRect(oldInvestRect);
    }

    protected void processMouseEvent(MouseEvent e, JXLayer<? extends V> layer) {
        super.processMouseEvent(e, layer);
        this.processEvent(e, layer);
    }

    protected void processMouseMotionEvent(MouseEvent e, JXLayer<? extends V> layer) {
        super.processMouseMotionEvent(e, layer);
        this.processEvent(e, layer);
    }

    public void processKeyEvent(KeyEvent e, JXLayer<? extends V> l) {
        if (e.getID() != 401) {
            return;
        }
        int code = e.getKeyCode();
        switch (code) {
            case 37: {
                this.updatePointAndIndexIfPossible(-1);
                break;
            }
            case 39: {
                this.updatePointAndIndexIfPossible(1);
                break;
            }
            case 38: {
                this.investmentFlowChartJDialog.selectPreviousJComboBoxSelection();
                break;
            }
            case 40: {
                this.investmentFlowChartJDialog.selectNextJComboBoxSelection();
            }
        }
    }

    private void updatePointAndIndexIfPossible(int dataOffset) {
        Type updatedType = null;
        boolean needToReturnEarly = false;
        if (this.investPointIndex < 0) {
            this.investPointIndex = 0;
            this.investPoint = this.getPoint(this.investPointIndex, Type.Invest);
            this.updateInvestPoint();
            needToReturnEarly = true;
        }
        if (this.ROIPointIndex < 0) {
            this.ROIPointIndex = dataOffset + this.ROIPointIndex;
            this.ROIPoint = this.getPoint(this.ROIPointIndex, Type.ROI);
            this.updateROIPoint();
            needToReturnEarly = true;
        }
        if (needToReturnEarly) {
            return;
        }
        int tmpROIPointIndex = -1;
        int tmpInvestPointIndex = -1;
        Point2D.Double tmpROIPoint = null;
        Point2D.Double tmpInvestPoint = null;
        if (updatedType == null) {
            tmpROIPointIndex = dataOffset + this.ROIPointIndex;
            tmpInvestPointIndex = dataOffset + this.investPointIndex;
            tmpROIPoint = this.getPoint(tmpROIPointIndex, Type.ROI);
            tmpInvestPoint = this.getPoint(tmpInvestPointIndex, Type.Invest);
            if (tmpROIPoint == null) {
                if (tmpInvestPoint == null) {
                    return;
                }
                updatedType = Type.Invest;
            } else if (tmpInvestPoint == null) {
                assert (tmpROIPoint != null);
                updatedType = Type.ROI;
            } else {
                double d1;
                double d0 = Math.abs(((Point2D)tmpROIPoint).getX() - this.investPoint.getX());
                updatedType = d0 < (d1 = Math.abs(((Point2D)tmpInvestPoint).getX() - this.ROIPoint.getX())) ? Type.ROI : Type.Invest;
            }
        }
        assert (updatedType != null);
        if (updatedType == Type.ROI) {
            this.ROIPointIndex = dataOffset + this.ROIPointIndex;
            this.ROIPoint = tmpROIPoint != null ? tmpROIPoint : this.getPoint(this.ROIPointIndex, Type.ROI);
            this.updateROIPoint();
        } else {
            assert (updatedType == Type.Invest);
            this.investPointIndex = dataOffset + this.investPointIndex;
            this.investPoint = tmpInvestPoint != null ? tmpInvestPoint : this.getPoint(this.investPointIndex, Type.Invest);
            this.updateInvestPoint();
        }
    }

    private Point2D.Double getPoint(int dataIndex, Type type) {
        TimeSeriesCollection timeSeriesCollection;
        if (dataIndex < 0) {
            return null;
        }
        ChartPanel chartPanel = this.investmentFlowChartJDialog.getChartPanel();
        JFreeChart chart = chartPanel.getChart();
        XYPlot plot = (XYPlot)chart.getPlot();
        if (type == Type.Invest) {
            timeSeriesCollection = (TimeSeriesCollection)plot.getDataset(0);
        } else {
            assert (type == Type.ROI);
            timeSeriesCollection = (TimeSeriesCollection)plot.getDataset(1);
        }
        TimeSeries timeSeries = timeSeriesCollection.getSeries(0);
        if (dataIndex >= timeSeries.getItemCount()) {
            return null;
        }
        ValueAxis domainAxis = plot.getDomainAxis();
        RectangleEdge domainAxisEdge = plot.getDomainAxisEdge();
        ValueAxis rangeAxis = plot.getRangeAxis();
        RectangleEdge rangeAxisEdge = plot.getRangeAxisEdge();
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(dataIndex);
        double xValue = timeSeriesDataItem.getPeriod().getFirstMillisecond();
        double yValue = timeSeriesDataItem.getValue().doubleValue();
        Rectangle2D plotArea = chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
        double xJava2D = domainAxis.valueToJava2D(xValue, plotArea, domainAxisEdge);
        double yJava2D = rangeAxis.valueToJava2D(yValue, plotArea, rangeAxisEdge);
        return new Point2D.Double(xJava2D, yJava2D);
    }

    private static enum Type {
        Invest,
        ROI;

    }
}

