/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.portfolio;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.yccheok.jstock.gui.portfolio.CalcLogic;
import org.yccheok.jstock.internationalization.GUIBundle;

public class Calc
extends JDialog {
    private static final Font BIGGER_FONT = new Font("monspaced", 0, 20);
    private JTextField _displayField;
    private boolean _startNumber = true;
    private String _previousOp = "=";
    private CalcLogic _logic = new CalcLogic();
    private final DecimalFormat decimalFormat = new DecimalFormat("0.00######");

    public Calc(Frame parent, boolean modal) {
        super(parent, modal);
        this._displayField = new JTextField("0", 12);
        this._displayField.setEditable(false);
        this._displayField.setHorizontalAlignment(4);
        this._displayField.setFont(BIGGER_FONT);
        JButton clearButton = new JButton("Clear");
        clearButton.setFont(BIGGER_FONT);
        clearButton.addActionListener(new ClearListener());
        NumListener numListener = new NumListener();
        String buttonOrder = "7894561230 .";
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(5, 3, 2, 2));
        for (int i = 0; i < buttonOrder.length(); ++i) {
            String keyTop = buttonOrder.substring(i, i + 1);
            JButton b = new JButton(keyTop);
            if (keyTop.equals(" ")) {
                b.setEnabled(false);
            } else {
                b.addActionListener(numListener);
                b.setFont(BIGGER_FONT);
            }
            buttonPanel.add(b);
        }
        OpListener opListener = new OpListener();
        JPanel opPanel = new JPanel();
        opPanel.setLayout(new GridLayout(5, 1, 2, 2));
        String[] opOrder = new String[]{"+", "-", "*", "/", "="};
        for (int i = 0; i < opOrder.length; ++i) {
            JButton b = new JButton(opOrder[i]);
            b.addActionListener(opListener);
            b.setFont(BIGGER_FONT);
            opPanel.add(b);
        }
        JPanel clearPanel = new JPanel();
        clearPanel.setLayout(new FlowLayout());
        clearPanel.add(clearButton);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout(5, 5));
        content.add((Component)this._displayField, "North");
        content.add((Component)buttonPanel, "Center");
        content.add((Component)opPanel, "East");
        content.add((Component)clearPanel, "South");
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setContentPane(content);
        this.pack();
        this.setTitle(GUIBundle.getString("MainFrame_Calculator"));
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
        this.setDefaultCloseOperation(2);
    }

    private void actionClear() {
        this._startNumber = true;
        this._displayField.setText("0");
        this._previousOp = "=";
        this._logic.setTotal("0");
    }

    class ClearListener
    implements ActionListener {
        ClearListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Calc.this.actionClear();
        }
    }

    class NumListener
    implements ActionListener {
        NumListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String digit = e.getActionCommand();
            if (digit.equals(".") && Calc.this._displayField.getText().contains(digit)) {
                return;
            }
            if (Calc.this._startNumber) {
                Calc.this._displayField.setText(digit);
                Calc.this._startNumber = false;
            } else {
                Calc.this._displayField.setText(Calc.this._displayField.getText() + digit);
            }
        }
    }

    class OpListener
    implements ActionListener {
        OpListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Calc.this._startNumber) {
                Calc.this._previousOp = e.getActionCommand();
                return;
            }
            Calc.this._startNumber = true;
            try {
                String displayText = Calc.this._displayField.getText();
                if (Calc.this._previousOp.equals("=")) {
                    Calc.this._logic.setTotal(displayText);
                } else if (Calc.this._previousOp.equals("+")) {
                    Calc.this._logic.add(displayText);
                } else if (Calc.this._previousOp.equals("-")) {
                    Calc.this._logic.subtract(displayText);
                } else if (Calc.this._previousOp.equals("*")) {
                    Calc.this._logic.multiply(displayText);
                } else if (Calc.this._previousOp.equals("/")) {
                    Calc.this._logic.divide(displayText);
                }
                Calc.this._displayField.setText("" + Calc.this.decimalFormat.format(Calc.this._logic.getCurrentTotal()));
            }
            catch (NumberFormatException ex) {
                Calc.this.actionClear();
                Calc.this._displayField.setText("Error");
            }
            Calc.this._previousOp = e.getActionCommand();
        }
    }
}

