/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.portfolio;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.yccheok.jstock.charting.Utils;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.portfolio.Dividend;
import org.yccheok.jstock.portfolio.DividendSummary;

public class DividendSummaryBarChartJDialog
extends JDialog {
    private final List<StockInfo> stockInfos = new ArrayList<StockInfo>();
    private final ChartPanel chartPanel;
    private final DividendSummary dividendSummary;
    private JComboBox jComboBox1;
    private JPanel jPanel1;

    public DividendSummaryBarChartJDialog(Dialog parent, boolean modal, DividendSummary dividendSummary) {
        super(parent, modal);
        this.initComponents();
        Dimension dimension = JStock.instance().getUIOptions().getDimension("DIVIDEND_SUMMARY_BAR_CHART_JDIALOG");
        if (dimension != null) {
            this.setSize(dimension);
        }
        this.dividendSummary = dividendSummary;
        this.initJComboBox();
        JFreeChart freeChart = this.createBarChart(this.createDataset());
        this.chartPanel = new ChartPanel(freeChart, true, true, true, true, true);
        this.getContentPane().add((Component)this.chartPanel, "Center");
    }

    public DividendSummaryBarChartJDialog(Frame parent, boolean modal, DividendSummary dividendSummary) {
        super(parent, modal);
        this.initComponents();
        Dimension dimension = JStock.instance().getUIOptions().getDimension("DIVIDEND_SUMMARY_BAR_CHART_JDIALOG");
        if (dimension != null) {
            this.setSize(dimension);
        }
        this.dividendSummary = dividendSummary;
        this.initJComboBox();
        JFreeChart freeChart = this.createBarChart(this.createDataset());
        this.chartPanel = new ChartPanel(freeChart, true, true, true, true, true);
        this.getContentPane().add((Component)this.chartPanel, "Center");
    }

    private void initJComboBox() {
        int size = this.dividendSummary.size();
        HashSet<Code> codes = new HashSet<Code>();
        for (int i = size - 1; i >= 0; --i) {
            Dividend dividend = (Dividend)this.dividendSummary.get(i);
            StockInfo stockInfo = dividend.stockInfo;
            if (!codes.add(stockInfo.code)) continue;
            this.stockInfos.add(stockInfo);
        }
        Collections.sort(this.stockInfos, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((StockInfo)o1).symbol.toString().compareTo(((StockInfo)o2).symbol.toString());
            }
        });
        for (StockInfo stockInfo : this.stockInfos) {
            this.jComboBox1.addItem(stockInfo.symbol.toString());
        }
    }

    private ComboBoxModel getComboBoxModel() {
        return new DefaultComboBoxModel<String>(new String[]{GUIBundle.getString("DividendSummaryBarChartJDialog_AllStock(s)")});
    }

    private CategoryDataset createDataset() {
        HashMap<Integer, Double> m = new HashMap<Integer, Double>();
        int size = this.dividendSummary.size();
        for (int i = 0; i < size; ++i) {
            Code code;
            int selectedIndex;
            Dividend dividend = (Dividend)this.dividendSummary.get(i);
            if (dividend.amount <= 0.0 || (selectedIndex = this.jComboBox1.getSelectedIndex()) != 0 && !dividend.stockInfo.code.equals(code = this.stockInfos.get((int)(selectedIndex - 1)).code)) continue;
            int year = dividend.date.getYear();
            if (m.containsKey(year)) {
                m.put(year, (Double)m.get(year) + dividend.amount);
                continue;
            }
            m.put(year, dividend.amount);
        }
        ArrayList list = new ArrayList(m.keySet());
        Collections.sort(list);
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int year = (Integer)iterator.next();
            String category = "" + year;
            String series = this.jComboBox1.getSelectedItem().toString();
            dataset.addValue((Number)m.get(year), (Comparable)((Object)series), (Comparable)((Object)category));
        }
        return dataset;
    }

    private JFreeChart createBarChart(CategoryDataset dataset) {
        int size = ((DefaultCategoryDataset)dataset).getColumnCount();
        double total = 0.0;
        for (int i = 0; i < size; ++i) {
            total += ((DefaultCategoryDataset)dataset).getValue(0, i).doubleValue();
        }
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        String currencySymbol = jStockOptions.getCurrencySymbol(jStockOptions.getCountry());
        DecimalFormat currencyFormat = new DecimalFormat("'" + currencySymbol.replace("'", "''") + "'#,##0");
        String title = MessageFormat.format(GUIBundle.getString("DividendSummaryBarChartJDialog_DividendByYear_template"), this.jComboBox1.getSelectedItem(), currencyFormat.format(total));
        String domain_label = GUIBundle.getString("DividendSummaryBarChartJDialog_Year");
        String range_label = GUIBundle.getString("DividendSummaryBarChartJDialog_Dividend");
        JFreeChart freeChart = ChartFactory.createBarChart((String)title, (String)domain_label, (String)range_label, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        Utils.applyChartTheme(freeChart);
        NumberAxis rangeAxis1 = (NumberAxis)((CategoryPlot)freeChart.getPlot()).getRangeAxis();
        rangeAxis1.setNumberFormatOverride((NumberFormat)currencyFormat);
        return freeChart;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("DividendSummaryBarChartJDialog_DividendByYear"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                DividendSummaryBarChartJDialog.this.formWindowClosed(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout(5, 5));
        this.jComboBox1.setModel(this.getComboBoxModel());
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DividendSummaryBarChartJDialog.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jComboBox1, "East");
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.setSize(new Dimension(700, 500));
        this.setLocationRelativeTo(null);
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.chartPanel.setChart(this.createBarChart(this.createDataset()));
    }

    private void formWindowClosed(WindowEvent evt) {
        JStock.instance().getUIOptions().setDimension("DIVIDEND_SUMMARY_BAR_CHART_JDIALOG", this.getSize());
    }
}

