/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javafx.concurrent.Task;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.StringConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.gui.trading.LiveAccSignUp;
import org.yccheok.jstock.gui.trading.Portfolio;
import org.yccheok.jstock.trading.api.Instrument;
import org.yccheok.jstock.trading.api.InstrumentManager;

public class GUIUtils {
    private static final Log log = LogFactory.getLog(GUIUtils.class);
    public static final PseudoClass upCell = PseudoClass.getPseudoClass((String)"up-cell-color");
    public static final PseudoClass downCell = PseudoClass.getPseudoClass((String)"down-cell-color");
    public static final PseudoClass newRow = PseudoClass.getPseudoClass((String)"new-row");

    private GUIUtils() {
    }

    public static void setDlgTitleHeader(Dialog dlg, String title, String header) {
        dlg.initModality(Modality.APPLICATION_MODAL);
        Scene scene = dlg.getDialogPane().getScene();
        scene.getStylesheets().add((Object)GUIUtils.class.getResource("/css/trading.css").toExternalForm());
        dlg.setTitle(title);
        dlg.setHeaderText(header);
        GUIUtils.setDlgIcon(scene);
    }

    public static void setDlgTitleHeaderLogo(Dialog dlg, String title, String header, String logoURL) {
        GUIUtils.setDlgTitleHeader(dlg, title, header);
        GUIUtils.setDlgGraphic(dlg, logoURL);
    }

    public static void setDlgGraphic(Dialog dlg, String logoURL) {
        ImageView stockLogo = new ImageView();
        stockLogo.setFitWidth(50.0);
        stockLogo.setFitHeight(50.0);
        if (logoURL != null && !logoURL.isEmpty()) {
            stockLogo.setImage(Portfolio.getInstance().getIcon(logoURL));
        }
        dlg.setGraphic((Node)stockLogo);
    }

    public static void setDlgContent(Dialog dlg, Node content, String headerNote, String footerNote) {
        VBox vBox = new VBox();
        vBox.setSpacing(10.0);
        if (headerNote != null) {
            Label headerLabel = new Label("* " + headerNote);
            headerLabel.getStyleClass().add((Object)"bold-italic");
            vBox.getChildren().add((Object)headerLabel);
        }
        vBox.getChildren().add((Object)content);
        if (footerNote != null) {
            Label footerLabel = new Label("* " + footerNote);
            footerLabel.getStyleClass().add((Object)"bold-italic");
            vBox.getChildren().add((Object)footerLabel);
        }
        StackPane stack = new StackPane();
        stack.getChildren().add((Object)vBox);
        dlg.getDialogPane().setContent((Node)stack);
    }

    public static void dlgShowProgressIn(Dialog dlg) {
        DialogPane dlgPane = dlg.getDialogPane();
        StackPane stack = (StackPane)dlgPane.getContent();
        VBox vBox = (VBox)stack.getChildren().get(0);
        ProgressIndicator pi = new ProgressIndicator();
        pi.setMaxWidth(50.0);
        stack.getChildren().add((Object)pi);
        vBox.setDisable(true);
        int i = 0;
        while (i < dlgPane.getButtonTypes().size()) {
            Node btn = dlgPane.lookupButton((ButtonType)dlgPane.getButtonTypes().get(i++));
            btn.disableProperty().unbind();
            btn.setDisable(true);
        }
    }

    public static void dlgRemoveProgressIn(Dialog dlg) {
        DialogPane dlgPane = dlg.getDialogPane();
        StackPane stack = (StackPane)dlgPane.getContent();
        VBox vBox = (VBox)stack.getChildren().get(0);
        stack.getChildren().remove(1);
        vBox.setDisable(false);
        int i = 0;
        while (i < dlgPane.getButtonTypes().size()) {
            Node btn = dlgPane.lookupButton((ButtonType)dlgPane.getButtonTypes().get(i++));
            btn.disableProperty().unbind();
            btn.setDisable(false);
        }
    }

    public static void browserURLHandler(ButtonBase node, String url) {
        node.setOnAction(e -> GUIUtils.openURLInBrowser(url));
    }

    public static boolean openURLInBrowser(String url) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI(url));
                return true;
            }
            catch (IOException | URISyntaxException e) {
                log.error(null, (Throwable)e);
            }
        }
        return false;
    }

    public static void setDlgIcon(Scene scene) {
        Stage stage = (Stage)scene.getWindow();
        stage.getIcons().add((Object)new Image(GUIUtils.class.getResource("/images/16x16/drivewealth_logo.png").toString()));
    }

    public static Alert alertDlg(Alert.AlertType type, String title, String header, String content) {
        Alert dlg = new Alert(type);
        DialogPane dlgPane = dlg.getDialogPane();
        dlgPane.getStylesheets().add((Object)GUIUtils.class.getResource("/css/trading.css").toExternalForm());
        GUIUtils.setDlgIcon(dlgPane.getScene());
        dlg.setTitle(title);
        dlgPane.setContentText(content);
        if (header != null) {
            dlg.setHeaderText(header);
        }
        return dlg;
    }

    public static Node getNodeFromGridPane(GridPane gridPane, int row, int col) {
        for (Node node : gridPane.getChildren()) {
            if (GridPane.getColumnIndex((Node)node) != col || GridPane.getRowIndex((Node)node) != row) continue;
            return node;
        }
        return null;
    }

    public static DatePicker setDatePickerFormat(DatePicker datePicker) {
        final String pattern = "yyyy-MM-dd";
        datePicker.setPromptText(pattern.toLowerCase());
        datePicker.setConverter((StringConverter)new StringConverter<LocalDate>(){
            DateTimeFormatter dateFormatter;
            {
                this.dateFormatter = DateTimeFormatter.ofPattern(pattern);
            }

            public String toString(LocalDate date) {
                if (date != null) {
                    return this.dateFormatter.format(date);
                }
                return "";
            }

            public LocalDate fromString(String string) {
                if (string != null && !string.isEmpty()) {
                    return LocalDate.parse(string, this.dateFormatter);
                }
                return null;
            }
        });
        return datePicker;
    }

    public static Task<Instrument> startInstrumentTask(final String symbol) {
        Task<Instrument> task = new Task<Instrument>(){

            protected Instrument call() throws Exception {
                List<Instrument> insList = InstrumentManager.searchExactSymbol(symbol);
                if (insList != null && !insList.isEmpty()) {
                    Instrument ins = insList.get(0);
                    return ins;
                }
                return null;
            }
        };
        Thread thread = new Thread((Runnable)task);
        thread.start();
        return task;
    }

    public static void numbersOnly(TextField textField) {
        textField.addEventFilter(KeyEvent.KEY_TYPED, event -> {
            if (event.getSource() instanceof TextField) {
                TextField txt = (TextField)event.getSource();
                if (!event.getCharacter().matches("[0-9.]")) {
                    event.consume();
                }
            }
        });
        textField.focusedProperty().addListener((observable, oldVal, newVal) -> textField.setText(textField.getText().trim()));
    }

    public static void openLiveAccHandler(Button button) {
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                LiveAccSignUp signUp = new LiveAccSignUp();
                signUp.showAndWait();
            }
        });
    }
}

