/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import org.yccheok.jstock.gui.trading.CreateOrderDlg;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.Utils;
import org.yccheok.jstock.trading.api.Commission;
import org.yccheok.jstock.trading.api.Order;
import org.yccheok.jstock.trading.api.OrderManager;
import org.yccheok.jstock.trading.api.SessionManager;

public class OrderSummary {
    private final SimpleStringProperty symbol;
    private final SimpleStringProperty action;
    private final SimpleStringProperty ordName;
    private final SimpleStringProperty qty;
    private final SimpleStringProperty price;
    private final SimpleStringProperty subtotal;
    private final SimpleStringProperty commission;
    private final SimpleStringProperty total;
    public final boolean estimated;
    public final OrderManager.OrderType ordType;
    public final OrderManager.OrderSide ordSide;
    public final String name;
    public final String instrumentID;
    public final CreateOrderDlg.AmountQty amountQty;
    public final String logoURL;

    public OrderSummary(boolean estimated, CreateOrderDlg.AmountQty shareCash, String symbol, String name, String logoURL, String instrumentID, OrderManager.OrderSide side, OrderManager.OrderType ordType, Double qty, Double price, Double subtotal, Double commission, Double total) {
        this.estimated = estimated;
        this.amountQty = shareCash;
        this.ordType = ordType;
        this.ordSide = side;
        this.name = name;
        this.logoURL = logoURL;
        this.instrumentID = instrumentID;
        this.symbol = new SimpleStringProperty(symbol);
        this.action = new SimpleStringProperty(side.toString());
        this.ordName = new SimpleStringProperty(ordType.toString());
        this.qty = new SimpleStringProperty(Utils.formatNumber(qty, 4));
        this.price = new SimpleStringProperty(Utils.monetaryFormat(price));
        this.subtotal = new SimpleStringProperty(Utils.monetaryFormat(subtotal));
        this.commission = new SimpleStringProperty(Utils.monetaryFormat(commission));
        this.total = new SimpleStringProperty(Utils.monetaryFormat(total));
    }

    public String getSymbol() {
        return this.symbol.get();
    }

    public void setSymbol(String v) {
        this.symbol.set(v);
    }

    public SimpleStringProperty symbolProperty() {
        return this.symbol;
    }

    public String getAction() {
        return this.action.get();
    }

    public void setAction(String v) {
        this.action.set(v);
    }

    public SimpleStringProperty actionProperty() {
        return this.action;
    }

    public String getOrdName() {
        return this.ordName.get();
    }

    public void setOrdName(String v) {
        this.ordName.set(v);
    }

    public SimpleStringProperty ordNameProperty() {
        return this.ordName;
    }

    public String getQty() {
        return this.qty.get();
    }

    public void setQty(String v) {
        this.qty.set(v);
    }

    public SimpleStringProperty qtyProperty() {
        return this.qty;
    }

    public String getPrice() {
        return this.price.get();
    }

    public void setPrice(String v) {
        this.price.set(v);
    }

    public SimpleStringProperty priceProperty() {
        return this.price;
    }

    public String getSubtotal() {
        return this.subtotal.get();
    }

    public void setSubtotal(String v) {
        this.subtotal.set(v);
    }

    public SimpleStringProperty subtotalProperty() {
        return this.subtotal;
    }

    public String getCommission() {
        return this.commission.get();
    }

    public void setCommission(String v) {
        this.commission.set(v);
    }

    public SimpleStringProperty commissionProperty() {
        return this.commission;
    }

    public String getTotal() {
        return this.total.get();
    }

    public void setTotal(String v) {
        this.total.set(v);
    }

    public SimpleStringProperty totalProperty() {
        return this.total;
    }

    public static OrderSummary buildFromDialog(String symbol, String name, String logoURL, String instrumentID, CreateOrderDlg.AmountQty shareCash, Double share, Double cash, Double price, OrderManager.OrderType ordType, OrderManager.OrderSide side) {
        Double subtotal;
        Double qty;
        if (shareCash == null || shareCash == CreateOrderDlg.AmountQty.QTY) {
            qty = share;
            subtotal = share * price;
        } else {
            subtotal = cash;
            qty = cash / price;
        }
        Commission rate = SessionManager.getInstance().getUser().getCommission();
        Double commission = Commission.calcCommission(qty, rate);
        Double total = side == OrderManager.OrderSide.BUY ? Double.valueOf(subtotal + commission) : Double.valueOf(subtotal - commission);
        return new OrderSummary(true, shareCash, symbol, name, logoURL, instrumentID, side, ordType, qty, price, subtotal, commission, total);
    }

    public static OrderSummary buildFromOrder(OrderSummary summary, Order order) {
        Double qty = order.orderQty;
        Double subtotal = order.grossTradeAmt;
        Double commission = order.commission;
        Double price = subtotal / qty;
        Double total = summary.ordSide == OrderManager.OrderSide.BUY ? Double.valueOf(subtotal + commission) : Double.valueOf(subtotal - commission);
        return new OrderSummary(false, null, summary.getSymbol(), summary.name, summary.logoURL, summary.instrumentID, summary.ordSide, summary.ordType, qty, price, subtotal, commission, total);
    }

    public static TableView OrdSummaryTable(OrderSummary ordSummary) {
        String qtyTitle = DriveWealthBundle.getString("Quantity");
        String subtotalTitle = DriveWealthBundle.getString("Subtotal");
        if (ordSummary.estimated) {
            if (ordSummary.amountQty == null || ordSummary.amountQty == CreateOrderDlg.AmountQty.QTY) {
                subtotalTitle = DriveWealthBundle.getString("Est_subtotal");
            } else {
                qtyTitle = DriveWealthBundle.getString("Est_quantity");
            }
        }
        TableColumn productCol = new TableColumn(DriveWealthBundle.getString("Product"));
        productCol.setCellValueFactory((Callback)new PropertyValueFactory("symbol"));
        TableColumn actionCol = new TableColumn(DriveWealthBundle.getString("Action"));
        actionCol.setCellValueFactory((Callback)new PropertyValueFactory("action"));
        TableColumn ordTypeCol = new TableColumn(DriveWealthBundle.getString("Order_type"));
        ordTypeCol.setCellValueFactory((Callback)new PropertyValueFactory("ordName"));
        TableColumn qtyCol = new TableColumn(qtyTitle);
        qtyCol.setCellValueFactory((Callback)new PropertyValueFactory("qty"));
        TableColumn priceCol = new TableColumn(DriveWealthBundle.getString("Price"));
        priceCol.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        TableColumn subtotalCol = new TableColumn(subtotalTitle);
        subtotalCol.setCellValueFactory((Callback)new PropertyValueFactory("subtotal"));
        String comm = ordSummary.estimated ? DriveWealthBundle.getString("Est_commission") : DriveWealthBundle.getString("Commission");
        TableColumn commCol = new TableColumn(comm);
        commCol.setCellValueFactory((Callback)new PropertyValueFactory("commission"));
        String total = ordSummary.estimated ? DriveWealthBundle.getString("Est_total") : DriveWealthBundle.getString("Total");
        TableColumn totalCol = new TableColumn(total);
        totalCol.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        TableView table = new TableView();
        table.getColumns().addAll(new Object[]{productCol, actionCol, ordTypeCol, qtyCol, priceCol, subtotalCol, commCol, totalCol});
        table.setEditable(false);
        ObservableList resultList = FXCollections.observableArrayList((Object[])new OrderSummary[]{ordSummary});
        table.setItems(resultList);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        table.setFixedCellSize(30.0);
        table.setPrefHeight(80.0);
        table.setMaxHeight(80.0);
        table.setPrefWidth(900.0);
        table.setMaxWidth(900.0);
        return table;
    }
}

