/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.trading.AccApplicationIncomplete;
import org.yccheok.jstock.gui.trading.AccountSummaryHeader;
import org.yccheok.jstock.gui.trading.OrdersTable;
import org.yccheok.jstock.gui.trading.PositionsTable;
import org.yccheok.jstock.gui.trading.Profile;
import org.yccheok.jstock.gui.trading.Report;
import org.yccheok.jstock.gui.trading.StocksComboBox;
import org.yccheok.jstock.gui.trading.TxnNotification;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.AccountSummary;
import org.yccheok.jstock.trading.PortfolioService;
import org.yccheok.jstock.trading.Transaction;
import org.yccheok.jstock.trading.api.Instrument;
import org.yccheok.jstock.trading.api.MarketDataManager;
import org.yccheok.jstock.trading.api.SessionManager;

public class Portfolio {
    private static final Log log = LogFactory.getLog(Portfolio.class);
    private static final Portfolio INSTANCE = new Portfolio();
    private final Map<String, Instrument> instruments = new HashMap<String, Instrument>();
    private Map<String, Double> marketPrices;
    private PortfolioService service = null;
    private VBox vBox;
    private StackPane stackPane;
    private SplitPane splitPane;
    private VBox PortfolioBox;
    private Node profileBox;
    private Node reportBox;
    private Node accApplicationBox;
    public StocksComboBox stocksCombo;
    private final Map<String, Image> icons = new HashMap<String, Image>();
    public static final double TABLE_CELL_SIZE = 30.0;
    public static final double ICON_SIZE = 25.0;
    private Date lastTxnDate = null;

    private Portfolio() {
    }

    public static Portfolio getInstance() {
        return INSTANCE;
    }

    public Node show() {
        this.initUI();
        this.initService();
        this.initLastTxnDate();
        this.showAccStatusIfIncomplete();
        return this.vBox;
    }

    private void initUI() {
        this.vBox = new VBox();
        this.vBox.setSpacing(1.0);
        this.vBox.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        this.vBox.setPrefWidth(1000.0);
        Node accNode = AccountSummaryHeader.getInstance().show();
        this.vBox.getChildren().add((Object)accNode);
        HBox searchBox = new HBox();
        searchBox.setSpacing(10.0);
        searchBox.setAlignment(Pos.CENTER);
        searchBox.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
        Label searchLbl = new Label(DriveWealthBundle.getString("Stock"));
        this.stocksCombo = new StocksComboBox();
        ProgressIndicator pi = this.stocksCombo.getPi();
        searchBox.getChildren().addAll((Object[])new Node[]{searchLbl, this.stocksCombo, pi});
        TableView posTable = PositionsTable.getInstance().show();
        VBox vboxOpenPos = new VBox(5.0);
        vboxOpenPos.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Label posLabel = new Label(DriveWealthBundle.getString("Current_investments"));
        vboxOpenPos.getChildren().addAll((Object[])new Node[]{posLabel, posTable});
        TableView ordTable = OrdersTable.getInstance().show();
        VBox vboxOrder = new VBox(5.0);
        vboxOrder.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Label ordLabel = new Label(DriveWealthBundle.getString("Pending_orders"));
        vboxOrder.getChildren().addAll((Object[])new Node[]{ordLabel, ordTable});
        this.splitPane = new SplitPane();
        this.splitPane.setOrientation(Orientation.VERTICAL);
        this.splitPane.setDividerPositions(new double[]{0.6});
        this.splitPane.getItems().addAll((Object[])new Node[]{vboxOpenPos, vboxOrder});
        this.splitPane.setPrefHeight(500.0);
        this.PortfolioBox = new VBox();
        this.PortfolioBox.getChildren().addAll((Object[])new Node[]{searchBox, this.splitPane});
        this.stackPane = new StackPane();
        this.stackPane.getChildren().add((Object)this.PortfolioBox);
        this.vBox.getChildren().add((Object)this.stackPane);
        vboxOpenPos.prefWidthProperty().bind((ObservableValue)this.splitPane.widthProperty());
        vboxOrder.prefWidthProperty().bind((ObservableValue)this.splitPane.widthProperty());
    }

    public void resetTablesModel() {
        this.cancelService();
        PositionsTable.getInstance().setTableModel();
        OrdersTable.getInstance().setTableModel();
        this.initService();
        this.initLastTxnDate();
    }

    private void initLastTxnDate() {
        String accountID = SessionManager.getInstance().getUser().getActiveAccount().accountID;
        Long timestamp = JStock.instance().getJStockOptions().getDriveWealthLastTxnTimestamp(accountID);
        this.lastTxnDate = timestamp == null ? null : new Date(timestamp);
    }

    public void stopAll() {
        this.cancelService();
        this.stocksCombo.stop();
    }

    public void cancelService() {
        if (Platform.isFxApplicationThread()) {
            this.service.cancel();
        } else {
            Platform.runLater(() -> this.service.cancel());
        }
    }

    public void restartService() {
        this.service.setPeriod(Duration.ZERO);
        this.service.setDelay(Duration.millis((double)500.0));
        if (Platform.isFxApplicationThread()) {
            this.service.restart();
        } else {
            Platform.runLater(() -> this.service.restart());
        }
    }

    public void initService() {
        if (this.service != null) {
            this.service.cancel();
        }
        this.service = new PortfolioService(SessionManager.getInstance().getUser());
        this.setSucceedHandler(this.service);
        this.setFailedHandler(this.service);
        this.service.start();
    }

    private void setSucceedHandler(final PortfolioService service) {
        service.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent workerStateEvent) {
                Map result = (Map)workerStateEvent.getSource().getValue();
                if (result == null) {
                    log.error((Object)"Portfolio Service OnSucceed Handler - return NULL result");
                    return;
                }
                PortfolioService.TaskState state = (PortfolioService.TaskState)((Object)result.get("state"));
                MarketDataManager.MarketState marketState = null;
                if (result.containsKey("marketPrices")) {
                    Portfolio.this.marketPrices = (Map)result.get("marketPrices");
                    marketState = (MarketDataManager.MarketState)((Object)result.get("marketState"));
                }
                if (state == PortfolioService.TaskState.ACC_BLOTTER) {
                    List posList = (List)result.get("posList");
                    List ordList = (List)result.get("ordList");
                    List<Transaction> txnList = (List<Transaction>)result.get("txnList");
                    AccountSummary accModel = (AccountSummary)result.get("accModel");
                    PositionsTable.getInstance().initData(posList, Portfolio.this.instruments);
                    OrdersTable.getInstance().initData(ordList, Portfolio.this.instruments, Portfolio.this.marketPrices);
                    AccountSummaryHeader.getInstance().initData(accModel);
                    if (Portfolio.this.lastTxnDate != null) {
                        txnList = Transaction.getTransactionsAfter(txnList, Portfolio.this.lastTxnDate);
                    }
                    if (!txnList.isEmpty()) {
                        TxnNotification.getInstance().show(txnList);
                        Transaction lastTxn = txnList.get(txnList.size() - 1);
                        Portfolio.this.lastTxnDate = lastTxn.updatedWhen != null ? lastTxn.updatedWhen : lastTxn.createdWhen;
                        String accID = SessionManager.getInstance().getUser().getActiveAccount().accountID;
                        if (Portfolio.this.lastTxnDate != null) {
                            JStock.instance().getJStockOptions().setDriveWealthLastTxnTimestamp(accID, Portfolio.this.lastTxnDate.getTime());
                        }
                    }
                } else {
                    if (state == PortfolioService.TaskState.INSTRUMENTS) {
                        Map ins = (Map)result.get("instruments");
                        Portfolio.this.instruments.putAll(ins);
                        PositionsTable.getInstance().updateNameUrl(Portfolio.this.instruments);
                        OrdersTable.getInstance().updateNameUrl(Portfolio.this.instruments);
                    }
                    if (marketState != null && marketState == MarketDataManager.MarketState.OPEN) {
                        PositionsTable.getInstance().updatePrices(Portfolio.this.marketPrices);
                        OrdersTable.getInstance().updatePrices(Portfolio.this.marketPrices);
                        AccountSummaryHeader.getInstance().update(PositionsTable.getInstance().getPosList());
                    }
                }
                JStock.instance().updateStatusBarWithLastUpdateDateMessageIfPossible();
                service.updateTaskState();
            }
        });
    }

    private void setFailedHandler(PortfolioService service) {
        service.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent ev) {
                log.error((Object)("Portfolio Service - OnFailed Handler : " + ev));
            }
        });
    }

    public void showAccStatusIfIncomplete() {
        this.accApplicationBox = AccApplicationIncomplete.getInstance().show();
        if (this.accApplicationBox != null) {
            this.stackPane.getChildren().add((Object)this.accApplicationBox);
        }
    }

    public void removeAccStatusIfExist() {
        if (this.accApplicationBox != null && this.stackPane.getChildren().contains((Object)this.accApplicationBox)) {
            this.stackPane.getChildren().remove((Object)this.accApplicationBox);
        }
        this.accApplicationBox = null;
    }

    public void showProfile() {
        if (this.profileBox != null && this.stackPane.getChildren().contains((Object)this.profileBox)) {
            return;
        }
        this.profileBox = Profile.getInstance().show();
        this.stackPane.getChildren().add((Object)this.profileBox);
    }

    public void removeProfileIfShowing() {
        if (this.profileBox != null && this.stackPane.getChildren().contains((Object)this.profileBox)) {
            this.stackPane.getChildren().remove((Object)this.profileBox);
        }
        this.profileBox = null;
    }

    public void showReport() {
        if (this.reportBox != null && this.stackPane.getChildren().contains((Object)this.reportBox)) {
            return;
        }
        this.reportBox = Report.getInstance().show();
        this.stackPane.getChildren().add((Object)this.reportBox);
    }

    public void removeReportIfShowing() {
        if (this.reportBox != null && this.stackPane.getChildren().contains((Object)this.reportBox)) {
            this.stackPane.getChildren().remove((Object)this.reportBox);
        }
        this.reportBox = null;
    }

    public Image getIcon(String url) {
        if (!this.icons.containsKey(url)) {
            this.icons.put(url, new Image(url, true));
        }
        return this.icons.get(url);
    }

    public Map<String, Instrument> getInstruments() {
        return this.instruments;
    }

    public long getTimestamp() {
        if (this.service == null) {
            return 0L;
        }
        return this.service.lastUpdateTimestamp;
    }
}

