/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.treetable;

import java.util.Arrays;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.currency.Currency;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.PortfolioManagementJPanel;
import org.yccheok.jstock.gui.treetable.AbstractPortfolioTreeTableModelEx;
import org.yccheok.jstock.gui.treetable.AbstractSortableTreeTableNode;
import org.yccheok.jstock.gui.treetable.DoubleWithCurrency;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.portfolio.Contract;
import org.yccheok.jstock.portfolio.DecimalPlace;
import org.yccheok.jstock.portfolio.DoubleWrapper;
import org.yccheok.jstock.portfolio.Portfolio;
import org.yccheok.jstock.portfolio.PortfolioRealTimeInfo;
import org.yccheok.jstock.portfolio.Transaction;
import org.yccheok.jstock.portfolio.TransactionSummary;
import org.yccheok.jstock.portfolio.Utils;

public class SellPortfolioTreeTableModelEx
extends AbstractPortfolioTreeTableModelEx {
    private PortfolioRealTimeInfo portfolioRealTimeInfo = new PortfolioRealTimeInfo();
    private PortfolioManagementJPanel portfolioManagementJPanel = null;
    private static final String[] columnNames;
    private static final Class[] cTypes;

    public void bind(PortfolioRealTimeInfo portfolioRealTimeInfo) {
        this.portfolioRealTimeInfo = portfolioRealTimeInfo;
        Portfolio portfolio = (Portfolio)this.getRoot();
        portfolio.bind(portfolioRealTimeInfo);
    }

    public void bind(PortfolioManagementJPanel portfolioManagementJPanel) {
        this.portfolioManagementJPanel = portfolioManagementJPanel;
    }

    public SellPortfolioTreeTableModelEx() {
        super(Arrays.asList(columnNames));
    }

    @Override
    public int getColumnCount() {
        assert (columnNames.length == cTypes.length);
        return columnNames.length;
    }

    @Override
    public Class getColumnClass(int column) {
        assert (columnNames.length == cTypes.length);
        return cTypes[column];
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    public double getGainLossPercentage(Currency localCurrency) {
        Portfolio portfolio = (Portfolio)this.getRoot();
        double referenceTotal = portfolio.getReferenceTotal(localCurrency);
        if (referenceTotal == 0.0) {
            return 0.0;
        }
        return (portfolio.getTotal(localCurrency) - referenceTotal) / referenceTotal * 100.0;
    }

    public double getGainLossValue(Currency localCurrency) {
        Portfolio portfolio = (Portfolio)this.getRoot();
        return portfolio.getTotal(localCurrency) - portfolio.getReferenceTotal(localCurrency);
    }

    public double getSellingValue(Currency localCurrency) {
        Portfolio portfolio = (Portfolio)this.getRoot();
        return portfolio.getTotal(localCurrency);
    }

    public double getNetSellingValue(Currency localCurrency) {
        Portfolio portfolio = (Portfolio)this.getRoot();
        return portfolio.getNetTotal(localCurrency);
    }

    public double getNetGainLossPercentage(Currency localCurrency) {
        Portfolio portfolio = (Portfolio)this.getRoot();
        double netReferenceTotal = portfolio.getNetReferenceTotal(localCurrency);
        if (netReferenceTotal == 0.0) {
            return 0.0;
        }
        return (portfolio.getNetTotal(localCurrency) - netReferenceTotal) / netReferenceTotal * 100.0;
    }

    public double getNetGainLossValue(Currency localCurrency) {
        Portfolio portfolio = (Portfolio)this.getRoot();
        return portfolio.getNetTotal(localCurrency) - portfolio.getNetReferenceTotal(localCurrency);
    }

    public double getSellingPrice(TransactionSummary transactionSummary) {
        if (transactionSummary.getQuantity() == 0.0) {
            return 0.0;
        }
        return transactionSummary.getTotal() / transactionSummary.getQuantity();
    }

    public double getPurchasePrice(TransactionSummary transactionSummary) {
        if (transactionSummary.getQuantity() == 0.0) {
            return 0.0;
        }
        return transactionSummary.getReferenceTotal() / transactionSummary.getQuantity();
    }

    public double getGainLossValue(TransactionSummary transactionSummary) {
        return transactionSummary.getTotal() - transactionSummary.getReferenceTotal();
    }

    public double getGainLossPercentage(TransactionSummary transactionSummary) {
        if (transactionSummary.getReferenceTotal() == 0.0) {
            return 0.0;
        }
        return (transactionSummary.getTotal() - transactionSummary.getReferenceTotal()) / transactionSummary.getReferenceTotal() * 100.0;
    }

    public double getNetGainLossValue(TransactionSummary transactionSummary) {
        return transactionSummary.getNetTotal() - transactionSummary.getNetReferenceTotal();
    }

    public double getNetGainLossPercentage(TransactionSummary transactionSummary) {
        if (transactionSummary.getNetReferenceTotal() == 0.0) {
            return 0.0;
        }
        return (transactionSummary.getNetTotal() - transactionSummary.getNetReferenceTotal()) / transactionSummary.getNetReferenceTotal() * 100.0;
    }

    public double getGainLossPrice(Transaction transaction) {
        if (transaction.getQuantity() == 0.0) {
            return 0.0;
        }
        return (transaction.getTotal() - transaction.getReferenceTotal()) / transaction.getQuantity();
    }

    public double getGainLossValue(Transaction transaction) {
        return transaction.getTotal() - transaction.getReferenceTotal();
    }

    public double getGainLossPercentage(Transaction transaction) {
        if (transaction.getReferenceTotal() == 0.0) {
            return 0.0;
        }
        return (transaction.getTotal() - transaction.getReferenceTotal()) / transaction.getReferenceTotal() * 100.0;
    }

    public double getNetGainLossValue(Transaction transaction) {
        return transaction.getNetTotal() - transaction.getNetReferenceTotal();
    }

    public double getNetGainLossPercentage(Transaction transaction) {
        if (transaction.getNetReferenceTotal() == 0.0) {
            return 0.0;
        }
        return (transaction.getNetTotal() - transaction.getNetReferenceTotal()) / transaction.getNetReferenceTotal() * 100.0;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        Currency stockCurrency;
        boolean shouldDisplayCurrencyForValue;
        boolean shouldConvertPenceToPound;
        Code code;
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        boolean isFeeCalculationEnabled = jStockOptions.isFeeCalculationEnabled();
        DecimalPlace decimalPlace = JStock.instance().getJStockOptions().getDecimalPlace();
        if (node instanceof Portfolio) {
            Currency localCurrency = Utils.getLocalCurrency();
            Portfolio portfolio = (Portfolio)node;
            switch (column) {
                case 0: {
                    return GUIBundle.getString("PortfolioManagementJPanel_Sell");
                }
                case 7: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(decimalPlace, portfolio.getNetTotal(localCurrency));
                    }
                    return new DoubleWrapper(decimalPlace, portfolio.getTotal(localCurrency));
                }
                case 8: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(decimalPlace, portfolio.getNetReferenceTotal(localCurrency));
                    }
                    return new DoubleWrapper(decimalPlace, portfolio.getReferenceTotal(localCurrency));
                }
                case 9: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(decimalPlace, this.getNetGainLossValue(localCurrency));
                    }
                    return new DoubleWrapper(decimalPlace, this.getGainLossValue(localCurrency));
                }
                case 10: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(DecimalPlace.Two, this.getNetGainLossPercentage(localCurrency));
                    }
                    return new DoubleWrapper(DecimalPlace.Two, this.getGainLossPercentage(localCurrency));
                }
                case 11: {
                    return new DoubleWrapper(decimalPlace, portfolio.getBroker());
                }
                case 12: {
                    return new DoubleWrapper(decimalPlace, portfolio.getClearingFee());
                }
                case 13: {
                    return new DoubleWrapper(decimalPlace, portfolio.getStampDuty());
                }
                case 14: {
                    return portfolio.getComment();
                }
            }
        }
        if (node instanceof TransactionSummary) {
            TransactionSummary transactionSummary = (TransactionSummary)node;
            if (transactionSummary.getChildCount() <= 0) {
                return null;
            }
            code = ((Transaction)transactionSummary.getChildAt((int)0)).getStockInfo().code;
            shouldConvertPenceToPound = Utils.shouldConvertPenceToPound(this.portfolioRealTimeInfo, code);
            shouldDisplayCurrencyForValue = this.portfolioManagementJPanel.shouldDisplayCurrencyForValue(code);
            stockCurrency = shouldDisplayCurrencyForValue ? Utils.getStockCurrency(this.portfolioRealTimeInfo, code) : null;
            switch (column) {
                case 0: {
                    return ((Transaction)transactionSummary.getChildAt((int)0)).getStockInfo().symbol;
                }
                case 1: {
                    return ((Transaction)transactionSummary.getChildAt((int)0)).getStockInfo().code;
                }
                case 4: {
                    return transactionSummary.getQuantity();
                }
                case 5: {
                    return new DoubleWrapper(decimalPlace, this.getSellingPrice(transactionSummary));
                }
                case 6: {
                    return new DoubleWrapper(decimalPlace, this.getPurchasePrice(transactionSummary));
                }
                case 7: {
                    if (!shouldConvertPenceToPound) {
                        if (isFeeCalculationEnabled) {
                            return DoubleWithCurrency.create(stockCurrency, decimalPlace, transactionSummary.getNetTotal());
                        }
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, transactionSummary.getTotal());
                    }
                    if (isFeeCalculationEnabled) {
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, transactionSummary.getNetTotal() / 100.0);
                    }
                    return DoubleWithCurrency.create(stockCurrency, decimalPlace, transactionSummary.getTotal() / 100.0);
                }
                case 8: {
                    if (!shouldConvertPenceToPound) {
                        if (isFeeCalculationEnabled) {
                            return DoubleWithCurrency.create(stockCurrency, decimalPlace, transactionSummary.getNetReferenceTotal());
                        }
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, transactionSummary.getReferenceTotal());
                    }
                    if (isFeeCalculationEnabled) {
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, transactionSummary.getNetReferenceTotal() / 100.0);
                    }
                    return DoubleWithCurrency.create(stockCurrency, decimalPlace, transactionSummary.getReferenceTotal() / 100.0);
                }
                case 9: {
                    if (!shouldConvertPenceToPound) {
                        if (isFeeCalculationEnabled) {
                            return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getNetGainLossValue(transactionSummary));
                        }
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getGainLossValue(transactionSummary));
                    }
                    if (isFeeCalculationEnabled) {
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getNetGainLossValue(transactionSummary) / 100.0);
                    }
                    return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getGainLossValue(transactionSummary) / 100.0);
                }
                case 10: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(DecimalPlace.Two, this.getNetGainLossPercentage(transactionSummary));
                    }
                    return new DoubleWrapper(DecimalPlace.Two, this.getGainLossPercentage(transactionSummary));
                }
                case 11: {
                    return new DoubleWrapper(decimalPlace, transactionSummary.getBroker());
                }
                case 12: {
                    return new DoubleWrapper(decimalPlace, transactionSummary.getClearingFee());
                }
                case 13: {
                    return new DoubleWrapper(decimalPlace, transactionSummary.getStampDuty());
                }
                case 14: {
                    return transactionSummary.getComment();
                }
            }
        }
        if (node instanceof Transaction) {
            Transaction transaction = (Transaction)node;
            code = transaction.getStockInfo().code;
            shouldConvertPenceToPound = Utils.shouldConvertPenceToPound(this.portfolioRealTimeInfo, code);
            shouldDisplayCurrencyForValue = this.portfolioManagementJPanel.shouldDisplayCurrencyForValue(code);
            stockCurrency = shouldDisplayCurrencyForValue ? Utils.getStockCurrency(this.portfolioRealTimeInfo, code) : null;
            switch (column) {
                case 0: {
                    return transaction.getStockInfo().symbol;
                }
                case 1: {
                    return transaction.getStockInfo().code;
                }
                case 2: {
                    return transaction.getDate();
                }
                case 3: {
                    return transaction.getReferenceDate();
                }
                case 4: {
                    return transaction.getQuantity();
                }
                case 5: {
                    return new DoubleWrapper(decimalPlace, transaction.getPrice());
                }
                case 6: {
                    return new DoubleWrapper(decimalPlace, transaction.getReferencePrice());
                }
                case 7: {
                    if (!shouldConvertPenceToPound) {
                        if (isFeeCalculationEnabled) {
                            return DoubleWithCurrency.create(stockCurrency, decimalPlace, transaction.getNetTotal());
                        }
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, transaction.getTotal());
                    }
                    if (isFeeCalculationEnabled) {
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, transaction.getNetTotal() / 100.0);
                    }
                    return DoubleWithCurrency.create(stockCurrency, decimalPlace, transaction.getTotal() / 100.0);
                }
                case 8: {
                    if (!shouldConvertPenceToPound) {
                        if (isFeeCalculationEnabled) {
                            return DoubleWithCurrency.create(stockCurrency, decimalPlace, transaction.getNetReferenceTotal());
                        }
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, transaction.getReferenceTotal());
                    }
                    if (isFeeCalculationEnabled) {
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, transaction.getNetReferenceTotal() / 100.0);
                    }
                    return DoubleWithCurrency.create(stockCurrency, decimalPlace, transaction.getReferenceTotal() / 100.0);
                }
                case 9: {
                    if (!shouldConvertPenceToPound) {
                        if (isFeeCalculationEnabled) {
                            return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getNetGainLossValue(transaction));
                        }
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getGainLossValue(transaction));
                    }
                    if (isFeeCalculationEnabled) {
                        return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getNetGainLossValue(transaction) / 100.0);
                    }
                    return DoubleWithCurrency.create(stockCurrency, decimalPlace, this.getGainLossValue(transaction) / 100.0);
                }
                case 10: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(DecimalPlace.Two, this.getNetGainLossPercentage(transaction));
                    }
                    return new DoubleWrapper(DecimalPlace.Two, this.getGainLossPercentage(transaction));
                }
                case 11: {
                    return new DoubleWrapper(decimalPlace, transaction.getBroker());
                }
                case 12: {
                    return new DoubleWrapper(decimalPlace, transaction.getClearingFee());
                }
                case 13: {
                    return new DoubleWrapper(decimalPlace, transaction.getStampDuty());
                }
                case 14: {
                    return transaction.getComment();
                }
            }
        }
        return null;
    }

    public void refreshRoot() {
        this.fireTreeTableNodeChanged(this.getRoot());
    }

    public boolean refresh(Code code) {
        Transaction transaction;
        Portfolio portfolio = (Portfolio)this.getRoot();
        int count = portfolio.getChildCount();
        AbstractSortableTreeTableNode transactionSummary = null;
        for (int i = 0; i < count; ++i) {
            TransactionSummary ts = (TransactionSummary)portfolio.getChildAt(i);
            assert (ts.getChildCount() > 0);
            transaction = (Transaction)ts.getChildAt(0);
            if (!transaction.getStockInfo().code.equals(code)) continue;
            transactionSummary = ts;
            break;
        }
        if (null == transactionSummary) {
            return false;
        }
        int num = transactionSummary.getChildCount();
        if (num == 0) {
            return false;
        }
        for (int i = 0; i < num; ++i) {
            transaction = (Transaction)transactionSummary.getChildAt(i);
            this.modelSupport.fireChildChanged(new TreePath(this.getPathToRoot((TreeTableNode)transaction)), i, (Object)transaction);
        }
        this.fireTreeTableNodeChanged((TreeTableNode)transactionSummary);
        this.fireTreeTableNodeChanged(this.getRoot());
        return true;
    }

    @Override
    public boolean isValidTransaction(Transaction transaction) {
        return transaction.getType() == Contract.Type.Sell;
    }

    static {
        String[] tmp = new String[]{GUIBundle.getString("PortfolioManagementJPanel_Stock"), GUIBundle.getString("PortfolioManagementJPanel_Code"), GUIBundle.getString("PortfolioManagementJPanel_Date"), GUIBundle.getString("PortfolioManagementJPanel_ReferenceDate"), GUIBundle.getString("PortfolioManagementJPanel_Units"), GUIBundle.getString("PortfolioManagementJPanel_SellingPrice"), GUIBundle.getString("PortfolioManagementJPanel_PurchasePrice"), GUIBundle.getString("PortfolioManagementJPanel_SellingValue"), GUIBundle.getString("PortfolioManagementJPanel_PurchaseValue"), GUIBundle.getString("PortfolioManagementJPanel_GainLossValue"), GUIBundle.getString("PortfolioManagementJPanel_GainLossPercentage"), GUIBundle.getString("PortfolioManagementJPanel_Broker"), GUIBundle.getString("PortfolioManagementJPanel_ClearingFee"), GUIBundle.getString("PortfolioManagementJPanel_StampDuty"), GUIBundle.getString("PortfolioManagementJPanel_Comment")};
        columnNames = tmp;
        cTypes = new Class[]{TreeTableModel.class, Code.class, SimpleDate.class, SimpleDate.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, String.class};
    }
}

