/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.news;

import it.sauronsoftware.feed4j.FeedException;
import it.sauronsoftware.feed4j.FeedParser;
import it.sauronsoftware.feed4j.bean.Feed;
import it.sauronsoftware.feed4j.bean.FeedItem;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.yahoo.quote.QuoteResponse;
import org.yccheok.jstock.engine.yahoo.quote.QuoteResponse_;
import org.yccheok.jstock.engine.yahoo.quote.Result;
import org.yccheok.jstock.news.NewsServer;
import org.yccheok.jstock.news.Utils;
import retrofit2.Call;

public class YahooFinanceNewsServer
implements NewsServer {
    private static final Log log = LogFactory.getLog(YahooFinanceNewsServer.class);

    @Override
    public List<FeedItem> getMessages(StockInfo stockInfo) {
        Code code = stockInfo.code;
        String query = org.yccheok.jstock.engine.Utils.toYahooFormat(code);
        if (org.yccheok.jstock.engine.Utils.needToResolveUnderlyingCode(code)) {
            Call<QuoteResponse> c = org.yccheok.jstock.engine.Utils.getYahooFinanceApi().quote(query);
            try {
                QuoteResponse quoteResponse = (QuoteResponse)c.execute().body();
                QuoteResponse_ quoteResponse_ = quoteResponse.getQuoteResponse();
                List<Result> results = quoteResponse_.getResult();
                query = results.get(0).getUnderlyingSymbol();
            }
            catch (Exception e) {
                log.error(null, (Throwable)e);
            }
        }
        String feedUrl = "https://feeds.finance.yahoo.com/rss/2.0/headline?s=" + query + "&region=US&lang=en-US";
        ArrayList<FeedItem> messages = new ArrayList<FeedItem>();
        HashSet<String> titles = new HashSet<String>();
        try {
            URL url = new URL(feedUrl);
            Feed feed = FeedParser.parse((URL)url);
            int items = feed.getItemCount();
            block4: for (int i = 0; i < items; ++i) {
                FeedItem message = feed.getItem(i);
                message.setPubDate(Utils.getProperPubDate(message));
                if (message.getLink() == null || message.getTitle() == null || message.getTitle().isEmpty() || message.getPubDate() == null) continue;
                for (String paidNewsUrl : Utils.getPaidNewsUrls()) {
                    if (!message.getLink().toString().contains(paidNewsUrl)) continue;
                    continue block4;
                }
                String title = message.getTitle();
                if (!titles.add(title)) continue;
                messages.add(message);
            }
        }
        catch (FeedException | MalformedURLException ex) {
            log.error(null, ex);
        }
        return messages;
    }
}

