/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.blobsallad;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import org.yccheok.blobsallad.Blob;
import org.yccheok.blobsallad.Environment;
import org.yccheok.blobsallad.Point;
import org.yccheok.blobsallad.PointMass;
import org.yccheok.blobsallad.Vector;

public class BlobCollective {
    private int maxNum;
    private int numActive;
    private List<Blob> blobs = new ArrayList<Blob>();
    private Vector tmpForce;
    private Blob selectedBlob;

    public BlobCollective(double x, double y, int maxNum) {
        this.maxNum = maxNum;
        this.numActive = 1;
        this.tmpForce = new Vector(0.0, 0.0);
        this.selectedBlob = null;
        this.blobs.add(0, new Blob(x, y, 0.4, 8));
    }

    public void split() {
        int i;
        boolean maxIndex = false;
        double maxRadius = 0.0;
        Blob motherBlob = null;
        if (this.numActive == this.maxNum) {
            return;
        }
        int emptySlot = this.blobs.size();
        for (i = 0; i < this.blobs.size(); ++i) {
            if (this.blobs.get(i) != null && this.blobs.get(i).getRadius() > maxRadius) {
                maxRadius = this.blobs.get(i).getRadius();
                motherBlob = this.blobs.get(i);
                continue;
            }
            if (this.blobs.get(i) != null) continue;
            emptySlot = i;
        }
        motherBlob.scale(0.75);
        Blob newBlob = new Blob(motherBlob.getXPos(), motherBlob.getYPos(), motherBlob.getRadius(), 8);
        for (i = 0; i < this.blobs.size(); ++i) {
            if (this.blobs.get(i) == null) continue;
            this.blobs.get(i).addBlob(newBlob);
            newBlob.addBlob(this.blobs.get(i));
        }
        this.blobs.add(emptySlot, newBlob);
        ++this.numActive;
    }

    public int findSmallest(int exclude) {
        double minRadius = 1000.0;
        int minIndex = 0;
        for (int i = 0; i < this.blobs.size(); ++i) {
            if (i == exclude || this.blobs.get(i) == null || !(this.blobs.get(i).getRadius() < minRadius)) continue;
            minIndex = i;
            minRadius = this.blobs.get(i).getRadius();
        }
        return minIndex;
    }

    public int findClosest(int exclude) {
        double minDist = 1000.0;
        int foundIndex = 0;
        PointMass myPointMass = this.blobs.get(exclude).getMiddlePointMass();
        for (int i = 0; i < this.blobs.size(); ++i) {
            double aYbY;
            if (i == exclude || this.blobs.get(i) == null) continue;
            PointMass otherPointMass = this.blobs.get(i).getMiddlePointMass();
            double aXbX = myPointMass.getXPos() - otherPointMass.getXPos();
            double dist = aXbX * aXbX + (aYbY = myPointMass.getYPos() - otherPointMass.getYPos()) * aYbY;
            if (!(dist < minDist)) continue;
            minDist = dist;
            foundIndex = i;
        }
        return foundIndex;
    }

    public void join() {
        if (this.numActive == 1) {
            return;
        }
        int blob1Index = this.findSmallest(-1);
        int blob2Index = this.findClosest(blob1Index);
        double r1 = this.blobs.get(blob1Index).getRadius();
        double r2 = this.blobs.get(blob2Index).getRadius();
        double r3 = Math.sqrt(r1 * r1 + r2 * r2);
        this.blobs.set(blob1Index, null);
        this.blobs.get(blob2Index).scale(0.945 * r3 / r2);
        --this.numActive;
    }

    public Point selectBlob(double x, double y) {
        double minDist = 10000.0;
        Point selectOffset = null;
        if (this.selectedBlob != null) {
            return null;
        }
        for (int i = 0; i < this.blobs.size(); ++i) {
            double aYbY;
            PointMass otherPointMass;
            double aXbX;
            double dist;
            if (this.blobs.get(i) == null || !((dist = (aXbX = x - (otherPointMass = this.blobs.get(i).getMiddlePointMass()).getXPos()) * aXbX + (aYbY = y - otherPointMass.getYPos()) * aYbY) < minDist)) continue;
            minDist = dist;
            if (!(dist < this.blobs.get(i).getRadius() * 0.5)) continue;
            this.selectedBlob = this.blobs.get(i);
            selectOffset = new Point(aXbX, aYbY);
        }
        if (this.selectedBlob != null) {
            this.selectedBlob.setSelected(true);
        }
        return selectOffset;
    }

    public void unselectBlob() {
        if (this.selectedBlob == null) {
            return;
        }
        this.selectedBlob.setSelected(false);
        this.selectedBlob = null;
    }

    public void selectedBlobMoveTo(double x, double y) {
        if (this.selectedBlob == null) {
            return;
        }
        this.selectedBlob.moveTo(x, y);
    }

    public void move(double dt) {
        for (int i = 0; i < this.blobs.size(); ++i) {
            if (this.blobs.get(i) == null) continue;
            this.blobs.get(i).move(dt);
        }
    }

    public void sc(Environment env) {
        for (int i = 0; i < this.blobs.size(); ++i) {
            if (this.blobs.get(i) == null) continue;
            this.blobs.get(i).sc(env);
        }
    }

    public void setForce(Vector force) {
        for (int i = 0; i < this.blobs.size(); ++i) {
            if (this.blobs.get(i) == null) continue;
            if (this.blobs.get(i) == this.selectedBlob) {
                this.blobs.get(i).setForce(new Vector(0.0, 0.0));
                continue;
            }
            this.blobs.get(i).setForce(force);
        }
    }

    public void addForce(Vector force) {
        for (int i = 0; i < this.blobs.size(); ++i) {
            if (this.blobs.get(i) == null || this.blobs.get(i) == this.selectedBlob) continue;
            this.tmpForce.setX(force.getX() * (Math.random() * 0.75 + 0.25));
            this.tmpForce.setY(force.getY() * (Math.random() * 0.75 + 0.25));
            this.blobs.get(i).addForce(this.tmpForce);
        }
    }

    public void draw(Graphics graphics, double scaleFactor) {
        for (int i = 0; i < this.blobs.size(); ++i) {
            if (this.blobs.get(i) == null) continue;
            this.blobs.get(i).draw(graphics, scaleFactor);
        }
    }
}

