/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf.extractor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.poi.POIDocument;
import org.apache.poi.POITextExtractor;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.SpecialPropertySet;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.wellknown.PropertyIDMap;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;

public class HPSFPropertiesExtractor
extends POITextExtractor {
    public HPSFPropertiesExtractor(POITextExtractor mainExtractor) {
        super(mainExtractor);
    }

    public HPSFPropertiesExtractor(POIDocument doc) {
        super(doc);
    }

    public HPSFPropertiesExtractor(POIFSFileSystem fs) {
        super(new PropertiesOnlyDocument(fs));
    }

    public String getDocumentSummaryInformationText() {
        DocumentSummaryInformation dsi = this.document.getDocumentSummaryInformation();
        StringBuffer text = new StringBuffer();
        text.append(HPSFPropertiesExtractor.getPropertiesText(dsi));
        CustomProperties cps = dsi.getCustomProperties();
        Iterator keys = cps.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String val = HPSFPropertiesExtractor.getPropertyValueText(cps.get(key));
            text.append(key + " = " + val + "\n");
        }
        return text.toString();
    }

    public String getSummaryInformationText() {
        SummaryInformation si = this.document.getSummaryInformation();
        return HPSFPropertiesExtractor.getPropertiesText(si);
    }

    private static String getPropertiesText(SpecialPropertySet ps) {
        if (ps == null) {
            return "";
        }
        StringBuffer text = new StringBuffer();
        PropertyIDMap idMap = ps.getPropertySetIDMap();
        Property[] props = ps.getProperties();
        for (int i = 0; i < props.length; ++i) {
            String type = Long.toString(props[i].getID());
            Object typeObj = idMap.get(props[i].getID());
            if (typeObj != null) {
                type = typeObj.toString();
            }
            String val = HPSFPropertiesExtractor.getPropertyValueText(props[i].getValue());
            text.append(type + " = " + val + "\n");
        }
        return text.toString();
    }

    private static String getPropertyValueText(Object val) {
        if (val == null) {
            return "(not set)";
        }
        if (val instanceof byte[]) {
            byte[] b = (byte[])val;
            if (b.length == 0) {
                return "";
            }
            if (b.length == 1) {
                return Byte.toString(b[0]);
            }
            if (b.length == 2) {
                return Integer.toString(LittleEndian.getUShort(b));
            }
            if (b.length == 4) {
                return Long.toString(LittleEndian.getUInt(b));
            }
            return new String(b);
        }
        return val.toString();
    }

    public String getText() {
        return this.getSummaryInformationText() + this.getDocumentSummaryInformationText();
    }

    public POITextExtractor getMetadataTextExtractor() {
        throw new IllegalStateException("You already have the Metadata Text Extractor, not recursing!");
    }

    private static class PropertiesOnlyDocument
    extends POIDocument {
        private PropertiesOnlyDocument(POIFSFileSystem fs) {
            super(fs);
        }

        public void write(OutputStream out) throws IOException {
            throw new IllegalStateException("Unable to write, only for properties!");
        }
    }
}

