/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.feed4j;

import it.sauronsoftware.feed4j.FeedIOException;
import it.sauronsoftware.feed4j.FeedRecognizer;
import it.sauronsoftware.feed4j.FeedXMLParseException;
import it.sauronsoftware.feed4j.TypeAtom_0_3;
import it.sauronsoftware.feed4j.TypeAtom_1_0;
import it.sauronsoftware.feed4j.TypeRSS_1_0;
import it.sauronsoftware.feed4j.TypeRSS_2_0;
import it.sauronsoftware.feed4j.UnsupportedFeedException;
import it.sauronsoftware.feed4j.bean.Feed;
import java.net.URL;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class FeedParser {
    public static Feed parse(URL url) throws FeedIOException, FeedXMLParseException, UnsupportedFeedException {
        try {
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read(url);
            int code = FeedRecognizer.recognizeFeed(document);
            switch (code) {
                case 0: {
                    return TypeRSS_1_0.feed(url, document);
                }
                case 1: {
                    return TypeRSS_2_0.feed(url, document);
                }
                case 2: {
                    return TypeAtom_0_3.feed(url, document);
                }
                case 3: {
                    return TypeAtom_1_0.feed(url, document);
                }
            }
            throw new UnsupportedFeedException();
        }
        catch (DocumentException e) {
            throw new FeedXMLParseException(e);
        }
    }
}

