/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.feed4j;

import it.sauronsoftware.feed4j.bean.RawAttribute;
import it.sauronsoftware.feed4j.bean.RawElement;
import it.sauronsoftware.feed4j.bean.RawText;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;

class TypeAbstract {
    private static final String[] VALID_LANGUAGES = new String[]{"af", "sq", "eu", "be", "bg", "ca", "zh-cn", "zh-tw", "hr", "cs", "da", "nl", "nl-be", "nl-nl", "en", "en-au", "en-bz", "en-ca", "en-ie", "en-jm", "en-nz", "en-ph", "en-za", "en-tt", "en-gb", "en-us", "en-zw", "et", "fo", "fi", "fr", "fr-be", "fr-ca", "fr-fr", "fr-lu", "fr-mc", "fr-ch", "gl", "gd", "de", "de-at", "de-de", "de-li", "de-lu", "de-ch", "el", "haw", "hu", "is", "in", "ga", "it", "it-it", "it-ch", "ja", "ko", "mk", "no", "pl", "pt", "pt-br", "pt-pt", "ro", "ro-mo", "ro-ro", "ru", "ru-mo", "ru-ru", "sr", "sk", "sl", "es", "es-ar", "es-bo", "es-cl", "es-co", "es-cr", "es-do", "es-ec", "es-sv", "es-gt", "es-hn", "es-mx", "es-ni", "es-pa", "es-py", "es-pe", "es-pr", "es-es", "es-uy", "es-ve", "sv", "sv-fi", "sv-se", "tr", "uk"};

    TypeAbstract() {
    }

    protected static void populateRawElement(RawElement re, Element e) {
        String text;
        String ensuri = e.getNamespaceURI();
        re.setNamespaceURI(ensuri);
        re.setName(e.getName());
        Iterator i = e.attributeIterator();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            RawAttribute rawAttribute = new RawAttribute();
            String attrnsuri = attr.getNamespaceURI();
            if (attrnsuri.equals("")) {
                attrnsuri = ensuri;
            }
            rawAttribute.setNamespaceURI(attrnsuri);
            rawAttribute.setName(attr.getName());
            String value = attr.getValue();
            if (value == null) continue;
            value = value.trim();
            rawAttribute.setValue(value);
            re.addAttribute(rawAttribute);
        }
        if (e.isTextOnly() && (text = e.getTextTrim()).length() > 0) {
            re.setValue(text);
        }
        i = e.nodeIterator();
        while (i.hasNext()) {
            Node current = (Node)i.next();
            if (current instanceof Text) {
                Text text2 = (Text)current;
                String aux = text2.getText();
                if (aux == null || (aux = aux.trim()).length() <= 0) continue;
                RawText rawText = new RawText();
                rawText.setText(aux);
                re.addNode(rawText);
                continue;
            }
            if (!(current instanceof Element)) continue;
            Element element = (Element)current;
            RawElement rawElement = new RawElement();
            TypeAbstract.populateRawElement(rawElement, element);
            re.addNode(rawElement);
        }
    }

    protected static void populateRawElement(RawElement re1, RawElement re2) {
        re1.setValue(re2.getValue());
        int i = 0;
        while (i < re2.getAttributeCount()) {
            re1.addAttribute(re2.getAttribute(i));
            ++i;
        }
        i = 0;
        while (i < re2.getNodeCount()) {
            re1.addNode(re2.getNode(i));
            ++i;
        }
    }

    protected static boolean isValidLanguageCode(String str) {
        int i = 0;
        while (i < VALID_LANGUAGES.length) {
            if (str.equalsIgnoreCase(VALID_LANGUAGES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String toHexGUIDRapp(int a) {
        char firstChar;
        if (a < 0) {
            a = -a;
            firstChar = '-';
        } else {
            firstChar = '+';
        }
        String aux = Integer.toHexString(a);
        int size = aux.length();
        if (size < 8) {
            int i = size;
            while (i < 8) {
                aux = String.valueOf('0') + aux;
                ++i;
            }
        }
        return String.valueOf(firstChar) + aux;
    }

    protected static String buildGUID(int a, int b) {
        return String.valueOf(TypeAbstract.toHexGUIDRapp(a)) + TypeAbstract.toHexGUIDRapp(b);
    }
}

