/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.feed4j.bean;

import it.sauronsoftware.feed4j.bean.RawAttribute;
import it.sauronsoftware.feed4j.bean.RawNode;
import java.util.ArrayList;
import java.util.Iterator;

public class RawElement
implements RawNode {
    private String namespaceURI = null;
    private String name = null;
    private String value = null;
    private ArrayList attributes = null;
    private ArrayList nodes = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public RawAttribute getAttribute(int index) throws IndexOutOfBoundsException {
        if (this.attributes == null) {
            throw new IndexOutOfBoundsException();
        }
        return (RawAttribute)this.attributes.get(index);
    }

    public void addAttribute(RawAttribute attribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(attribute);
    }

    public int getAttributeCount() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.size();
    }

    public String getAttributeValue(String namespaceURI, String name) {
        if (this.attributes == null) {
            return null;
        }
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            RawAttribute aux = (RawAttribute)i.next();
            if (!aux.getNamespaceURI().equals(namespaceURI) || !aux.getName().equals(name)) continue;
            return aux.getValue();
        }
        return null;
    }

    public RawNode getNode(int index) throws IndexOutOfBoundsException {
        if (this.nodes == null) {
            throw new IndexOutOfBoundsException();
        }
        return (RawNode)this.nodes.get(index);
    }

    public RawElement[] getElements(String namespaceURI, String name) {
        if (this.nodes == null) {
            return new RawElement[0];
        }
        ArrayList<RawElement> list = new ArrayList<RawElement>();
        Iterator i = this.nodes.iterator();
        while (i.hasNext()) {
            RawElement aux;
            RawNode node = (RawNode)i.next();
            if (!(node instanceof RawElement) || !(aux = (RawElement)node).getNamespaceURI().equals(namespaceURI) || !aux.getName().equals(name)) continue;
            list.add(aux);
        }
        int size = list.size();
        RawElement[] ret = new RawElement[size];
        int i2 = 0;
        while (i2 < size) {
            ret[i2] = (RawElement)list.get(i2);
            ++i2;
        }
        return ret;
    }

    public RawElement getElement(String namespaceURI, String name) {
        if (this.nodes == null) {
            return null;
        }
        Iterator i = this.nodes.iterator();
        while (i.hasNext()) {
            RawElement aux;
            RawNode node = (RawNode)i.next();
            if (!(node instanceof RawElement) || !(aux = (RawElement)node).getNamespaceURI().equals(namespaceURI) || !aux.getName().equals(name)) continue;
            return aux;
        }
        return null;
    }

    public String getElementValue(String namespaceURI, String name) {
        if (this.nodes == null) {
            return null;
        }
        RawElement element = this.getElement(namespaceURI, name);
        if (element != null) {
            return element.getValue();
        }
        return null;
    }

    public void addNode(RawNode node) {
        if (this.nodes == null) {
            this.nodes = new ArrayList();
        }
        this.nodes.add(node);
    }

    public int getNodeCount() {
        if (this.nodes == null) {
            return 0;
        }
        return this.nodes.size();
    }

    public void removeNode(RawNode node) {
        if (this.nodes != null) {
            this.nodes.remove(node);
            if (this.nodes.size() == 0) {
                this.nodes = null;
            }
        }
    }
}

