/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.html.HTMLDocument;
import org.jdesktop.swingx.ForwardingRepaintManager;
import org.jdesktop.swingx.RepaintManagerX;
import org.jdesktop.swingx.TranslucentRepaintManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SwingXUtilities {
    private static String STYLESHEET = "body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: %s; font-size: %dpt;  }a, p, li { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: %s; font-size: %dpt;  }";

    private SwingXUtilities() {
    }

    public static void updateMnemonicBinding(JComponent c, String pressed) {
        SwingXUtilities.updateMnemonicBinding(c, pressed, null);
    }

    public static void updateMnemonicBinding(JComponent c, String pressed, String released) {
        Class<?> clazz = c.getClass();
        int m = -1;
        try {
            Method mtd = clazz.getMethod("getMnemonic", new Class[0]);
            m = (Integer)mtd.invoke((Object)c, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unable to access mnemonic", e);
        }
        InputMap map = SwingUtilities.getUIInputMap(c, 2);
        if (m != 0) {
            if (map == null) {
                map = new ComponentInputMapUIResource(c);
                SwingUtilities.replaceUIInputMap(c, 2, map);
            }
            map.clear();
            map.put(KeyStroke.getKeyStroke(m, 8, false), pressed);
            map.put(KeyStroke.getKeyStroke(m, 8, true), released);
            map.put(KeyStroke.getKeyStroke(m, 0, true), released);
        } else if (map != null) {
            map.clear();
        }
    }

    private static Component[] getChildren(Component c) {
        Component[] children = null;
        if (c instanceof MenuElement) {
            MenuElement[] elements = ((MenuElement)((Object)c)).getSubElements();
            children = new Component[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                children[i] = elements[i].getComponent();
            }
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        return children;
    }

    public static void setComponentTreeEnabled(Component c, boolean enabled) {
        c.setEnabled(enabled);
        Component[] children = SwingXUtilities.getChildren(c);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                SwingXUtilities.setComponentTreeEnabled(children[i], enabled);
            }
        }
    }

    public static void setComponentTreeLocale(Component c, Locale locale) {
        c.setLocale(locale);
        Component[] children = SwingXUtilities.getChildren(c);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                SwingXUtilities.setComponentTreeLocale(children[i], locale);
            }
        }
    }

    public static void setComponentTreeBackground(Component c, Color color) {
        c.setBackground(color);
        Component[] children = SwingXUtilities.getChildren(c);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                SwingXUtilities.setComponentTreeBackground(children[i], color);
            }
        }
    }

    public static void setComponentTreeForeground(Component c, Color color) {
        c.setForeground(color);
        Component[] children = SwingXUtilities.getChildren(c);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                SwingXUtilities.setComponentTreeForeground(children[i], color);
            }
        }
    }

    public static void setComponentTreeFont(Component c, Font font) {
        c.setFont(font);
        Component[] children = SwingXUtilities.getChildren(c);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                SwingXUtilities.setComponentTreeFont(children[i], font);
            }
        }
    }

    public static void setHtmlFont(HTMLDocument doc, Font font) {
        String stylesheet = String.format(STYLESHEET, font.getName(), font.getSize(), font.getName(), font.getSize());
        try {
            doc.getStyleSheet().loadRules(new StringReader(stylesheet), null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void updateAllComponentTreeUIs() {
        for (Frame frame : Frame.getFrames()) {
            SwingXUtilities.updateAllComponentTreeUIs(frame);
        }
    }

    public static void updateAllComponentTreeUIs(Window window) {
        SwingUtilities.updateComponentTreeUI(window);
        for (Window owned : window.getOwnedWindows()) {
            SwingXUtilities.updateAllComponentTreeUIs(owned);
        }
    }

    public static <T> T getAncestor(Class<T> clazz, Component c) {
        if (clazz == null || c == null) {
            return null;
        }
        Container parent = c.getParent();
        while (parent != null && !clazz.isInstance(parent)) {
            parent = c instanceof JPopupMenu ? ((JPopupMenu)c).getInvoker() : c.getParent();
        }
        return (T)parent;
    }

    public static boolean isDescendingFrom(Component focusOwner, Component parent) {
        while (focusOwner != null) {
            if (focusOwner instanceof JPopupMenu && (focusOwner = ((JPopupMenu)focusOwner).getInvoker()) == null) {
                return false;
            }
            if (focusOwner == parent) {
                return true;
            }
            focusOwner = focusOwner.getParent();
        }
        return false;
    }

    static RepaintManager getTranslucentRepaintManager(RepaintManager delegate) {
        RepaintManager manager = delegate;
        while (!manager.getClass().isAnnotationPresent(TranslucentRepaintManager.class)) {
            if (manager instanceof ForwardingRepaintManager) {
                manager = ((ForwardingRepaintManager)manager).getDelegateManager();
                continue;
            }
            manager = new RepaintManagerX(delegate);
        }
        return manager;
    }

    public static boolean isUIInstallable(Object property) {
        return property == null || property instanceof UIResource;
    }
}

