/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tools;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;

public class PrefixSelectionCustomizer {
    private static final String SELECTION_PREFIX_STRING = "selectionPrefixString";
    private static final Object SELECTION_PREFIX_TASK = "selectionPrefixTask";
    private static EventHandler<KeyEvent> handler = new EventHandler<KeyEvent>(){
        private ScheduledExecutorService executorService = null;

        public void handle(KeyEvent event) {
            this.keyPressed(event);
        }

        private <T> void keyPressed(KeyEvent event) {
            KeyCode code = event.getCode();
            if (code.isLetterKey() || code.isDigitKey() || code == KeyCode.SPACE) {
                ChoiceBox choiceBox;
                T item;
                String letter = code.impl_getChar();
                if (event.getSource() instanceof ComboBox) {
                    ComboBox comboBox = (ComboBox)event.getSource();
                    T item2 = this.getEntryWithKey(letter, comboBox.getConverter(), comboBox.getItems(), (Control)comboBox);
                    if (item2 != null) {
                        comboBox.setValue(item2);
                    }
                } else if (event.getSource() instanceof ChoiceBox && (item = this.getEntryWithKey(letter, (choiceBox = (ChoiceBox)event.getSource()).getConverter(), choiceBox.getItems(), (Control)choiceBox)) != null) {
                    choiceBox.setValue(item);
                }
            }
        }

        private <T> T getEntryWithKey(String letter, StringConverter<T> converter, ObservableList<T> items, Control control) {
            ScheduledFuture<Object> task;
            String selectionPrefixString;
            T result = null;
            if (converter == null) {
                converter = new StringConverter<T>(){

                    public String toString(T t) {
                        return t == null ? null : t.toString();
                    }

                    public T fromString(String string) {
                        return null;
                    }
                };
            }
            selectionPrefixString = (selectionPrefixString = (String)control.getProperties().get((Object)PrefixSelectionCustomizer.SELECTION_PREFIX_STRING)) == null ? letter.toUpperCase() : selectionPrefixString + letter.toUpperCase();
            control.getProperties().put((Object)PrefixSelectionCustomizer.SELECTION_PREFIX_STRING, (Object)selectionPrefixString);
            for (Object item : items) {
                String string = converter.toString(item);
                if (string == null || !string.toUpperCase().startsWith(selectionPrefixString)) continue;
                result = (T)item;
                break;
            }
            if ((task = (ScheduledFuture<Object>)control.getProperties().get(SELECTION_PREFIX_TASK)) != null) {
                task.cancel(false);
            }
            task = this.getExecutorService().schedule(() -> control.getProperties().put((Object)PrefixSelectionCustomizer.SELECTION_PREFIX_STRING, (Object)""), 500L, TimeUnit.MILLISECONDS);
            control.getProperties().put(SELECTION_PREFIX_TASK, task);
            return result;
        }

        private ScheduledExecutorService getExecutorService() {
            if (this.executorService == null) {
                this.executorService = Executors.newScheduledThreadPool(1, runnabble -> {
                    Thread result = new Thread(runnabble);
                    result.setDaemon(true);
                    return result;
                });
            }
            return this.executorService;
        }
    };

    public static void customize(ComboBox<?> comboBox) {
        if (!comboBox.isEditable()) {
            comboBox.addEventHandler(KeyEvent.KEY_PRESSED, handler);
        }
        comboBox.editableProperty().addListener((o, oV, nV) -> {
            if (!nV.booleanValue()) {
                comboBox.addEventHandler(KeyEvent.KEY_PRESSED, handler);
            } else {
                comboBox.removeEventHandler(KeyEvent.KEY_PRESSED, handler);
            }
        });
    }

    public static void customize(ChoiceBox<?> choiceBox) {
        choiceBox.addEventHandler(KeyEvent.KEY_PRESSED, handler);
    }
}

