/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.core.internal;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import net.xmind.core.IAccount;
import net.xmind.core.IAccountManager;
import net.xmind.core.internal.Account;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class InternalAccountManager
implements IAccountManager {
    private static final String PATH_STATE_FILE = "accounts.json";
    private static final String KEY_ACCOUNTS = "accounts";
    private Account primaryAccount = new Account();
    private IPath storageRoot;

    public InternalAccountManager() {
        this.primaryAccount.setManager(this);
        this.storageRoot = null;
    }

    public void setStateLocation(IPath stateLocation) {
        this.storageRoot = stateLocation;
    }

    public void load() {
        if (this.storageRoot == null) {
            return;
        }
        final File stateFile = this.storageRoot.append(PATH_STATE_FILE).toFile();
        if (!stateFile.exists() || !stateFile.canRead()) {
            return;
        }
        final JSONObject[] state = new JSONObject[]{null};
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                FileReader reader = new FileReader(stateFile);
                try {
                    state[0] = new JSONObject(new JSONTokener((Reader)reader));
                }
                finally {
                    reader.close();
                }
            }

            public void handleException(Throwable exception) {
            }
        });
        if (state[0] == null) {
            return;
        }
        JSONArray accountArray = state[0].optJSONArray(KEY_ACCOUNTS);
        if (accountArray == null) {
            return;
        }
        if (accountArray.length() == 0) {
            return;
        }
        JSONObject accountObject = accountArray.optJSONObject(0);
        if (accountObject == null) {
            return;
        }
        this.primaryAccount.setProperties(accountObject);
    }

    public void save() {
        final File stateFile = this.storageRoot.append(PATH_STATE_FILE).toFile();
        File dir = stateFile.getParentFile();
        if (dir == null || !dir.isDirectory() && !dir.mkdirs()) {
            return;
        }
        final JSONObject state = new JSONObject().put(KEY_ACCOUNTS, (Object)new JSONArray().put((Object)this.primaryAccount.toJSON()));
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                FileWriter writer = new FileWriter(stateFile);
                try {
                    state.write((Writer)writer);
                }
                finally {
                    writer.close();
                }
            }

            public void handleException(Throwable exception) {
            }
        });
    }

    @Override
    public IAccount getPrimaryAccount() {
        return this.primaryAccount;
    }
}

