/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.ui.internal.taskinfo.TaskMessages;
import org.xmind.ui.resources.FontUtils;

public abstract class EditableValueViewer {
    private Composite composite;
    private Composite displayWrap;
    private Label display;
    private Hyperlink editLink;
    private Composite editorWrap;
    private StackLayout stack;

    public EditableValueViewer(Composite parent) {
        this.createControl(parent);
        this.setEditorVisible(false);
    }

    private void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setBackground(parent.getBackground());
        this.stack = new StackLayout();
        this.composite.setLayout((Layout)this.stack);
        this.createDisplayWrap(this.composite);
        this.createEditorWrap(this.composite);
    }

    private void createDisplayWrap(Composite parent) {
        this.displayWrap = new Composite(parent, 0);
        this.displayWrap.setBackground(parent.getBackground());
        GridLayout displayWrapLayout = new GridLayout(2, false);
        displayWrapLayout.marginWidth = 5;
        displayWrapLayout.marginHeight = 0;
        displayWrapLayout.verticalSpacing = 0;
        displayWrapLayout.horizontalSpacing = 5;
        this.displayWrap.setLayout((Layout)displayWrapLayout);
        this.createDisplay(this.displayWrap);
        this.createEditLink(this.displayWrap);
    }

    private void createDisplay(Composite parent) {
        this.display = new Label(parent, 0);
        this.display.setBackground(parent.getBackground());
        this.display.setForeground(parent.getDisplay().getSystemColor(15));
        this.display.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
    }

    private void createEditLink(Composite parent) {
        this.editLink = new Hyperlink(parent, 0);
        this.editLink.setText(TaskMessages.EditableValueViewer_EditLink_text);
        this.editLink.setBackground(parent.getBackground());
        this.editLink.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)11));
        this.editLink.setForeground(parent.getDisplay().getSystemColor(16));
        this.editLink.setUnderlined(true);
        this.editLink.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        this.editLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                EditableValueViewer.this.editLinkActivated();
            }
        });
    }

    private void createEditorWrap(Composite parent) {
        this.editorWrap = new Composite(parent, 0);
        this.editorWrap.setBackground(parent.getBackground());
        this.editorWrap.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout durationLayout = new GridLayout(1, false);
        durationLayout.marginWidth = 0;
        durationLayout.marginHeight = 0;
        durationLayout.verticalSpacing = 0;
        durationLayout.horizontalSpacing = 0;
        this.editorWrap.setLayout((Layout)durationLayout);
        this.createEditor(this.editorWrap);
    }

    protected abstract void editLinkActivated();

    protected abstract void createEditor(Composite var1);

    protected abstract void setEditorFocus();

    public void setEditorVisible(boolean editing) {
        if (!this.composite.isDisposed()) {
            if (editing) {
                this.stack.topControl = this.editorWrap;
                this.displayWrap.setVisible(false);
                this.editorWrap.setVisible(true);
            } else {
                this.stack.topControl = this.displayWrap;
                this.displayWrap.setVisible(true);
                this.editorWrap.setVisible(false);
            }
            this.composite.layout();
            this.editorWrap.layout();
            this.displayWrap.layout();
        }
    }

    public boolean isEditorVisible() {
        return !this.composite.isDisposed() && this.stack.topControl == this.editorWrap;
    }

    public Hyperlink getEditLink() {
        return this.editLink;
    }

    public Label getDisplay() {
        return this.display;
    }

    public Control getControl() {
        return this.composite;
    }

    public void setEnabled(boolean enabled) {
        this.editLink.setEnabled(enabled);
    }

    public void setFocus() {
        if (this.isEditorVisible()) {
            this.setEditorFocus();
        } else {
            this.editLink.setFocus();
        }
    }
}

