/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.properties;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.xmind.ui.properties.IEditingListener;
import org.xmind.ui.properties.IPropertyDescriptor;
import org.xmind.ui.properties.IPropertyEditingEntry;
import org.xmind.ui.properties.IPropertySource;
import org.xmind.ui.properties.IPropertyTransfer;
import org.xmind.ui.properties.PropertiesEditor;
import org.xmind.ui.properties.PropertyEditor;
import org.xmind.ui.util.IChained;
import org.xmind.ui.viewers.ILabelDescriptor;

public class PropertyEditingEntry
implements IPropertyEditingEntry,
IChained<PropertyEditingEntry> {
    private static final int MARGIN_V = 5;
    private static final int MARGIN_H = 8;
    private static final int CORNER = 8;
    private static final int HOVER_CORNER = 6;
    private static final int HOVER_SHRINK_V = 4;
    private static final int HOVER_SHRINK_H = 3;
    private PropertiesEditor parent;
    private IPropertySource source;
    private IPropertyDescriptor descriptor;
    private Canvas canvas;
    private TextLayout nameLayout;
    private TextLayout valueLayout;
    private Image valueImage = null;
    private Color valueColor = null;
    private Font valueFont = null;
    private PropertyEditor editor;
    private Color foreground = null;
    private Font font = null;
    private Color selectedBackground = null;
    private Color selectedForeground = null;
    private Font selectedFont = null;
    private boolean selected = false;
    private boolean showingHover = false;
    private boolean showingEditorHover = false;
    private PropertyEditingEntry prev = null;
    private PropertyEditingEntry next = null;

    public PropertyEditingEntry(PropertiesEditor parent, IPropertySource source, IPropertyDescriptor descriptor) {
        this.parent = parent;
        this.source = source;
        this.descriptor = descriptor;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return this.source;
        }
        if (adapter == IPropertyDescriptor.class) {
            return this.descriptor;
        }
        return null;
    }

    @Override
    public boolean isEditable() {
        return this.editor != null;
    }

    @Override
    public boolean isResettable() {
        return this.source.isPropertyResettable(this.descriptor.getId());
    }

    @Override
    public boolean isPropertySet() {
        return this.source.isPropertySet(this.descriptor.getId());
    }

    @Override
    public void resetPropertyValue() {
        this.source.resetPropertyValue(this.descriptor.getId());
        this.update();
    }

    public void createControl(Composite parent) {
        Assert.isTrue((this.canvas == null ? 1 : 0) != 0);
        this.nameLayout = new TextLayout((Device)parent.getDisplay());
        this.nameLayout.setAlignment(16384);
        this.valueLayout = new TextLayout((Device)parent.getDisplay());
        this.valueLayout.setAlignment(131072);
        this.canvas = new PropertyEditingCanvas(parent, 0);
        this.canvas.setToolTipText(this.descriptor.getDescription());
        this.canvas.setLayout(new Layout(){

            protected void layout(Composite composite, boolean flushCache) {
                if (flushCache) {
                    PropertyEditingEntry.this.clearLayoutCache();
                }
                PropertyEditingEntry.this.layoutControls();
            }

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                if (flushCache) {
                    PropertyEditingEntry.this.clearLayoutCache();
                }
                return PropertyEditingEntry.this.computeCanvasSize(wHint, hHint);
            }
        });
        Listener listener = new Listener(){
            long lastTime = 0L;
            boolean pressedInEditorHover = false;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        PropertyEditingEntry.this.paintCanvas(event.gc, event.x, event.y, event.width, event.height);
                        break;
                    }
                    case 15: {
                        PropertyEditingEntry.this.selectSingle();
                        break;
                    }
                    case 16: {
                        break;
                    }
                    case 31: {
                        event.doit = PropertyEditingEntry.this.handleKeyTraverse(event.detail);
                        break;
                    }
                    case 1: {
                        PropertyEditingEntry.this.handleKeyPress(event.keyCode, event.stateMask);
                        break;
                    }
                    case 3: {
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - this.lastTime <= (long)Display.getCurrent().getDoubleClickTime()) break;
                        this.lastTime = currentTime;
                        PropertyEditingEntry.this.handleSingleClick();
                        if (!PropertyEditingEntry.this.isInEditorHover(event.x, event.y)) break;
                        this.pressedInEditorHover = true;
                        break;
                    }
                    case 4: {
                        if (this.pressedInEditorHover) {
                            PropertyEditingEntry.this.open();
                        }
                        this.pressedInEditorHover = false;
                        break;
                    }
                    case 5: {
                        PropertyEditingEntry.this.handleMouseMove(event.x, event.y);
                        break;
                    }
                    case 7: {
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PropertyEditingEntry.this.setShowingHover(false);
                                PropertyEditingEntry.this.setShowingEditorHover(false);
                            }
                        });
                        break;
                    }
                    case 6: {
                        PropertyEditingEntry.this.handleMouseMove(event.x, event.y);
                        break;
                    }
                    case 8: {
                        PropertyEditingEntry.this.handleDoubleClick();
                    }
                }
            }
        };
        this.canvas.addListener(9, listener);
        this.canvas.addListener(31, listener);
        this.canvas.addListener(15, listener);
        this.canvas.addListener(16, listener);
        this.canvas.addListener(1, listener);
        this.canvas.addListener(3, listener);
        this.canvas.addListener(4, listener);
        this.canvas.addListener(5, listener);
        this.canvas.addListener(7, listener);
        this.canvas.addListener(6, listener);
        this.canvas.addListener(8, listener);
        this.editor = this.descriptor.createPropertyEditor((Composite)this.canvas);
        if (this.editor != null) {
            this.initPropertyEditor(this.editor);
        }
        this.updateLabels();
        this.updateEditor();
    }

    private void initPropertyEditor(final PropertyEditor editor) {
        editor.addEditingListener(new IEditingListener(){

            @Override
            public void editingCanceled() {
                PropertyEditingEntry.this.hideEditor();
                PropertyEditingEntry.this.update();
            }

            @Override
            public void editingFinished() {
                PropertyEditingEntry.this.changeProperty(editor.getValue());
                PropertyEditingEntry.this.hideEditor();
                PropertyEditingEntry.this.update();
            }
        });
        editor.deactivate();
    }

    private void paintCanvas(GC gc, int px, int py, int pw, int ph) {
        int oldAlpha;
        if (this.canvas == null || this.canvas.isDisposed()) {
            return;
        }
        Rectangle r = this.canvas.getBounds();
        Color b1 = this.canvas.getBackground();
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        if (this.isSelected()) {
            gc.setBackground(this.selectedBackground);
            gc.fillRoundRectangle(0, 0, r.width, r.height, 8, 8);
        } else if (this.showingHover) {
            oldAlpha = gc.getAlpha();
            gc.setAlpha(96 * oldAlpha / 255);
            gc.setBackground(this.selectedBackground);
            gc.fillRoundRectangle(0, 0, r.width, r.height, 8, 8);
            gc.setAlpha(oldAlpha);
        }
        if (this.showingEditorHover) {
            oldAlpha = gc.getAlpha();
            gc.setAlpha(192 * oldAlpha / 255);
            gc.setBackground(b1);
            gc.fillRoundRectangle(r.width / 2 + 3, 4, r.width / 2 - 3 - 3, r.height - 4 - 4, 6, 6);
            gc.setAlpha(oldAlpha);
        }
        gc.setForeground(this.canvas.getForeground());
        gc.setFont(this.canvas.getFont());
        if (this.nameLayout != null && !this.nameLayout.isDisposed()) {
            Rectangle nb = this.nameLayout.getBounds();
            this.nameLayout.draw(gc, 8, (r.height - nb.height) / 2);
        }
        int right = r.width - 8;
        if (this.valueImage != null && !this.valueImage.isDisposed()) {
            int iw;
            int ih;
            Rectangle ib = this.valueImage.getBounds();
            if (ib.height > r.height) {
                ih = r.height;
                iw = ib.width * r.height / ib.height;
            } else {
                ih = ib.height;
                iw = ib.width;
            }
            gc.drawImage(this.valueImage, 0, 0, ib.width, ib.height, right - iw, (r.height - ih) / 2, iw, ih);
            right = right - iw - 3;
        }
        if (this.valueLayout != null && !this.valueLayout.isDisposed()) {
            Rectangle vb = this.valueLayout.getBounds();
            this.valueLayout.draw(gc, right - vb.width, (r.height - vb.height) / 2);
        }
    }

    private void clearLayoutCache() {
    }

    private void layoutControls() {
        Rectangle r = this.canvas.getBounds();
        int hw = Math.max(0, (r.width - 8) / 2 - 8);
        this.nameLayout.setWidth(Math.max(hw, 1));
        this.valueLayout.setWidth(Math.max(hw, 1));
        if (this.editor != null) {
            Control ec = this.editor.getControl();
            int eh = r.height - 5 - 5;
            ec.setBounds(r.width - 8 - hw, (r.height - eh) / 2, hw, eh);
        }
    }

    private Point computeCanvasSize(int wHint, int hHint) {
        if (wHint < 0 || hHint < 0) {
            if (this.editor != null && this.editor.getControl() != null && !this.editor.getControl().isDisposed()) {
                Point editorSize = this.editor.getControl().computeSize(wHint < 0 ? -1 : Math.max(0, (wHint - 8) / 2 - 8 - 1), hHint, true);
                if (wHint < 0) {
                    wHint = editorSize.x * 2;
                }
                if (hHint < 0) {
                    hHint = editorSize.y;
                }
            } else {
                if (wHint < 0) {
                    wHint = 100;
                }
                if (hHint < 0) {
                    hHint = 1;
                }
            }
            Rectangle nb = this.nameLayout.getBounds();
            Rectangle vb = this.valueLayout.getBounds();
            hHint = Math.max(hHint, Math.max(nb.height, vb.height)) + 5 + 5;
        }
        return new Point(wHint, hHint);
    }

    public Control getControl() {
        return this.canvas;
    }

    public void setFont(Font font) {
        this.font = font;
        this.updateWidgets();
    }

    public void setForeground(Color color) {
        this.foreground = color;
        this.updateWidgets();
    }

    public void setSelectedBackground(Color color) {
        this.selectedBackground = color;
        this.updateWidgets();
    }

    public void setSelectedForeground(Color color) {
        this.selectedForeground = color;
        this.updateWidgets();
    }

    public void setSelectedFont(Font font) {
        this.selectedFont = font;
        this.updateWidgets();
    }

    private void showEditor() {
        if (this.editor != null) {
            this.editor.activate();
        }
    }

    private void hideEditor() {
        if (this.editor != null) {
            this.editor.deactivate();
        }
    }

    private void changeProperty(Object newValue) {
        this.source.setPropertyValue(this.descriptor.getId(), newValue);
    }

    public void setFocus() {
        if (this.editor != null && this.editor.isActivated()) {
            this.editor.setFocus();
        } else if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.setFocus();
        }
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.dispose();
        }
        this.canvas = null;
        if (this.valueImage != null && !this.valueImage.isDisposed()) {
            this.valueImage.dispose();
        }
        this.valueImage = null;
        if (this.nameLayout != null && !this.nameLayout.isDisposed()) {
            this.nameLayout.dispose();
        }
        this.nameLayout = null;
        if (this.valueLayout != null && !this.valueLayout.isDisposed()) {
            this.valueLayout.dispose();
        }
        this.valueLayout = null;
    }

    public void update() {
        this.updateWidgets();
        this.updateEditor();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        boolean oldSelected = this.selected;
        this.selected = selected;
        this.updateWidgets();
        if (oldSelected != selected && this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    public void open() {
        this.selectSingle();
        this.showEditor();
        this.setShowingEditorHover(false);
        this.setFocus();
    }

    protected void updateWidgets() {
        if (this.isSelected()) {
            this.updateColorsFonts(this.selectedForeground, this.selectedFont);
        } else {
            this.updateColorsFonts(this.foreground, this.font);
        }
        this.updateLabels();
    }

    private void updateColorsFonts(Color foreground, Font font) {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.setBackground(this.canvas.getParent().getBackground());
            this.canvas.setForeground(foreground);
            this.canvas.setFont(font);
            if (this.editor != null) {
                this.editor.setBackground(this.isSelected() ? this.selectedBackground : this.canvas.getBackground());
                this.editor.setForeground(foreground);
                this.editor.setFont(font);
            }
        }
    }

    private void updateLabels() {
        FontDescriptor font;
        ColorDescriptor color;
        ILabelDescriptor labelDescriptor;
        ImageDescriptor image;
        Object value = this.source.getPropertyValue(this.descriptor.getId());
        if (this.nameLayout != null && !this.nameLayout.isDisposed()) {
            this.nameLayout.setText(this.descriptor.getDisplayName());
            this.nameLayout.setStyle(new TextStyle(this.canvas.getFont(), this.canvas.getForeground(), null), 0, this.nameLayout.getText().length());
        }
        ImageDescriptor imageDescriptor = image = (labelDescriptor = this.descriptor.getLabelDescriptor()) == null ? null : labelDescriptor.getImage(value);
        if (this.valueImage != null) {
            this.valueImage.dispose();
        }
        this.valueImage = image == null ? null : image.createImage(false, (Device)Display.getCurrent());
        ColorDescriptor colorDescriptor = color = labelDescriptor == null ? null : labelDescriptor.getForeground(value);
        if (this.valueColor != null) {
            this.valueColor.dispose();
        }
        this.valueColor = color == null ? null : color.createColor((Device)Display.getCurrent());
        FontDescriptor fontDescriptor = font = labelDescriptor == null ? null : labelDescriptor.getFont(value);
        if (this.valueFont != null) {
            this.valueFont.dispose();
        }
        Font font2 = this.valueFont = font == null ? null : font.createFont((Device)Display.getCurrent());
        if (this.valueLayout != null && !this.valueLayout.isDisposed()) {
            String valueText;
            String string = labelDescriptor == null ? (value == null ? "" : value.toString()) : (valueText = labelDescriptor.getText(value));
            if (valueText == null) {
                valueText = "";
            }
            this.valueLayout.setText(valueText);
            this.valueLayout.setStyle(new TextStyle(this.valueFont == null ? this.canvas.getFont() : this.valueFont, this.valueColor == null ? this.canvas.getForeground() : this.valueColor, null), 0, valueText.length());
        }
        this.canvas.redraw();
    }

    private void updateEditor() {
        if (this.editor != null) {
            this.editor.setValue(this.source.getPropertyValue(this.descriptor.getId()));
        }
    }

    private void selectSingle() {
        this.parent.select(this);
    }

    private boolean selectNext() {
        return this.parent.select(this.getNext());
    }

    private boolean selectPrev() {
        return this.parent.select(this.getPrevious());
    }

    protected void handleDoubleClick() {
        this.open();
    }

    protected void handleSingleClick() {
        this.selectSingle();
        this.setFocus();
    }

    protected boolean handleKeyTraverse(int traversal) {
        if (traversal == 4) {
            if (this.editor != null) {
                if (this.editor.isActivated()) {
                    this.changeProperty(this.editor.getValue());
                    this.hideEditor();
                    this.update();
                } else {
                    this.open();
                }
            }
            return false;
        }
        if (traversal == 32) {
            return true;
        }
        if (traversal == 64) {
            return true;
        }
        if (traversal == 16) {
            return true;
        }
        if (traversal == 8) {
            return true;
        }
        if (traversal == 2) {
            if (this.editor.isActivated()) {
                this.hideEditor();
                this.update();
                return false;
            }
            return true;
        }
        return false;
    }

    protected void handleKeyPress(int keyCode, int stateMask) {
        if (stateMask == 0) {
            if (keyCode == 0x1000002 || keyCode == 0x1000004) {
                this.selectNext();
            } else if (keyCode == 0x1000001 || keyCode == 0x1000003) {
                this.selectPrev();
            }
        }
    }

    protected void handleMouseMove(int x, int y) {
        this.setShowingHover(this.isInHover(x, y));
        if (this.editor != null) {
            if (!this.editor.isActivated()) {
                if (this.isInEditorHover(x, y)) {
                    this.setShowingEditorHover(true);
                } else {
                    this.setShowingEditorHover(false);
                }
            } else {
                this.setShowingEditorHover(false);
            }
        }
    }

    protected boolean isInHover(int x, int y) {
        Rectangle r = this.canvas.getBounds();
        return x >= 0 && y >= 0 && x < r.width && y < r.height;
    }

    protected boolean isInEditorHover(int x, int y) {
        Rectangle r = this.canvas.getBounds();
        return x > r.width / 2 && x < r.width && y >= 0 && y < r.height;
    }

    private void setShowingHover(boolean showing) {
        if (showing == this.showingHover) {
            return;
        }
        this.showingHover = showing;
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    private void setShowingEditorHover(boolean showing) {
        if (showing == this.showingEditorHover) {
            return;
        }
        this.showingEditorHover = showing;
        if (this.canvas != null && !this.canvas.isDisposed()) {
            if (showing) {
                this.canvas.setCursor(this.canvas.getDisplay().getSystemCursor(21));
            } else {
                this.canvas.setCursor(null);
            }
            this.canvas.redraw();
        }
    }

    @Override
    public PropertyEditingEntry getPrevious() {
        return this.prev;
    }

    @Override
    public PropertyEditingEntry getNext() {
        return this.next;
    }

    @Override
    public void setPrevious(PropertyEditingEntry element) {
        this.prev = element;
    }

    @Override
    public void setNext(PropertyEditingEntry element) {
        this.next = element;
    }

    public void setPopupMenu(Menu menu) {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.setMenu(menu);
        }
    }

    private void handleCopy() {
        String propertyId = this.descriptor.getId();
        Object value = this.source.getPropertyValue(propertyId);
        IPropertyTransfer transfer = this.parent.getTransfer();
        if (transfer != null) {
            transfer.setPropertyValueToClipboard(propertyId, value);
        }
    }

    private void handlePaste() {
        String propertyId = this.descriptor.getId();
        IPropertyTransfer transfer = this.parent.getTransfer();
        if (transfer != null) {
            Object value = transfer.getPropertyValueFromClipboard(propertyId);
            this.source.setPropertyValue(propertyId, value);
        }
    }

    @Override
    public boolean isTextOperation() {
        return this.descriptor.isTextOperation();
    }

    protected class PropertyEditingCanvas
    extends Canvas {
        public PropertyEditingCanvas(Composite parent, int style) {
            super(parent, style);
        }

        public void copy() {
            PropertyEditingEntry.this.handleCopy();
        }

        public void paste() {
            PropertyEditingEntry.this.handlePaste();
        }
    }
}

