/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmind.core.IIdentifiable;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;

public class HyperlinkUtils {
    private HyperlinkUtils() {
    }

    public static String getProtocolName(String uri) {
        int i = uri.indexOf(58);
        return i < 0 ? null : uri.substring(0, i);
    }

    public static String trimURLContent(String uri) {
        int i = uri.indexOf(58);
        if (i >= 0) {
            uri = uri.substring(i + 1);
            while (uri.startsWith("/")) {
                uri = uri.substring(1);
            }
        }
        return uri;
    }

    public static String trimFileUrlContent(String uri) {
        if (uri.startsWith("file://")) {
            return uri.substring("file://".length());
        }
        return uri;
    }

    public static String getAttachmentProtocolName() {
        return "xap";
    }

    public static String getFileProtocolName() {
        return "file";
    }

    public static boolean isFileUrl(String url) {
        if (url == null || "".equals(url)) {
            return false;
        }
        return HyperlinkUtils.getFileProtocolName().equals(HyperlinkUtils.getProtocolName(url));
    }

    public static boolean isAttachmentURL(String url) {
        if (url == null || "".equals(url)) {
            return false;
        }
        String protocol = HyperlinkUtils.getProtocolName(url);
        return HyperlinkUtils.getAttachmentProtocolName().equals(protocol);
    }

    public static String toAttachmentURL(String path) {
        return String.valueOf(HyperlinkUtils.getAttachmentProtocolName()) + ":" + path;
    }

    public static String toAttachmentPath(String url) {
        return HyperlinkUtils.trimURLContent(url);
    }

    public static boolean isInternalAttachmentURL(String url) {
        if (url == null || "".equals(url)) {
            return false;
        }
        return url.startsWith("platform:/plugin");
    }

    public static String getInternalProtocolName() {
        return "xmind";
    }

    public static boolean isInternalURL(String url) {
        if (url == null || "".equals(url)) {
            return false;
        }
        return HyperlinkUtils.getInternalProtocolName().equals(HyperlinkUtils.getProtocolName(url));
    }

    public static String toInternalURL(String elementId) {
        return String.valueOf(HyperlinkUtils.getInternalProtocolName()) + ":#" + elementId;
    }

    public static String toInternalURL(Object element) {
        return HyperlinkUtils.toInternalURL(element, null);
    }

    public static String toInternalURL(Object element, IWorkbook workbook) {
        if (element instanceof IIdentifiable) {
            String id = ((IIdentifiable)element).getId();
            return String.valueOf(HyperlinkUtils.getInternalProtocolName()) + ":#" + id;
        }
        return null;
    }

    public static String toElementID(String uri) {
        int index;
        if (HyperlinkUtils.isInternalURL(uri) && (index = uri.indexOf("#")) >= 0) {
            return uri.substring(index + 1);
        }
        return null;
    }

    public static Object findElement(String uri, IWorkbook workbook) {
        String id = HyperlinkUtils.toElementID(uri);
        if (id != null) {
            Object element = workbook.getElementById(id);
            if (element instanceof ITopic && !HyperlinkUtils.isAttach((ITopic)element)) {
                element = null;
            }
            return element;
        }
        return null;
    }

    private static boolean isAttach(ITopic topic) {
        return topic.getPath().getWorkbook() == topic.getOwnedWorkbook();
    }

    public static boolean isLinkToWeb(String urlOrBookmark) {
        return urlOrBookmark.contains("www.") || urlOrBookmark.contains(".com") || urlOrBookmark.contains(".cn") || urlOrBookmark.contains(".org") || urlOrBookmark.contains(".cc") || urlOrBookmark.contains(".net");
    }

    public static boolean isUrlAddress(String text) {
        Pattern pattern = Pattern.compile("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
        Matcher matcher = !text.contains("http://") && !text.contains("https://") && !text.contains("file://") ? pattern.matcher("http://" + text) : pattern.matcher(text);
        return matcher.matches() && HyperlinkUtils.isLinkToWeb(text);
    }

    public static boolean isEmailAddress(String text) {
        Pattern pattern = Pattern.compile("^([\\w_\\-\\.]+)@((\\[[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.)|(([\\w\\-]+\\.)+))([a-zA-Z]{2,4}|[\\d]{1,3})(\\]?)$");
        Matcher matcher = pattern.matcher(text);
        return matcher.matches();
    }
}

