/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.gefext;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.gantt2.gefext.HandleFigure;
import org.xmind.ui.gantt2.gefext.IBoundingPathProvider;
import org.xmind.ui.gantt2.gefext.PathDescriptor;

public class GlowFeedbackFigure
extends HandleFigure {
    private static final float[] BOUNDS_ARRAY = new float[4];
    private PathDescriptor path;
    private float lineWidth = 7.0f;

    public void setLineWidth(float lineWidth) {
        if (lineWidth == this.lineWidth) {
            return;
        }
        this.lineWidth = lineWidth;
        this.revalidate();
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    private PathDescriptor getHostBoundingPath() {
        if (this.getHost() instanceof IBoundingPathProvider) {
            return ((IBoundingPathProvider)this.getHost()).getBoundingPath();
        }
        return this.getDefaultBoundingPath(this.getHost());
    }

    private PathDescriptor getDefaultBoundingPath(IFigure host) {
        Rectangle r = host.getBounds();
        return new PathDescriptor(7).addRectangle(r);
    }

    protected void calculateBounds(Rectangle source, Rectangle target) {
        this.path = this.getHostBoundingPath();
        if (this.path == null) {
            target.setBounds(source);
        } else {
            Path path = new Path((Device)Display.getCurrent());
            try {
                this.path.applyTo(path);
                path.getBounds(BOUNDS_ARRAY);
                if (Util.isWindows()) {
                    float[] autoScaleDown = DPIUtil.autoScaleDown((float[])BOUNDS_ARRAY);
                    GlowFeedbackFigure.BOUNDS_ARRAY[0] = autoScaleDown[0];
                    GlowFeedbackFigure.BOUNDS_ARRAY[1] = autoScaleDown[1];
                    GlowFeedbackFigure.BOUNDS_ARRAY[2] = autoScaleDown[2];
                    GlowFeedbackFigure.BOUNDS_ARRAY[3] = autoScaleDown[3];
                }
                float lw = this.getLineWidth();
                float lw2 = lw + lw;
                target.x = (int)Math.floor(BOUNDS_ARRAY[0] - lw);
                target.y = (int)Math.floor(BOUNDS_ARRAY[1] - lw);
                target.width = (int)Math.ceil(BOUNDS_ARRAY[2] + lw2);
                target.height = (int)Math.ceil(BOUNDS_ARRAY[3] + lw2);
            }
            finally {
                path.dispose();
            }
        }
    }

    public boolean containsPoint(int x, int y) {
        return false;
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.path == null) {
            return;
        }
        Path path = new Path((Device)Display.getCurrent());
        try {
            this.path.applyTo(path);
            graphics.setLineJoin(2);
            graphics.setLineCap(2);
            if (this.getHost() instanceof Shape) {
                graphics.setLineStyle(((Shape)this.getHost()).getLineStyle());
                graphics.setLineDash(((Shape)this.getHost()).getLineDash());
            } else {
                graphics.setLineStyle(1);
            }
            int alpha = 16;
            int alphaAccel = 2;
            float lw = this.getLineWidth();
            while (lw > 0.0f) {
                graphics.setAlpha(alpha);
                graphics.setLineWidthFloat(lw);
                graphics.drawPath(path);
                lw -= 1.0f;
                alpha += alphaAccel;
                alphaAccel += 2;
            }
        }
        finally {
            path.dispose();
        }
    }
}

