/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.swt.graphics.Color;
import org.xmind.ui.gantt2.gefext.IPathShape;
import org.xmind.ui.gantt2.gefext.PathShape;
import org.xmind.ui.gantt2.viewer.DependencyArrowDecoration;

public class DependencySelectionShape
extends PathShape
implements PropertyChangeListener {
    private IPathShape host;

    public DependencySelectionShape(IPathShape host, Color color) {
        this.setHost(host);
        this.setForegroundColor(color);
        this.setAlpha(170);
        this.setLineWidthFloat(5.0f);
        this.setLineJoin(2);
        this.setFill(false);
        this.setOutline(true);
        DependencyArrowDecoration arrow = new DependencyArrowDecoration();
        arrow.setForegroundColor(color);
        arrow.setHost(this);
        this.add(arrow);
    }

    public void setHost(IPathShape host) {
        if (host == this.host) {
            return;
        }
        IPathShape oldHost = this.getHost();
        this.host = host;
        this.hostChanged(host, oldHost);
    }

    protected void hostChanged(IPathShape newHost, IPathShape oldHost) {
        if (oldHost != null) {
            oldHost.removePropertyChangeListener("outline path", this);
        }
        if (newHost != null) {
            newHost.addPropertyChangeListener("outline path", this);
        }
        if (newHost != null) {
            this.setOutlinePath(newHost.getOutlinePath());
        } else {
            this.setOutlinePath(DEFAULT_PATH_DATA);
        }
    }

    public IPathShape getHost() {
        return this.host;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.setOutlinePath(this.getHost().getOutlinePath());
    }
}

