/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.xmind.cathy.internal.ILogger;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.ui.util.Cancelable;
import org.xmind.ui.util.ICancelable;

public class EditorStatePersistance {
    private static final String PATH_SESSION = "editorstates.xml";
    private final IWorkbench workbench;
    private final IPath basePath;
    private final ILogger logger;
    private final int autoSaveIntervals;
    private ICancelable autoSaveTask;

    public EditorStatePersistance(IWorkbench workbench, IPath basePath, ILogger logger, int autoSaveIntervals) {
        this.workbench = workbench;
        this.basePath = basePath;
        this.logger = logger == null ? ILogger.DEFAULT : logger;
        this.autoSaveIntervals = autoSaveIntervals;
        this.autoSaveTask = null;
    }

    public void startUp() throws WorkbenchException {
        Display display = this.workbench.getDisplay();
        Assert.isNotNull((Object)display);
        Assert.isTrue((display == Display.getCurrent() ? 1 : 0) != 0);
        try {
            this.recoverLastSession();
        }
        catch (Throwable throwable) {
            this.schedule(display);
            this.workbench.addWorkbenchListener(new IWorkbenchListener(){

                public boolean preShutdown(IWorkbench workbench, boolean forced) {
                    return true;
                }

                public void postShutdown(IWorkbench workbench) {
                    EditorStatePersistance.this.shutDown();
                }
            });
            throw throwable;
        }
        this.schedule(display);
        this.workbench.addWorkbenchListener(new /* invalid duplicate definition of identical inner class */);
    }

    private File getSessionFile() {
        return this.basePath.append(PATH_SESSION).toFile();
    }

    private void recoverLastSession() throws WorkbenchException {
        IWorkbenchPage page;
        XMLMemento root;
        File sessionFile = this.getSessionFile();
        if (sessionFile == null || !sessionFile.exists()) {
            return;
        }
        try {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(sessionFile));
                root = XMLMemento.createReadRoot((Reader)reader);
            }
            catch (IOException e) {
                this.logger.logError(null, e);
                sessionFile.delete();
                return;
            }
        }
        finally {
            sessionFile.delete();
        }
        Object[] states = root.getChildren("editor");
        if (states.length == 0) {
            return;
        }
        ListSelectionDialog dialog = new ListSelectionDialog(null, (Object)states, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new EditorStateLabelProvider(), WorkbenchMessages.appWindow_ListSelectionDialog_Text);
        dialog.setTitle(WorkbenchMessages.appWindow_ListSelectionDialog_Title);
        dialog.setInitialSelections(states);
        int ret = dialog.open();
        if (ret == 1) {
            return;
        }
        Object[] result = dialog.getResult();
        if (result == null) {
            return;
        }
        states = new IMemento[result.length];
        System.arraycopy(result, 0, states, 0, result.length);
        IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
        if (window == null) {
            window = this.workbench.openWorkbenchWindow(null);
        }
        if ((page = window.getActivePage()) == null) {
            page = window.openPage(null);
        }
        page.openEditors(null, null, (IMemento[])states, 0, 0);
    }

    public void shutDown() {
        File sessionFile;
        ICancelable task = this.autoSaveTask;
        this.autoSaveTask = null;
        if (task != null) {
            task.cancel();
        }
        if ((sessionFile = this.getSessionFile()) != null) {
            sessionFile.delete();
        }
    }

    private void schedule(final Display display) {
        ICancelable oldTask = this.autoSaveTask;
        Cancelable task = new Cancelable(){

            protected void doJob() {
                EditorStatePersistance.this.autoSave(display);
            }
        };
        this.autoSaveTask = task;
        display.timerExec(this.autoSaveIntervals, (Runnable)task);
        if (oldTask != null) {
            oldTask.cancel();
        }
    }

    private void autoSave(Display display) {
        try {
            this.save();
        }
        catch (Throwable e) {
            this.logger.logError(null, e);
        }
        this.schedule(display);
    }

    private void save() throws IOException {
        File sessionFile = this.getSessionFile();
        if (sessionFile == null) {
            return;
        }
        ArrayList<IMemento> states = new ArrayList<IMemento>();
        IWorkbenchWindow[] iWorkbenchWindowArray = this.workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = window.getActivePage();
            if (page != null) {
                IMemento[] editorState = page.getEditorState(page.getEditorReferences(), true);
                states.addAll(Arrays.asList(editorState));
            }
            ++n2;
        }
        XMLMemento root = XMLMemento.createWriteRoot((String)"editors");
        for (IMemento state : states) {
            IMemento st = root.createChild(state.getType());
            st.putMemento(state);
        }
        File dir = sessionFile.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(sessionFile));
        try {
            root.save((Writer)writer);
        }
        finally {
            writer.close();
        }
    }

    private class EditorStateLabelProvider
    extends LabelProvider {
        private LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources());

        public String getText(Object element) {
            if (element instanceof IMemento) {
                IEditorDescriptor editor;
                String editorId;
                IMemento state = (IMemento)element;
                String name = state.getString("title");
                if (name == null) {
                    name = state.getString("name");
                }
                if (name == null) {
                    name = state.getString("partName");
                }
                if (name == null && (editorId = state.getString("id")) != null && (editor = EditorStatePersistance.this.workbench.getEditorRegistry().findEditor(editorId)) != null) {
                    name = editor.getLabel();
                }
                if (name == null) {
                    name = "";
                }
                return name;
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            ImageDescriptor icon;
            IEditorDescriptor editor;
            IMemento state;
            String editorId;
            if (element instanceof IMemento && (editorId = (state = (IMemento)element).getString("id")) != null && (editor = EditorStatePersistance.this.workbench.getEditorRegistry().findEditor(editorId)) != null && (icon = editor.getImageDescriptor()) != null) {
                return (Image)this.resources.get((DeviceResourceDescriptor)icon);
            }
            return super.getImage(element);
        }

        public void dispose() {
            this.resources.dispose();
            super.dispose();
        }
    }
}

