/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.renderer;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.CSSRenderingUtils;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;

public class XToolBarManagerRenderer
extends ToolBarManagerRenderer {
    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MToolBar) || !(parent instanceof Composite)) {
            return null;
        }
        MToolBar toolbarModel = (MToolBar)element;
        ToolBar newTB = this.createToolbar((MUIElement)toolbarModel, (Composite)parent);
        this.bindWidget(element, newTB);
        this.processContribution(toolbarModel, toolbarModel.getElementId());
        ToolBar renderedCtrl = newTB;
        MElementContainer parentElement = element.getParent();
        if (parentElement instanceof MTrimBar) {
            this.setCSSInfo(element, newTB);
            boolean vertical = false;
            MTrimBar bar = (MTrimBar)parentElement;
            vertical = bar.getSide() == SideValue.LEFT || bar.getSide() == SideValue.RIGHT;
            IEclipseContext parentContext = this.getContextForParent(element);
            CSSRenderingUtils cssUtils = (CSSRenderingUtils)parentContext.get(CSSRenderingUtils.class);
            if (cssUtils != null) {
                MUIElement modelElement = (MUIElement)newTB.getData("modelElement");
                boolean draggable = modelElement != null && modelElement.getTags().contains("Draggable");
                renderedCtrl = cssUtils.frameMeIfPossible((Control)newTB, null, vertical, draggable);
            }
        }
        return renderedCtrl;
    }

    public Object getUIContainer(MUIElement childElement) {
        Composite intermediate = (Composite)super.getUIContainer(childElement);
        if (intermediate == null || intermediate.isDisposed()) {
            return null;
        }
        if (intermediate instanceof ToolBar) {
            return intermediate;
        }
        ToolBar toolbar = this.findToolbar(intermediate);
        if (toolbar == null) {
            toolbar = this.createToolbar((MUIElement)childElement.getParent(), intermediate);
        }
        return toolbar;
    }

    private ToolBar findToolbar(Composite intermediate) {
        Control[] controlArray = intermediate.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.getData() instanceof ToolBarManager) {
                return (ToolBar)child;
            }
            ++n2;
        }
        return null;
    }

    private ToolBar createToolbar(MUIElement element, Composite parent) {
        int orientation = this.getOrientationStyle(element);
        int style = orientation | 0x40 | 0x800000 | 0x20000;
        ToolBarManager manager = this.getManager((MToolBar)element);
        if (manager == null) {
            manager = new ToolBarManager(style);
            IContributionManagerOverrides overrides = null;
            MElementContainer parentElement = element.getParent();
            if (parentElement != null) {
                overrides = (IContributionManagerOverrides)parentElement.getTransientData().get(IContributionManagerOverrides.class.getName());
            }
            manager.setOverrides(overrides);
            this.linkModelToManager((MToolBar)element, manager);
        } else {
            ToolBar toolBar = manager.getControl();
            if (toolBar != null && !toolBar.isDisposed() && (toolBar.getStyle() & orientation) == 0) {
                toolBar.dispose();
            }
            manager.setStyle(style);
        }
        ToolBar bar = manager.createControl(parent);
        bar.setData((Object)manager);
        bar.setData("modelElement", (Object)element);
        bar.getShell().layout(new Control[]{bar}, 4);
        return bar;
    }

    private int getOrientationStyle(MUIElement element) {
        MTrimBar trimContainer;
        SideValue side;
        MElementContainer theParent = element.getParent();
        if (theParent instanceof MTrimBar && ((side = (trimContainer = (MTrimBar)theParent).getSide()).getValue() == 2 || side.getValue() == 3)) {
            return 512;
        }
        return 256;
    }
}

