/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spelling;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.ui.browser.BrowserSupport;
import org.xmind.ui.browser.IBrowser;
import org.xmind.ui.internal.spelling.ISpellCheckerDescriptor;
import org.xmind.ui.internal.spelling.Messages;
import org.xmind.ui.internal.spelling.SpellCheckerAgent;
import org.xmind.ui.internal.spelling.SpellCheckerRegistry;
import org.xmind.ui.internal.spelling.SpellingPlugin;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.viewers.CheckListViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellingCheckPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String SPELLING_HELP_URL = "https://xmind.desk.com/customer/portal/articles/690243";
    private static final Object DEFAULT_PLACEHOLDER = Messages.defaultDictionary;
    private List<FieldEditor> settingFields = new ArrayList<FieldEditor>();
    private Composite settingsParent;
    private ResourceManager resources;
    private CheckListViewer dictionaryViewer;
    private Button addButton;
    private Button removeButton;
    private List<Element> addElementReferences = new ArrayList<Element>();
    private List<ISpellCheckerDescriptor> removeDescriptorReferences = new ArrayList<ISpellCheckerDescriptor>();

    public SpellingCheckPrefPage() {
        super(Messages.SpellingPrefPage_title, 0);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(SpellingPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("SPELLING_CHECK_ENABLED", Messages.enableSpellCheck, this.getFieldEditorParent()));
        this.addSpellingSettings(this.getFieldEditorParent());
        this.addDictionariesPanel(this.getFieldEditorParent());
        this.updateOptions(SpellingPlugin.isSpellingCheckEnabled());
        this.updateDictionaryControls();
    }

    private void addSpellingSettings(Composite composite) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        this.settingsParent = this.createSettingsParent(composite);
        this.addSettingField("SPELL_IGNOREUPPERCASE", Messages.ignoreAllCapital);
        this.addSettingField("SPELL_IGNOREMIXEDCASE", Messages.ignoreMultiCapital);
        this.addSettingField("SPELL_IGNOREINTERNETADDRESS", Messages.ignoreWebAddress);
        this.addSettingField("SPELL_IGNOREDIGITWORDS", Messages.ignoreNumberousAppendix);
        this.addSettingField("SPELL_IGNORESENTENCECAPTILIZATION", Messages.ignoreFirstLowercaseSentences);
    }

    private void addSettingField(String name, String label) {
        BooleanFieldEditor field = new BooleanFieldEditor(name, label, this.settingsParent);
        this.addField((FieldEditor)field);
        this.settingFields.add((FieldEditor)field);
    }

    private Composite createSettingsParent(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginTop = 7;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        parent.setLayout((Layout)layout);
        Group group = new Group(parent, 0);
        group.setText(Messages.options);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout groupLayout = new GridLayout(1, false);
        groupLayout.marginWidth = 5;
        groupLayout.marginHeight = 5;
        groupLayout.verticalSpacing = 5;
        groupLayout.horizontalSpacing = 0;
        group.setLayout((Layout)groupLayout);
        return group;
    }

    private void updateOptions(boolean enabled) {
        this.settingsParent.setEnabled(enabled);
        for (FieldEditor field : this.settingFields) {
            field.setEnabled(enabled, this.settingsParent);
        }
    }

    private void addDictionariesPanel(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginTop = 7;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Group group = new Group(parent, 0);
        group.setText(Messages.dictionaries);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout groupLayout = new GridLayout(2, false);
        groupLayout.marginWidth = 5;
        groupLayout.marginHeight = 5;
        groupLayout.verticalSpacing = 5;
        groupLayout.horizontalSpacing = 5;
        group.setLayout((Layout)groupLayout);
        this.createDictionaryViewer((Composite)group);
        this.createDictionaryControls((Composite)group);
        this.createDetailsLink((Composite)group);
    }

    private void createDictionaryViewer(Composite parent) {
        this.dictionaryViewer = new CheckListViewer(parent, 2048);
        this.dictionaryViewer.getControl().setBackground(parent.getDisplay().getSystemColor(1));
        this.dictionaryViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.dictionaryViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dictionaryViewer.setLabelProvider((IBaseLabelProvider)new DictionaryLabelProvider());
        this.dictionaryViewer.setComparator((ViewerComparator)new DictionaryComparator());
        this.dictionaryViewer.addSelectionChangedListener((ISelectionChangedListener)new DictionarySelectionListener());
        this.dictionaryViewer.addOpenListener((IOpenListener)new DictionaryOpenHandler());
        this.dictionaryViewer.setInput(this.getInput());
        this.initCheckStates();
    }

    private Object getInput() {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (!this.getPreferenceStore().getBoolean("DEFAULT_SPELLING_CHECKER_INVISIBLE")) {
            objects.add(DEFAULT_PLACEHOLDER);
        }
        List<ISpellCheckerDescriptor> descriptors = SpellCheckerRegistry.getInstance().getDescriptors();
        for (ISpellCheckerDescriptor descriptor : descriptors) {
            String name = descriptor.getName();
            boolean enabled = descriptor.isEnabled();
            objects.add(new Element(name, enabled, descriptor, null));
        }
        return objects;
    }

    private void initCheckStates() {
        Object[] elements;
        if (this.dictionaryViewer == null || this.dictionaryViewer.getControl() == null || this.dictionaryViewer.getControl().isDisposed()) {
            return;
        }
        Object[] objectArray = elements = ((IStructuredContentProvider)this.dictionaryViewer.getContentProvider()).getElements(this.dictionaryViewer.getInput());
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            boolean enabled = false;
            if (element instanceof Element) {
                enabled = ((Element)element).isEnabled();
            } else if (element == DEFAULT_PLACEHOLDER) {
                enabled = !this.getPreferenceStore().getBoolean("DEFAULT_SPELLING_CHECKER_DISABLED");
            }
            this.dictionaryViewer.setChecked(element, enabled);
            ++n2;
        }
    }

    private void createDictionaryControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, true));
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        Composite buttonBar = new Composite(composite, 0);
        buttonBar.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        GridLayout buttonBarLayout = new GridLayout(1, true);
        buttonBarLayout.marginWidth = 0;
        buttonBarLayout.marginHeight = 0;
        buttonBarLayout.verticalSpacing = 10;
        buttonBarLayout.horizontalSpacing = 0;
        buttonBar.setLayout((Layout)buttonBarLayout);
        this.createAddDictionaryButton(buttonBar);
        this.createRemoveDictionaryButton(buttonBar);
    }

    private void createDetailsLink(Composite parent) {
        Hyperlink hyperlink = new Hyperlink(parent, 4);
        hyperlink.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)hyperlink.getLayoutData()).horizontalSpan = 2;
        hyperlink.setText(Messages.detailsLink_text);
        hyperlink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#006CF9")));
        hyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                final IBrowser browser = BrowserSupport.getInstance().createBrowser(1);
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        browser.openURL(SpellingCheckPrefPage.SPELLING_HELP_URL);
                    }
                });
            }
        });
    }

    private void createAddDictionaryButton(Composite parent) {
        this.addButton = new Button(parent, 8);
        this.addButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.addButton.setText(Messages.dictionaries_add);
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SpellingCheckPrefPage.this.addDictionaryReference();
            }
        });
    }

    private void createRemoveDictionaryButton(Composite parent) {
        this.removeButton = new Button(parent, 8);
        this.removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.removeButton.setText(Messages.dictionaries_remove);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SpellingCheckPrefPage.this.removeSelectedDictionaryReference();
            }
        });
    }

    private void addDictionaryReference() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.dic;*.dict;*.txt;*.*"});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        ArrayList<String> nameExclusions = new ArrayList<String>();
        if (this.dictionaryViewer.getInput() instanceof List) {
            for (Object obj : (List)this.dictionaryViewer.getInput()) {
                if (!(obj instanceof Element)) continue;
                nameExclusions.add(((Element)obj).getName());
            }
        }
        String addedDictionaryName = SpellCheckerRegistry.getInstance().getImportableDictFileName(new File(path), nameExclusions);
        Element addedElement = new Element(addedDictionaryName, false, null, path);
        if (this.dictionaryViewer.getInput() instanceof List) {
            ((List)this.dictionaryViewer.getInput()).add(addedElement);
        }
        if (!this.addElementReferences.contains(addedElement)) {
            this.addElementReferences.add(addedElement);
        }
        this.dictionaryViewer.refresh();
    }

    private void removeSelectedDictionaryReference() {
        Object selection = ((IStructuredSelection)this.dictionaryViewer.getSelection()).getFirstElement();
        if (selection == null) {
            return;
        }
        String name = ((ILabelProvider)this.dictionaryViewer.getLabelProvider()).getText(selection);
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.dictionaries_remove_confirm_title, (String)NLS.bind((String)Messages.dictionaries_remove_confirm_message, (Object)name))) {
            return;
        }
        this.removeDictionaryReference(selection);
        this.dictionaryViewer.refresh();
    }

    private void removeDictionaryReference(Object obj) {
        if (this.dictionaryViewer.getInput() instanceof List) {
            ((List)this.dictionaryViewer.getInput()).remove(obj);
        }
        if (obj instanceof Element) {
            Element element = (Element)obj;
            if (element.getDescriptor() != null) {
                this.removeDescriptorReferences.add(element.getDescriptor());
            } else if (element.getPath() != null) {
                this.addElementReferences.remove(element);
            }
        }
    }

    private void updateDictionaryControls() {
        ISelection selection = this.dictionaryViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            boolean containDefault = ((IStructuredSelection)selection).toList().contains(DEFAULT_PLACEHOLDER);
            this.removeButton.setEnabled(!this.dictionaryViewer.getSelection().isEmpty() && !containDefault);
        } else {
            this.removeButton.setEnabled(!this.dictionaryViewer.getSelection().isEmpty());
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        FieldEditor field = (FieldEditor)event.getSource();
        if ("SPELLING_CHECK_ENABLED".equals(field.getPreferenceName())) {
            this.updateOptions(((BooleanFieldEditor)field).getBooleanValue());
        }
        super.propertyChange(event);
    }

    public void selectSingleDictionary(ISelection selection) {
        if (this.dictionaryViewer == null || this.dictionaryViewer.getControl() == null || this.dictionaryViewer.getControl().isDisposed()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            Object[] checkedElements;
            Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
            Object[] objectArray = checkedElements = this.dictionaryViewer.getCheckedElements();
            int n = checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object checkedElement = objectArray[n2];
                if (selectedElement != checkedElement) {
                    this.dictionaryViewer.setChecked(checkedElement, false);
                }
                ++n2;
            }
            this.dictionaryViewer.setChecked(selectedElement, true);
        }
    }

    public boolean performOk() {
        boolean needUpdated;
        List<Object> oldEnabledDictionaries = this.getEnabledDictionaries();
        this.removeReferenceDictionarys();
        this.addReferenceDictionarys();
        this.getPreferenceStore().setValue("DEFAULT_SPELLING_CHECKER_INVISIBLE", !((List)this.dictionaryViewer.getInput()).contains(DEFAULT_PLACEHOLDER));
        int i = 0;
        while (i < this.dictionaryViewer.getItemCount()) {
            Object element = this.dictionaryViewer.getElementAt(i);
            boolean enabled = this.dictionaryViewer.getChecked(element);
            if (element instanceof Element) {
                ((Element)element).getDescriptor().setEnabled(enabled);
            } else if (element == DEFAULT_PLACEHOLDER) {
                this.getPreferenceStore().setValue("DEFAULT_SPELLING_CHECKER_DISABLED", !enabled);
            }
            ++i;
        }
        List<Object> newEnabledDictionaries = this.getEnabledDictionaries();
        boolean bl = needUpdated = !oldEnabledDictionaries.equals(newEnabledDictionaries);
        if (needUpdated) {
            SpellCheckerAgent.updateSpellChecker();
        }
        return super.performOk();
    }

    private List<Object> getEnabledDictionaries() {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (!this.getPreferenceStore().getBoolean("DEFAULT_SPELLING_CHECKER_INVISIBLE") && !this.getPreferenceStore().getBoolean("DEFAULT_SPELLING_CHECKER_DISABLED")) {
            objects.add(DEFAULT_PLACEHOLDER);
        }
        List<ISpellCheckerDescriptor> descriptors = SpellCheckerRegistry.getInstance().getDescriptors();
        for (ISpellCheckerDescriptor descriptor : descriptors) {
            if (!descriptor.isEnabled()) continue;
            objects.add(descriptor);
        }
        return objects;
    }

    protected void performDefaults() {
        if (!((List)this.dictionaryViewer.getInput()).contains(DEFAULT_PLACEHOLDER)) {
            ((List)this.dictionaryViewer.getInput()).add(0, DEFAULT_PLACEHOLDER);
            this.dictionaryViewer.refresh();
        }
        int i = 0;
        while (i < this.dictionaryViewer.getItemCount()) {
            Object element = this.dictionaryViewer.getElementAt(i);
            if (element instanceof Element) {
                this.removeDictionaryReference(element);
            } else if (element == DEFAULT_PLACEHOLDER) {
                this.dictionaryViewer.setChecked(element, true);
            }
            ++i;
        }
        super.performDefaults();
        this.dictionaryViewer.refresh();
    }

    private void addReferenceDictionarys() {
        for (Element element : this.addElementReferences) {
            this.addDictionary(element);
        }
        this.addElementReferences.clear();
    }

    private void removeReferenceDictionarys() {
        for (ISpellCheckerDescriptor descriptor : this.removeDescriptorReferences) {
            this.removeDictionary(descriptor);
        }
        this.removeDescriptorReferences.clear();
    }

    private void addDictionary(final Element element) {
        final String path = element.getPath();
        if (path == null) {
            return;
        }
        try {
            ProgressMonitorDialog progress = new ProgressMonitorDialog(this.getShell());
            progress.setOpenOnRun(false);
            progress.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.addingDictionary, 1);
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                        public void run() throws Exception {
                            ISpellCheckerDescriptor descriptor = SpellCheckerRegistry.getInstance().importDictFile(new File(path), element.getName());
                            element.setPath(null);
                            element.setDescriptor(descriptor);
                        }
                    });
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    private void removeDictionary(final ISpellCheckerDescriptor descriptor) {
        try {
            ProgressMonitorDialog progress = new ProgressMonitorDialog(this.getShell());
            progress.setOpenOnRun(false);
            progress.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.removingDictionary, 1);
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                        public void run() throws Exception {
                            SpellCheckerRegistry.getInstance().removeDictionary(descriptor);
                        }
                    });
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public void dispose() {
        if (this.addElementReferences != null) {
            this.addElementReferences.clear();
            this.addElementReferences = null;
        }
        if (this.removeDescriptorReferences != null) {
            this.removeDescriptorReferences.clear();
            this.removeDescriptorReferences = null;
        }
        super.dispose();
    }

    private static class DictionaryComparator
    extends ViewerComparator {
        public DictionaryComparator() {
            super((Comparator)new Comparator<String>(){

                @Override
                public int compare(String n1, String n2) {
                    int s2;
                    String p2;
                    int s1 = n1.lastIndexOf(46);
                    String p1 = s1 < 0 ? n1 : n1.substring(0, s1);
                    int c = p1.compareTo(p2 = (s2 = n2.lastIndexOf(46)) < 0 ? n2 : n2.substring(0, s2));
                    if (c != 0) {
                        return c;
                    }
                    return n1.compareTo(n2);
                }
            });
        }

        public int category(Object element) {
            if (element == DEFAULT_PLACEHOLDER) {
                return 0;
            }
            return 1;
        }
    }

    private static class DictionaryLabelProvider
    extends LabelProvider {
        private DictionaryLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Element) {
                return ((Element)element).getName();
            }
            return super.getText(element);
        }
    }

    private class DictionaryOpenHandler
    implements IOpenListener {
        private DictionaryOpenHandler() {
        }

        public void open(OpenEvent event) {
            SpellingCheckPrefPage.this.selectSingleDictionary(event.getSelection());
        }
    }

    private class DictionarySelectionListener
    implements ISelectionChangedListener {
        private DictionarySelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SpellingCheckPrefPage.this.updateDictionaryControls();
        }
    }

    private static class Element {
        private String name;
        private boolean enabled;
        private ISpellCheckerDescriptor descriptor;
        private String path;

        public Element(String name, boolean enabled, ISpellCheckerDescriptor descriptor, String path) {
            this.name = name;
            this.enabled = enabled;
            this.descriptor = descriptor;
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public ISpellCheckerDescriptor getDescriptor() {
            return this.descriptor;
        }

        public void setDescriptor(ISpellCheckerDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

