/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet.decorations;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.internal.spreadsheet.decorations.HeadTopicDecoration;
import org.xmind.ui.internal.spreadsheet.decorations.SpreadsheetBranchDecoration;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.util.MindMapUtils;

public class RowHeadTopicDecoration
extends HeadTopicDecoration {
    private IGraphicalPart part;

    public RowHeadTopicDecoration(String id, IGraphicalPart part) {
        this.setId(id);
        this.part = part;
    }

    protected void repaint(IFigure figure) {
        IFigure parentBranchFigure;
        SpreadsheetBranchDecoration.Block block;
        super.repaint(figure);
        IBranchPart branch = MindMapUtils.findBranch((IPart)this.part);
        if (branch != null && (block = this.findBlock(branch, parentBranchFigure = this.getParentBranchFigure(branch))) != null) {
            parentBranchFigure.repaint(block.bounds.getOuterBounds());
        }
    }

    private SpreadsheetBranchDecoration.Block findBlock(IBranchPart branch, IFigure parentBranchFigure) {
        SpreadsheetBranchDecoration chartDecoration;
        List<SpreadsheetBranchDecoration.Block> blocks;
        IDecoration parentDecoration;
        if (parentBranchFigure instanceof IDecoratedFigure && (parentDecoration = ((IDecoratedFigure)parentBranchFigure).getDecoration()) instanceof SpreadsheetBranchDecoration && (blocks = (chartDecoration = (SpreadsheetBranchDecoration)parentDecoration).getBlocks()) != null) {
            for (SpreadsheetBranchDecoration.Block block : blocks) {
                if (block.part != branch) continue;
                return block;
            }
        }
        return null;
    }

    private IFigure getParentBranchFigure(IBranchPart branch) {
        IBranchPart parent = branch.getParentBranch();
        if (parent != null) {
            return parent.getFigure();
        }
        return null;
    }
}

