/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet.structures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.branch.BranchStructureData;
import org.xmind.ui.internal.spreadsheet.structures.Cell;
import org.xmind.ui.internal.spreadsheet.structures.Column;
import org.xmind.ui.internal.spreadsheet.structures.ColumnHead;
import org.xmind.ui.internal.spreadsheet.structures.ColumnOrder;
import org.xmind.ui.internal.spreadsheet.structures.Item;
import org.xmind.ui.internal.spreadsheet.structures.Row;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.style.StyleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart
extends BranchStructureData {
    private List<Row> rows = null;
    private List<Column> cols = null;
    private int titleAreaHeight = -1;
    private int columnHeadHeight = -1;
    private int rowHeadWidth = -1;
    private int lineWidth = -1;
    private ColumnOrder prefColumnOrder = null;

    public Chart(IBranchPart branch) {
        super(branch);
    }

    void setContent(Row row, Column ... col) {
        this.rows = Collections.singletonList(row);
        this.cols = Arrays.asList(col);
    }

    void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public IBranchPart getTitle() {
        return super.getBranch();
    }

    public List<Row> getRows() {
        this.ensureBuilt();
        return this.rows;
    }

    public List<Column> getColumns() {
        this.ensureBuilt();
        return this.cols;
    }

    public boolean hasRows() {
        return !this.getRows().isEmpty();
    }

    public boolean hasColumns() {
        return !this.getColumns().isEmpty();
    }

    public int getNumRows() {
        return this.getRows().size();
    }

    public int getNumColumns() {
        return this.getColumns().size();
    }

    public int getNumValidColumns() {
        int num = 0;
        for (Column col : this.getColumns()) {
            if (ColumnHead.EMPTY.equals(col.getHead()) || col.getCells().isEmpty()) continue;
            ++num;
        }
        return num;
    }

    public Row getRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRows().size()) {
            return null;
        }
        return this.getRows().get(rowIndex);
    }

    public Column getColumn(int colIndex) {
        if (colIndex < 0 || colIndex >= this.getColumns().size()) {
            return null;
        }
        return this.getColumns().get(colIndex);
    }

    private void ensureBuilt() {
        if (this.rows != null && this.cols != null) {
            return;
        }
        this.rows = null;
        this.cols = null;
        this.lazyBuild();
        if (this.rows == null) {
            this.rows = Collections.emptyList();
        }
        if (this.cols == null) {
            this.cols = new ArrayList<Column>(1);
            this.cols.add(new Column(this, ColumnHead.EMPTY));
        }
    }

    private void lazyBuild() {
        if (this.getTitle() == null) {
            return;
        }
        HashMap<Row, ArrayList<Item>> rowItems = null;
        HashMap<Column, ArrayList<Item>> colItems = null;
        ArrayList<Column> cols2 = new ArrayList<Column>();
        for (IBranchPart rowHead : this.getTitle().getSubBranches()) {
            ArrayList<Item> items = new ArrayList<Item>();
            Row row = this.buildRow(rowHead, items);
            if (items.isEmpty()) continue;
            if (rowItems == null) {
                rowItems = new HashMap<Row, ArrayList<Item>>();
            }
            rowItems.put(row, items);
            for (Item item : items) {
                ArrayList<Item> list;
                Column col;
                ColumnHead prefHead = item.getPrefColumnHead();
                if (prefHead == null) continue;
                Column column = col = colItems == null ? null : this.findColumn(colItems.keySet(), prefHead);
                if (col == null) {
                    col = new Column(this, prefHead);
                    cols2.add(col);
                    list = new ArrayList();
                    list.add(item);
                    if (colItems == null) {
                        colItems = new HashMap<Column, ArrayList<Item>>();
                    }
                    colItems.put(col, list);
                    continue;
                }
                list = (ArrayList<Item>)colItems.get(col);
                if (list == null) {
                    list = new ArrayList<Item>();
                    colItems.put(col, list);
                }
                list.add(item);
            }
        }
        int i = 0;
        while (i < cols2.size()) {
            ((Column)cols2.get(i)).getHead().setIndex(i);
            ++i;
        }
        if (colItems != null) {
            this.cols = new ArrayList(new TreeSet(colItems.keySet()));
        }
        if (this.cols == null) {
            this.cols = new ArrayList<Column>(1);
        }
        if (this.cols.isEmpty()) {
            this.cols.add(new Column(this, ColumnHead.EMPTY));
        }
        this.buildCells(rowItems, (Map<Column, List<Item>>)colItems);
    }

    private void buildCells(Map<Row, List<Item>> rowItems, Map<Column, List<Item>> colItems) {
        if (this.rows == null || this.cols == null) {
            return;
        }
        for (Row row : this.rows) {
            for (Column col : this.cols) {
                this.buildCell(row, col, rowItems, colItems);
            }
        }
    }

    private void buildCell(Row row, Column col, Map<Row, List<Item>> rowItems, Map<Column, List<Item>> colItems) {
        List<Item> cItems;
        Cell cell = new Cell(this, row, col);
        row.addCell(cell);
        col.addCell(cell);
        List<Item> rItems = rowItems == null ? null : rowItems.get((Object)row);
        List<Item> list = cItems = colItems == null ? null : colItems.get(col);
        if (rItems != null && cItems != null) {
            for (Item item : rItems) {
                if (!cItems.contains((Object)item)) continue;
                cell.addItem(item);
            }
        }
    }

    private Column findColumn(Collection<Column> columns, ColumnHead colHead) {
        for (Column col : columns) {
            if (!colHead.equals(col.getHead())) continue;
            return col;
        }
        return null;
    }

    private Row buildRow(IBranchPart rowHead, List<Item> rowItems) {
        Row row = new Row(rowHead, this);
        if (this.rows == null) {
            this.rows = new ArrayList<Row>();
        }
        this.rows.add(row);
        for (IBranchPart child : rowHead.getSubBranches()) {
            Item item = new Item(this, child);
            rowItems.add(item);
        }
        return row;
    }

    public int getTitleAreaHeight() {
        if (this.titleAreaHeight < 0) {
            this.titleAreaHeight = this.calcTitleAreaHeight();
        }
        return this.titleAreaHeight;
    }

    private int calcTitleAreaHeight() {
        int h = 0;
        int y = this.getBranch().getFigure().getBounds().y;
        IInfoPart info = this.getBranch().getInfoPart();
        if (info != null && info.getFigure().isVisible()) {
            h = info.getFigure().getBounds().bottom() - y;
        } else {
            ITopicPart topicPart = this.getBranch().getTopicPart();
            if (topicPart != null && topicPart.getFigure().isVisible()) {
                h = topicPart.getFigure().getBounds().bottom() - y;
            }
        }
        return h;
    }

    public int getColumnHeadHeight() {
        if (this.columnHeadHeight < 0) {
            this.columnHeadHeight = this.calcColumnHeadHeight();
        }
        return this.columnHeadHeight;
    }

    private int calcColumnHeadHeight() {
        int sum = 0;
        for (Column c : this.getColumns()) {
            sum = Math.max(sum, c.getHead().getPrefSize().height);
        }
        return sum;
    }

    public int getRowHeadWidth() {
        if (this.rowHeadWidth < 0) {
            this.rowHeadWidth = this.calcRowHeadWidth();
        }
        return this.rowHeadWidth;
    }

    private int calcRowHeadWidth() {
        int sum = 0;
        for (Row row : this.getRows()) {
            IInfoPart infoPart;
            IBranchPart head = row.getHead();
            ITopicPart topicPart = head.getTopicPart();
            if (topicPart != null) {
                sum = Math.max(sum, topicPart.getFigure().getBounds().width);
            }
            if ((infoPart = head.getInfoPart()) == null) continue;
            sum = Math.max(sum, infoPart.getFigure().getBounds().width);
        }
        return sum;
    }

    public int getLineWidth() {
        if (this.lineWidth < 0) {
            IStyleSelector ss = StyleUtils.getStyleSelector((IGraphicalPart)this.getBranch());
            String decorationId = StyleUtils.getString((IGraphicalPart)this.getBranch(), (IStyleSelector)ss, (String)"shape-class", null);
            this.lineWidth = StyleUtils.getInteger((IGraphicalPart)this.getBranch(), (IStyleSelector)ss, (String)"line-width", (String)decorationId, (int)1);
        }
        return this.lineWidth;
    }

    public int getMajorSpacing() {
        if (this.getBranch() == null) {
            return 5;
        }
        return super.getMajorSpacing();
    }

    public int getMinorSpacing() {
        if (this.getBranch() == null) {
            return 1;
        }
        return super.getMinorSpacing();
    }

    public Row getPreviousRow(Row row) {
        int index = this.getRowIndex(row);
        if (index > 0) {
            return this.getRows().get(index - 1);
        }
        return null;
    }

    public Row getNextRow(Row row) {
        int index = this.getRowIndex(row);
        if (index < this.getRows().size() - 1) {
            return this.getRows().get(index + 1);
        }
        return null;
    }

    public int getRowIndex(Row row) {
        return this.getRows().indexOf((Object)row);
    }

    public Column getPreviousColumn(Column col) {
        int index = this.getColumnIndex(col);
        if (index > 0) {
            return this.getColumns().get(index - 1);
        }
        return null;
    }

    public Column getNextColumn(Column col) {
        int index = this.getColumnIndex(col);
        if (index < this.getColumns().size() - 1) {
            return this.getColumns().get(index + 1);
        }
        return null;
    }

    public int getColumnIndex(Column col) {
        return this.getColumns().indexOf(col);
    }

    public Cell findCell(Point point) {
        for (Row row : this.getRows()) {
            for (Cell cell : row.getCells()) {
                if (!cell.getBounds().contains(point)) continue;
                return cell;
            }
        }
        return null;
    }

    public ColumnHead findColumnHead(Point point) {
        if (this.hasRows()) {
            int y = this.getTitle().getTopicPart().getFigure().getBounds().bottom() + this.getLineWidth();
            if (this.getTitle().getInfoPart() != null) {
                y += this.getTitle().getInfoPart().getFigure().getBounds().height;
            }
            if (point.y > y && point.y < y + this.getColumnHeadHeight() + this.getMajorSpacing()) {
                for (Column col : this.getColumns()) {
                    int x = col.getLeft();
                    if (point.x <= x || point.x >= x + col.getWidth()) continue;
                    return col.getHead();
                }
            }
        }
        return null;
    }

    public Column findColumn(ColumnHead colHead) {
        for (Column col : this.getColumns()) {
            if (!col.getHead().equals(colHead)) continue;
            return col;
        }
        return null;
    }

    public ColumnOrder getPrefColumnOrder() {
        if (this.prefColumnOrder == null) {
            this.prefColumnOrder = ColumnOrder.createFromTopic(this.getTitle().getTopic());
        }
        return this.prefColumnOrder;
    }
}

