/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet.structures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.ui.internal.spreadsheet.structures.ColumnHead;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnOrder {
    public static final ColumnOrder EMPTY = new ColumnOrder(true);
    private List<ColumnHead> heads;

    public ColumnOrder() {
        this(false);
    }

    private ColumnOrder(boolean empty) {
        this.heads = empty ? Collections.emptyList() : new ArrayList<ColumnHead>();
    }

    public void addColumnHead(ColumnHead head) {
        if (this != EMPTY) {
            this.heads.add(head);
        }
    }

    public boolean isEmpty() {
        return this.heads.isEmpty();
    }

    public List<ColumnHead> getHeads() {
        return this.heads;
    }

    public int compareColumns(ColumnHead head1, ColumnHead head2) {
        int index1 = this.heads.indexOf(head1);
        int index2 = this.heads.indexOf(head2);
        if (index1 < 0) {
            if (index2 < 0) {
                return head1.compareTo(head2);
            }
            return 1;
        }
        if (index2 < 0) {
            return -1;
        }
        return index1 - index2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ColumnOrder)) {
            return false;
        }
        ColumnOrder that = (ColumnOrder)obj;
        if (this.heads.size() != that.heads.size()) {
            return false;
        }
        int i = 0;
        while (i < this.heads.size()) {
            ColumnHead h2;
            ColumnHead h1 = this.heads.get(i);
            if (!h1.equals(h2 = that.heads.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.heads.hashCode();
    }

    public static ColumnOrder createFromTopic(ITopic topic) {
        List columns;
        ITopicExtensionElement content;
        List children;
        ITopicExtension ext = topic.getExtension("org.xmind.ui.spreadsheet");
        if (ext != null && !(children = (content = ext.getContent()).getChildren("columns")).isEmpty() && !(columns = ((ITopicExtensionElement)children.get(0)).getChildren("column")).isEmpty()) {
            ColumnOrder order = new ColumnOrder();
            for (ITopicExtensionElement col : columns) {
                String text = col.getTextContent();
                if (text == null) continue;
                order.addColumnHead(new ColumnHead(text));
            }
            return order;
        }
        return EMPTY;
    }
}

