/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.graphics;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Shell;

public class GraphicsUtils {
    private static Boolean carbon = null;
    private static Boolean carbonSnowLeopard = null;
    private static final GraphicsUtils normal = new GraphicsUtils(false);
    private static final GraphicsUtils advanced = new GraphicsUtils(true);
    private GC gc = null;
    private Font appliedFont = null;
    private FontMetrics metrics = null;
    public static final int CENTER = 0;
    public static final int TRAIL = 1;
    public static final int LEAD = 2;
    public static final int PATH = 3;

    private static boolean isCarbon() {
        if (carbon == null) {
            carbon = Util.isCarbon();
        }
        return carbon;
    }

    public static boolean isCarbonSnowLeopard() {
        if (carbonSnowLeopard == null) {
            String[] parts;
            String osVersion;
            if (GraphicsUtils.isCarbon() && (osVersion = System.getProperty("os.version")) != null && GraphicsUtils.isGreater((parts = osVersion.split("\\."))[0], 10) && parts.length > 1) {
                carbonSnowLeopard = GraphicsUtils.isGreater(parts[1], 6);
            }
            if (carbonSnowLeopard == null) {
                carbonSnowLeopard = Boolean.FALSE;
            }
        }
        return carbonSnowLeopard;
    }

    private static boolean isGreater(String str, int value) {
        try {
            return Integer.parseInt(str) >= value;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static void fixGradientBugForCarbon(Graphics graphics, IFigure figure) {
        GraphicsUtils.fixGradientBugForCarbon(graphics, figure.getBounds());
    }

    public static void fixGradientBugForCarbon(Graphics graphics, Rectangle bounds) {
        if (GraphicsUtils.isCarbon()) {
            graphics.pushState();
            graphics.setAlpha(0);
            graphics.setBackgroundColor(ColorConstants.white);
            graphics.fillRectangle(bounds);
            graphics.restoreState();
            graphics.popState();
        }
    }

    public static GraphicsUtils getNormal() {
        return normal;
    }

    public static GraphicsUtils getAdvanced() {
        return advanced;
    }

    protected GraphicsUtils(boolean advanced) {
        this.getGC().setAdvanced(advanced);
    }

    public GC getGC() {
        if (this.gc == null) {
            this.gc = new GC((Drawable)new Shell());
        }
        return this.gc;
    }

    protected void setFont(Font f) {
        if (this.appliedFont == f || f.equals((Object)this.appliedFont)) {
            return;
        }
        this.getGC().setFont(f);
        this.appliedFont = f;
        this.metrics = null;
    }

    public Font getAppliedFont() {
        return this.appliedFont;
    }

    public Dimension getTextSize(String text, Font font) {
        this.setFont(font);
        return this.getTextSize(text);
    }

    public Dimension getStringSize(String string, Font font) {
        this.setFont(font);
        return this.getStringSize(string);
    }

    public Dimension getTextSize(String text) {
        return new Dimension(this.getGC().textExtent(text));
    }

    public Dimension getStringSize(String string) {
        return new Dimension(this.getGC().stringExtent(string));
    }

    public FontMetrics getFontMetrics(Font f) {
        this.setFont(f);
        if (this.metrics == null) {
            this.metrics = this.getGC().getFontMetrics();
        }
        return this.metrics;
    }

    public String constrain(String path, int maxWidth, Font font, int startPositionHint) {
        Dimension size = this.getTextSize(path, font);
        if (size.width > maxWidth) {
            int start;
            int right;
            int left;
            StringBuffer sb = new StringBuffer(path);
            switch (startPositionHint) {
                case 3: {
                    left = 1;
                    right = sb.lastIndexOf(".") - 2;
                    start = right * 5 / 6;
                    break;
                }
                case 2: {
                    left = 0;
                    right = sb.length() - 2;
                    start = 0;
                    break;
                }
                case 1: {
                    left = 1;
                    right = sb.length() - 1;
                    start = Math.max(right, left);
                    break;
                }
                default: {
                    left = 1;
                    right = sb.length() - 2;
                    start = right / 2;
                }
            }
            sb.replace(start, start + 1, "...");
            size = this.getTextSize(sb.toString());
            boolean down = true;
            while (size.width > maxWidth && start <= right && start > left && right > left) {
                if ((down || right >= 0 && start + 4 > right) && start > left) {
                    --start;
                }
                down = !down;
                sb.replace(start, start + 4, "...");
                if (right >= 0) {
                    --right;
                }
                size = this.getTextSize(sb.toString());
            }
            path = sb.toString();
        }
        return path;
    }
}

