/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.internal.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.xmind.gef.internal.image.IColorReplacingPolicy;
import org.xmind.gef.internal.image.MinRiskColorReplacingPolicy;
import org.xmind.gef.internal.image.SameColorReplacingPolicy;
import org.xmind.neuquant.NeuQuant;

public class ImageConverter {
    private static final int DEPTH_256 = 8;
    private static final int OFFSET = 3;
    private static final int MASK = 248;
    private static final int INIT_COLOR_DIFFERENCE_THRESHOLD = 765;
    private static final PaletteData PALETTE_DATA = new PaletteData(0xFF0000, 65280, 255);

    public static ImageData converTo256Colors(ImageData srcImage) {
        return ImageConverter.convertDepth_4(srcImage, 8);
    }

    protected static ImageData convertDepth(ImageData srcImage, int depth) {
        int numMaxColors = 1 << depth;
        final HashMap<RGB, Integer> colorOccurrences = new HashMap<RGB, Integer>();
        PaletteData srcPalette = srcImage.palette;
        int i = 0;
        while (i < srcImage.width) {
            int j = 0;
            while (j < srcImage.height) {
                RGB rgb = srcPalette.getRGB(srcImage.getPixel(i, j));
                int occur = !colorOccurrences.containsKey(rgb = ImageConverter.getShortenedRGB(rgb)) ? 1 : (Integer)colorOccurrences.get(rgb) + 1;
                colorOccurrences.put(rgb, occur);
                ++j;
            }
            ++i;
        }
        TreeSet<RGB> sortedColors = new TreeSet<RGB>(new Comparator<RGB>(){

            @Override
            public int compare(RGB o1, RGB o2) {
                int x = (Integer)colorOccurrences.get(o2) - (Integer)colorOccurrences.get(o1);
                return x == 0 ? 1 : x;
            }
        });
        sortedColors.addAll(colorOccurrences.keySet());
        List<Object> newPaletteColors = new ArrayList<RGB>(sortedColors);
        if (newPaletteColors.size() > numMaxColors) {
            newPaletteColors = newPaletteColors.subList(0, numMaxColors);
        }
        RGB[] colors = newPaletteColors.toArray(new RGB[newPaletteColors.size()]);
        PaletteData newPalette = new PaletteData(colors);
        HashMap<RGB, Integer> pixelValues = new HashMap<RGB, Integer>();
        int i2 = 0;
        while (i2 < colors.length) {
            pixelValues.put(colors[i2], i2);
            ++i2;
        }
        HashMap<RGB, RGB> oldToNew = new HashMap<RGB, RGB>();
        ImageData result = new ImageData(srcImage.width, srcImage.height, depth, newPalette);
        int i3 = 0;
        while (i3 < srcImage.width) {
            int j = 0;
            while (j < srcImage.height) {
                RGB oldColor = srcPalette.getRGB(srcImage.getPixel(i3, j));
                RGB newColor = (RGB)oldToNew.get(oldColor);
                if (newColor == null) {
                    newColor = ImageConverter.findSimilarColor(oldColor, colors);
                    oldToNew.put(oldColor, newColor);
                }
                result.setPixel(i3, j, ((Integer)pixelValues.get(newColor)).intValue());
                ++j;
            }
            ++i3;
        }
        return result;
    }

    private static RGB getShortenedRGB(RGB rgb) {
        rgb.red &= 0xF8;
        rgb.blue &= 0xF8;
        rgb.green &= 0xF8;
        return rgb;
    }

    private static RGB findSimilarColor(RGB src, RGB[] colors) {
        RGB result = null;
        int droppingThreshold = 765;
        int i = 0;
        while (i < colors.length) {
            RGB toTest = colors[i];
            int diff = ImageConverter.getColorDifference(src, toTest);
            if (diff < droppingThreshold) {
                droppingThreshold = diff;
                result = toTest;
            }
            ++i;
        }
        return result;
    }

    static int getColorDifference(RGB c1, RGB c2) {
        return Math.abs(c1.red - c2.red) + Math.abs(c1.green - c2.green) + Math.abs(c1.blue - c2.blue);
    }

    protected static ImageData convertDepth_2(ImageData srcImage, int depth) {
        int numMaxColors = 1 << depth;
        HashMap<RGB, Integer> colorOccurrences = new HashMap<RGB, Integer>();
        PaletteData srcPalette = srcImage.palette;
        int i = 0;
        while (i < srcImage.width) {
            int j = 0;
            while (j < srcImage.height) {
                RGB rgb = srcPalette.getRGB(srcImage.getPixel(i, j));
                int occur = !colorOccurrences.containsKey(rgb) ? 1 : (Integer)colorOccurrences.get(rgb) + 1;
                colorOccurrences.put(rgb, occur);
                ++j;
            }
            ++i;
        }
        IColorReplacingPolicy policy = colorOccurrences.size() <= numMaxColors ? new SameColorReplacingPolicy() : new MinRiskColorReplacingPolicy();
        PaletteData newPalette = new PaletteData(policy.getReplacingColors(numMaxColors, colorOccurrences));
        HashMap<RGB, Integer> pixelValues = new HashMap<RGB, Integer>();
        RGB[] rgbs = newPalette.getRGBs();
        int i2 = 0;
        while (i2 < rgbs.length) {
            pixelValues.put(rgbs[i2], i2);
            ++i2;
        }
        ImageData result = new ImageData(srcImage.width, srcImage.height, depth, newPalette);
        int i3 = 0;
        while (i3 < srcImage.width) {
            int j = 0;
            while (j < srcImage.height) {
                RGB rgb = srcPalette.getRGB(srcImage.getPixel(i3, j));
                RGB newRGB = policy.getReplacedColor(rgb);
                result.setPixel(i3, j, ((Integer)pixelValues.get(newRGB)).intValue());
                ++j;
            }
            ++i3;
        }
        return result;
    }

    protected static ImageData convertDepth_4(ImageData srcImage, int depth) {
        if (depth != 8) {
            throw new IllegalArgumentException();
        }
        NeuQuant nq = new NeuQuant();
        nq.init(srcImage, 1);
        PaletteData oldPalette = srcImage.palette;
        PaletteData newPalette = new PaletteData(nq.getColourMap());
        int width = srcImage.width;
        int height = srcImage.height;
        ImageData result = new ImageData(width, height, depth, newPalette);
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                RGB rgb = oldPalette.getRGB(srcImage.getPixel(i, j));
                result.setPixel(i, j, nq.lookup(rgb));
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static Image convert(Device device, BufferedImage srcImage) {
        ImageData swtImageData = new ImageData(srcImage.getWidth(), srcImage.getHeight(), 24, PALETTE_DATA);
        int scansize = (srcImage.getWidth() * 3 + 3) * 4 / 4;
        WritableRaster alphaRaster = srcImage.getAlphaRaster();
        byte[] alphaBytes = new byte[srcImage.getWidth()];
        int y = 0;
        while (y < srcImage.getHeight()) {
            int[] buff = srcImage.getRGB(0, y, srcImage.getWidth(), 1, null, 0, scansize);
            swtImageData.setPixels(0, y, srcImage.getWidth(), buff, 0);
            if (alphaRaster != null) {
                int[] alpha = alphaRaster.getPixels(0, y, srcImage.getWidth(), 1, (int[])null);
                int i = 0;
                while (i < srcImage.getWidth()) {
                    alphaBytes[i] = (byte)alpha[i];
                    ++i;
                }
                swtImageData.setAlphas(0, y, srcImage.getWidth(), alphaBytes, 0);
            }
            ++y;
        }
        return new Image(device, swtImageData);
    }

    public static BufferedImage convert(Image srcImage) {
        ImageData imageData = srcImage.getImageData();
        int width = imageData.width;
        int height = imageData.height;
        ImageData maskData = null;
        int[] alpha = new int[1];
        if (imageData.alphaData == null) {
            maskData = imageData.getTransparencyMask();
        }
        BufferedImage image = new BufferedImage(imageData.width, imageData.height, 2);
        WritableRaster alphaRaster = image.getAlphaRaster();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int color = imageData.getPixel(x, y);
                color = ImageConverter.translateColor(imageData, color);
                image.setRGB(x, y, color);
                if (alphaRaster != null) {
                    if (imageData.alphaData != null) {
                        alpha[0] = imageData.getAlpha(x, y);
                        alphaRaster.setPixel(x, y, alpha);
                    } else if (maskData != null) {
                        alpha[0] = maskData.getPixel(x, y) == 0 ? 0 : 255;
                        alphaRaster.setPixel(x, y, alpha);
                    }
                }
                ++x;
            }
            ++y;
        }
        return image;
    }

    private static int translateColor(ImageData imageData, int color) {
        int bitCount = imageData.depth;
        RGB[] rgb = imageData.getRGBs();
        if (bitCount == 1 || bitCount == 4 || bitCount == 8) {
            if (rgb != null) {
                Color foo = new Color(rgb[color].red, rgb[color].green, rgb[color].blue);
                color = foo.getRGB();
            } else {
                color = 0;
            }
        } else if (bitCount == 16) {
            int BLUE_MASK = 31;
            int GREEN_MASK = 992;
            int RED_MASK = 31744;
            color = ImageConverter.applyRGBMask(color, RED_MASK, GREEN_MASK, BLUE_MASK);
        } else if (bitCount == 24) {
            int blue = (color & 0xFF0000) >> 16;
            int green = (color & 0xFF00) >> 8;
            int red = color & 0xFF;
            Color foo = new Color(red, green, blue);
            color = foo.getRGB();
        } else if (bitCount == 32) {
            int blue = (color & 0xFF000000) >>> 24;
            int green = (color & 0xFF0000) >> 16;
            int red = (color & 0xFF00) >> 8;
            Color foo = new Color(red, green, blue);
            color = foo.getRGB();
        }
        return color;
    }

    private static int applyRGBMask(int color, int redMask, int greenMask, int blueMask) {
        int shiftCount = ImageConverter.getShiftCount(redMask);
        int maskSize = ImageConverter.countBits(redMask);
        int red = (color & redMask) >>> shiftCount;
        red = red * 255 / ((int)Math.pow(2.0, maskSize) - 1);
        shiftCount = ImageConverter.getShiftCount(greenMask);
        maskSize = ImageConverter.countBits(greenMask);
        int green = (color & greenMask) >>> shiftCount;
        green = green * 255 / ((int)Math.pow(2.0, maskSize) - 1);
        shiftCount = ImageConverter.getShiftCount(blueMask);
        maskSize = ImageConverter.countBits(blueMask);
        int blue = (color & blueMask) >>> shiftCount;
        blue = blue * 255 / ((int)Math.pow(2.0, maskSize) - 1);
        Color foo = new Color(red, green, blue);
        color = foo.getRGB();
        return color;
    }

    private static int getShiftCount(int mask) {
        int count = 0;
        while (mask != 0 && (mask & 1) == 0) {
            mask >>>= 1;
            ++count;
        }
        return count;
    }

    private static int countBits(int mask) {
        int count = 0;
        int index = 0;
        while (index < 32) {
            if ((mask & 1) != 0) {
                ++count;
            }
            mask >>>= 1;
            ++index;
        }
        return count;
    }
}

