/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.gallery;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.xmind.core.Core;
import org.xmind.core.internal.gallery.DownloadJobPool;
import org.xmind.core.internal.gallery.DownloadedGalleryGroup;
import org.xmind.core.internal.gallery.DownloadedGalleryItem;
import org.xmind.core.internal.gallery.GallerySheet;
import org.xmind.core.internal.gallery.IGalleryChangedListener;
import org.xmind.core.internal.gallery.IGalleryGroup;
import org.xmind.core.internal.gallery.IGalleryItem;
import org.xmind.core.internal.gallery.LocalGalleryGroup;
import org.xmind.core.internal.gallery.LocalGalleryItem;
import org.xmind.core.net.util.LinkUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.gallery.GalleryPlugin;
import org.xmind.ui.io.DownloadJob;
import org.xmind.ui.io.Messages;
import org.xmind.ui.util.ResourceFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GalleryCore {
    private static boolean DEBUG = GalleryPlugin.getDebugOption("/debug/core");
    private static final String CLIPART_XML_RESOURCE = String.valueOf(LinkUtils.getLinkByLanguage((boolean)true, (boolean)false, (String)"/xmind/")) + Platform.getNL().replaceAll("_", "/") + "/clipart.xml";
    public static final String GALLERY_PATH = "gallery";
    private static final String DOWNLOADED_PATH = "gallery/.downloaded";
    private static final String CLIPART_XML_PATH = "gallery/.downloaded/clipart_" + Platform.getNL() + ".xml";
    private static final String CLIPART_XML_TEMP_PATH = "gallery/.downloaded/clipart_" + Platform.getNL() + ".xml.temp";
    private static final String IMAGES_PATH_PREFIX = "gallery/.downloaded/images/";
    private static final int UPDATE_DELAY = DEBUG ? 60000 : 86400000;
    private DownloadJobPool downloadJobPool;
    private ListenerList listeners = new ListenerList();
    private GallerySheet downloadedSheet = null;
    private List<IGalleryGroup> systemGroups = null;
    private Job checkForUpdatesJob = null;
    public static final int INITIALIZING = 1;
    public static final int LOADING = 2;
    public static final int UPDATING = 3;
    public static final int LOADED = 4;
    public static final int FAILED = 5;
    private int status = 1;
    private Object statusLock = new Object();
    private static final GalleryCore INSTANCE = new GalleryCore();

    private GalleryCore() {
        this.downloadJobPool = new DownloadJobPool();
    }

    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeStatus(int newStatus) {
        int oldStatus;
        Object object = this.statusLock;
        synchronized (object) {
            oldStatus = this.status;
            if (oldStatus == newStatus) {
                return;
            }
            this.status = newStatus;
        }
        if (DEBUG) {
            System.out.println("Gallery core status changed: " + oldStatus + " -> " + newStatus + " (1=Initialized,2=Loading,3=Updating,4=Loaded,5=Failed)");
        }
        this.fireGalleryStatusChanged(oldStatus, newStatus);
    }

    private GallerySheet getDownloadedSheet() {
        if (this.downloadedSheet == null) {
            String filePath = GalleryCore.getPath(CLIPART_XML_PATH);
            if (new File(filePath).exists()) {
                if (DEBUG) {
                    System.out.println("Loading clipart.xml from local file: " + filePath);
                }
                this.downloadedSheet = GallerySheet.createFrom(GalleryCore.getPath(CLIPART_XML_PATH));
            } else {
                if (DEBUG) {
                    System.out.println("No clipart.xml on local file. Creating an empty gallery sheet.");
                }
                this.downloadedSheet = GallerySheet.createEmpty();
            }
        }
        return this.downloadedSheet;
    }

    private synchronized List<IGalleryGroup> getDownloadedGalleryGroups() {
        return this.getDownloadedSheet().getGalleryGroups();
    }

    public synchronized List<IGalleryGroup> getUserGalleryGroups() {
        File[] dirs;
        ArrayList<IGalleryGroup> userGroups = new ArrayList<IGalleryGroup>();
        File parentsDir = new File(GalleryCore.getPath(GALLERY_PATH));
        FileUtils.ensureDirectory((File)parentsDir);
        File[] fileArray = dirs = parentsDir.listFiles();
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            if (!".downloaded".equals(dir.getName()) && dir.isDirectory()) {
                userGroups.add(new LocalGalleryGroup(dir, dir.getName()));
            }
            ++n2;
        }
        return userGroups;
    }

    private synchronized List<IGalleryGroup> getSystemGalleryGroups() {
        if (this.systemGroups == null) {
            this.systemGroups = new ArrayList<IGalleryGroup>();
            Properties properties = this.loadSystemGalleryGroupProperties();
            File dir = new File(GalleryCore.getSystemGalleryPath());
            String[] stringArray = dir.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                File subdir = new File(dir, name);
                if (subdir.isDirectory() && !name.startsWith(".")) {
                    this.systemGroups.add(new LocalGalleryGroup(subdir, properties.getProperty(subdir.getName(), subdir.getName())));
                }
                ++n2;
            }
        }
        return this.systemGroups;
    }

    private Properties loadSystemGalleryGroupProperties() {
        Properties properties = new Properties();
        URL propertiesURL = ResourceFinder.findResource((String)"org.xmind.ui.gallery", (String)"images/", (String)"imageGroups", (String)".properties");
        if (propertiesURL != null) {
            try {
                InputStream stream = propertiesURL.openStream();
                try {
                    properties.load(stream);
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException e) {
                GalleryPlugin.log(e, "Failed to load locale-specific properties file from: images/imageGroup.properties");
            }
        }
        return properties;
    }

    private static String getSystemGalleryPath() {
        try {
            File resourcesDir = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)"org.xmind.ui.gallery.resources"));
            if (DEBUG) {
                System.out.println("Gallery images bundle path: " + resourcesDir.getPath());
            }
            String path = new File(resourcesDir, "images").getAbsolutePath();
            if (DEBUG) {
                System.out.println("Gallery images folder path: " + path);
            }
            return path;
        }
        catch (IOException iOException) {
            return "non-existing-folder";
        }
    }

    public List<IGalleryGroup> getGalleryGroups() {
        ArrayList<IGalleryGroup> list = new ArrayList<IGalleryGroup>();
        list.addAll(this.getSystemGalleryGroups());
        list.addAll(this.getDownloadedGalleryGroups());
        File[] listFiles = new File(GalleryCore.getPath(GALLERY_PATH)).listFiles();
        boolean userGroupToAdd = false;
        if (listFiles != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (GalleryCore.isImageFile(file.getName())) {
                    userGroupToAdd = true;
                }
                ++n2;
            }
        }
        if (userGroupToAdd) {
            list.addAll(this.getUserGalleryGroups());
        }
        return list;
    }

    public IGalleryItem[] addImagesToUserGroup(String[] paths, IGalleryGroup galleryGroup) {
        if (!(galleryGroup instanceof LocalGalleryGroup)) {
            return null;
        }
        File dir = ((LocalGalleryGroup)galleryGroup).getFile();
        FileUtils.ensureDirectory((File)dir);
        ArrayList<LocalGalleryItem> newItems = new ArrayList<LocalGalleryItem>(paths.length);
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            block26: {
                String path = stringArray[n2];
                if (GalleryCore.isImageFile(path)) {
                    File newFile = this.createNonexistingFile(dir, path);
                    FileInputStream is = null;
                    OutputStream os = null;
                    try {
                        try {
                            is = new FileInputStream(path);
                            os = new FileOutputStream(newFile);
                            FileUtils.transfer((InputStream)is, (OutputStream)os, (boolean)true);
                            newItems.add(new LocalGalleryItem(galleryGroup, newFile));
                            VerifyUI20141031.getUsageDataCollector().increase("AddClipArtsToGroupCount");
                        }
                        catch (IOException iOException) {
                            if (is != null) {
                                try {
                                    ((InputStream)is).close();
                                }
                                catch (IOException iOException2) {}
                            }
                            if (os != null) {
                                try {
                                    os.close();
                                }
                                catch (IOException iOException3) {}
                            }
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            ++n2;
        }
        return newItems.toArray(new IGalleryItem[newItems.size()]);
    }

    private File createNonexistingFile(File dir, String source) {
        String ext = FileUtils.getExtension((String)source);
        int index = 1;
        String name = "Image-" + index + ext;
        File file = new File(dir, name);
        while (file.exists()) {
            name = "Image-" + ++index + ext;
            file = new File(dir, name);
        }
        return file;
    }

    public void removeImageFromUserGallery(IGalleryItem item) {
        if (item instanceof LocalGalleryItem) {
            File file = ((LocalGalleryItem)item).getFile();
            boolean oldExists = file.exists();
            file.delete();
            boolean newExists = file.exists();
            if (oldExists && !newExists) {
                this.fireGalleryChanged();
            }
        }
    }

    public void load() {
        boolean allowRequest;
        boolean bl = allowRequest = !Boolean.getBoolean("org.xmind.ui.gallery.notRequestClipArt");
        if (!allowRequest) {
            return;
        }
        if (this.checkForUpdatesJob != null) {
            if (DEBUG) {
                System.out.println("An attempt to load clip art is ignored: Clip art loading is scheduled.");
            }
            return;
        }
        this.doLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoad() {
        boolean downloadRequired;
        Object object = this.statusLock;
        synchronized (object) {
            if (this.status == 2 || this.status == 3) {
                return;
            }
            boolean bl = downloadRequired = !new File(GalleryCore.getPath(CLIPART_XML_PATH)).exists();
            if (downloadRequired) {
                this.changeStatus(2);
            } else {
                this.changeStatus(3);
            }
        }
        FileUtils.ensureDirectory((File)new File(GalleryCore.getPath(DOWNLOADED_PATH)));
        String buildId = System.getProperty("org.xmind.product.buildid");
        String distributionId = System.getProperty("org.xmind.product.distribution.id");
        StringBuffer sourceURL = new StringBuffer(CLIPART_XML_RESOURCE);
        if (buildId != null) {
            sourceURL.append("?buildId=").append(buildId);
        }
        if (distributionId != null) {
            sourceURL.append(buildId == null ? "?" : "&").append("distributionId=").append(distributionId);
        }
        final XMLDownloadJob loadXMLJob = new XMLDownloadJob(downloadRequired ? "Download Clip Art" : "Update Clip Art", sourceURL.toString(), GalleryCore.getPath(CLIPART_XML_TEMP_PATH));
        loadXMLJob.setSystem(!DEBUG);
        this.downloadJobPool.scheduleDownloadJob(loadXMLJob, new Runnable(){

            public void run() {
                GalleryCore.this.postLoad(loadXMLJob, downloadRequired);
            }
        });
    }

    private void postLoad(XMLDownloadJob job, boolean needsDownload) {
        IStatus result = job.getResult();
        String tempFilePath = job.getTargetPath();
        if (!result.isOK() && needsDownload) {
            this.changeStatus(5);
            return;
        }
        boolean changed = false;
        GallerySheet oldSheet = this.getDownloadedSheet();
        File tempFile = new File(tempFilePath);
        if (tempFile.isFile()) {
            try {
                GallerySheet newSheet = GallerySheet.createFrom(tempFilePath);
                changed = this.updateDownloadedSheet(oldSheet, newSheet);
                oldSheet.setTimestamp(job.getNewTimestamp());
            }
            finally {
                tempFile.delete();
            }
        }
        ArrayList<ImageDownloadJob> imageDownloadJobs = new ArrayList<ImageDownloadJob>();
        this.checkForImages(imageDownloadJobs);
        String filePath = GalleryCore.getPath(CLIPART_XML_PATH);
        FileUtils.ensureDirectory((File)new File(filePath).getParentFile());
        try {
            oldSheet.save(filePath);
        }
        catch (IOException e) {
            GalleryPlugin.log(e, "Failed to save downloaded clip art meta file to: " + filePath);
        }
        this.changeStatus(4);
        if (changed) {
            this.fireGalleryChanged();
        }
        if (!imageDownloadJobs.isEmpty()) {
            Runnable onImageDownloadFinish = new Runnable(){

                public void run() {
                    GalleryCore.this.fireGalleryChanged();
                }
            };
            for (ImageDownloadJob imageDownloadJob : imageDownloadJobs) {
                this.downloadJobPool.scheduleDownloadJob(imageDownloadJob, onImageDownloadFinish);
            }
        }
        if (this.checkForUpdatesJob == null) {
            this.checkForUpdatesJob = new CheckForUpdatesJob();
        }
        this.checkForUpdatesJob.schedule((long)UPDATE_DELAY);
        if (DEBUG) {
            Date scheduledTime = new Date();
            scheduledTime.setTime(System.currentTimeMillis() + (long)UPDATE_DELAY);
            System.out.println("Next clip art loading is scheduled at " + scheduledTime);
        }
    }

    private boolean updateDownloadedSheet(GallerySheet oldSheet, GallerySheet newSheet) {
        boolean changed = false;
        List<IGalleryGroup> oldGroups = oldSheet.getGalleryGroups();
        List<IGalleryGroup> newGroups = newSheet.getGalleryGroups();
        if (DEBUG) {
            System.out.println("Updating gallery sheet: old groups = " + oldGroups.size() + ", new groups = " + newGroups.size());
        }
        HashMap<String, DownloadedGalleryGroup> oldGroupMap = new HashMap<String, DownloadedGalleryGroup>(oldGroups.size());
        for (IGalleryGroup oldGroup : oldGroups) {
            oldGroupMap.put(((DownloadedGalleryGroup)oldGroup).getSymbolicName(), (DownloadedGalleryGroup)oldGroup);
        }
        DownloadedGalleryGroup lastOldGroup = null;
        for (IGalleryGroup theNewGroup : newGroups) {
            DownloadedGalleryGroup newGroup = (DownloadedGalleryGroup)theNewGroup;
            String symbolicName = newGroup.getSymbolicName();
            DownloadedGalleryGroup oldGroup = (DownloadedGalleryGroup)oldGroupMap.remove(symbolicName);
            if (oldGroup == null) {
                oldGroup = (DownloadedGalleryGroup)oldSheet.importGroup(newGroup);
                changed = true;
                if (DEBUG) {
                    System.out.println("Imported new gallery group '" + symbolicName + "'.");
                }
            } else {
                changed |= this.updateDownloadedGroup(oldGroup, newGroup);
            }
            changed |= oldSheet.moveGroupAfter(oldGroup, lastOldGroup);
            lastOldGroup = oldGroup;
        }
        if (!oldGroupMap.isEmpty()) {
            for (DownloadedGalleryGroup oldGroup : oldGroupMap.values()) {
                oldSheet.removeGroup(oldGroup);
                if (!DEBUG) continue;
                System.out.println("Removed old gallery group '" + oldGroup.getSymbolicName() + "'.");
            }
            changed = true;
        }
        if (DEBUG) {
            if (changed) {
                System.out.println("Gallery sheet is updated and changed.");
            } else {
                System.out.println("Gallery sheet has nothing changed during update.");
            }
        }
        return changed;
    }

    private boolean updateDownloadedGroup(DownloadedGalleryGroup oldGroup, DownloadedGalleryGroup newGroup) {
        boolean changed = false;
        List<IGalleryItem> oldItems = oldGroup.getItems();
        List<IGalleryItem> newItems = newGroup.getItems();
        if (DEBUG) {
            System.out.println("Updating gallery group '" + oldGroup.getSymbolicName() + "': old items = " + oldItems.size() + ", new items = " + newItems.size());
        }
        HashMap<String, IGalleryItem> oldItemMap = new HashMap<String, IGalleryItem>();
        for (IGalleryItem oldItem : oldItems) {
            oldItemMap.put(((DownloadedGalleryItem)oldItem).getSourceURL(), oldItem);
        }
        DownloadedGalleryItem lastOldItem = null;
        for (IGalleryItem newItem : newItems) {
            DownloadedGalleryItem newDownloadedItem = (DownloadedGalleryItem)newItem;
            String url = newDownloadedItem.getSourceURL();
            DownloadedGalleryItem oldDownloadedItem = (DownloadedGalleryItem)oldItemMap.remove(url);
            if (oldDownloadedItem == null) {
                oldDownloadedItem = oldGroup.getOwnedSheet().importItem(newItem);
                changed = true;
                if (DEBUG) {
                    System.out.println("Imported new gallery item: " + oldDownloadedItem.getSourceURL());
                }
            } else if (DEBUG) {
                System.out.println("Unchanged gallery item: " + oldDownloadedItem.getSourceURL());
            }
            changed |= oldGroup.moveItemAfter(oldDownloadedItem, lastOldItem);
            lastOldItem = oldDownloadedItem;
        }
        if (!oldItemMap.isEmpty()) {
            for (IGalleryItem oldItem : oldItemMap.values()) {
                oldGroup.removeItem(oldItem);
                if (!DEBUG) continue;
                System.out.println("Removed old gallery item: " + ((DownloadedGalleryItem)oldItem).getSourceURL());
            }
            changed = true;
        }
        return changed;
    }

    private void checkForImages(List<ImageDownloadJob> imageDownloadJobs) {
        for (IGalleryGroup group : this.getDownloadedGalleryGroups()) {
            for (IGalleryItem item : group.getItems()) {
                if (!(item instanceof DownloadedGalleryItem)) continue;
                DownloadedGalleryItem downloadedItem = (DownloadedGalleryItem)item;
                String path = downloadedItem.getPath();
                if (path == null || "".equals(path)) {
                    String url = downloadedItem.getSourceURL();
                    int index = url.lastIndexOf(47);
                    String name = url.substring(index + 1);
                    path = GalleryCore.getPath(IMAGES_PATH_PREFIX + downloadedItem.getParent().getSymbolicName() + '/' + name);
                    downloadedItem.setPath(path);
                    if (DEBUG) {
                        System.out.println("Generated download path for gallery item: " + url + " -> " + path);
                    }
                }
                if (new File(path).exists()) continue;
                ImageDownloadJob imageDownloadJob = new ImageDownloadJob("Download Clip Art Image", downloadedItem.getSourceURL(), path);
                ImageDownloadJob image2xDownloadJob = new ImageDownloadJob("Download Clip Art 2x Image", this.get2xPath(downloadedItem.getSourceURL()), this.get2xPath(path));
                imageDownloadJob.setSystem(!DEBUG);
                imageDownloadJobs.add(imageDownloadJob);
                imageDownloadJobs.add(image2xDownloadJob);
            }
        }
    }

    private String get2xPath(String path) {
        int dot = path.lastIndexOf(46);
        if (dot > -1) {
            String xpath;
            String lead = path.substring(0, dot);
            String tail = path.substring(dot);
            path = xpath = String.valueOf(lead) + "@2x" + tail;
        }
        return path;
    }

    public void unload() {
        if (this.checkForUpdatesJob != null) {
            this.checkForUpdatesJob.cancel();
            this.checkForUpdatesJob = null;
        }
    }

    private void fireGalleryStatusChanged(int oldStatus, int newStatus) {
        Object[] theListeners = this.listeners.getListeners();
        int i = 0;
        while (i < theListeners.length) {
            IGalleryChangedListener listener = (IGalleryChangedListener)theListeners[i];
            listener.galleryStatusChanged(oldStatus, newStatus);
            ++i;
        }
    }

    public void fireGalleryChanged() {
        Object[] theListeners = this.listeners.getListeners();
        int i = 0;
        while (i < theListeners.length) {
            IGalleryChangedListener listener = (IGalleryChangedListener)theListeners[i];
            listener.galleryGroupChanged();
            ++i;
        }
    }

    public void addGalleryChangedlistener(IGalleryChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeGalleryChangedListener(IGalleryChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public static boolean isImageFile(String name) {
        return name.endsWith(".png") || name.endsWith(".bmp") || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".gif");
    }

    public static String getPath(String subPath) {
        return Core.getWorkspace().getAbsolutePath(subPath);
    }

    public static final GalleryCore getInstance() {
        return INSTANCE;
    }

    public void renameUserGroup(IGalleryGroup group, String newName) {
        if (group instanceof LocalGalleryGroup) {
            if (!this.getUserGalleryGroups().contains(group)) {
                return;
            }
            File oldFile = ((LocalGalleryGroup)group).getFile();
            File newFile = new File(String.valueOf(oldFile.getParent()) + File.separator + newName);
            oldFile.renameTo(newFile);
        }
    }

    public void deleteUserGroup(IGalleryGroup group) {
        if (group instanceof LocalGalleryGroup) {
            if (!this.getUserGalleryGroups().contains(group)) {
                return;
            }
            File dir = ((LocalGalleryGroup)group).getFile();
            if (dir != null && dir.isDirectory()) {
                FileUtils.delete((File)dir);
                GalleryCore.getInstance().fireGalleryChanged();
            }
        }
    }

    private class CheckForUpdatesJob
    extends Job {
        public CheckForUpdatesJob() {
            super("Check For Clip Art Updates");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            GalleryCore.this.doLoad();
            return Status.OK_STATUS;
        }
    }

    private class ImageDownloadJob
    extends DownloadJob {
        public ImageDownloadJob(String jobName, String sourceURL, String targetPath) {
            super(jobName, sourceURL, targetPath);
        }

        protected IStatus errorStatus(Throwable e) {
            return new Status(2, "org.xmind.ui.gallery", NLS.bind((String)Messages.DownloadFailed, (Object)this.getSourceURL(), (Object)this.getTargetPath()), e);
        }
    }

    private class XMLDownloadJob
    extends DownloadJob {
        private long newTimestamp;

        public XMLDownloadJob(String jobName, String sourceURL, String targetPath) {
            super(jobName, sourceURL, targetPath);
            this.newTimestamp = 0L;
        }

        public long getNewTimestamp() {
            return this.newTimestamp;
        }

        protected void setupConnection(URLConnection connection) {
            long timestamp = GalleryCore.this.getDownloadedSheet().getTimestamp();
            if (timestamp > 0L) {
                connection.setIfModifiedSince(timestamp);
                if (DEBUG) {
                    System.out.println("Fetching clipart.xml: set 'if-modified-since' to " + timestamp);
                }
            }
        }

        protected IStatus validateConnection(URLConnection connection) {
            if (connection instanceof HttpURLConnection) {
                int respCode;
                block8: {
                    respCode = ((HttpURLConnection)connection).getResponseCode();
                    if (DEBUG) {
                        System.out.println("Fetching clipart.xml: Response code = " + respCode);
                    }
                    if (respCode < 200 || respCode >= 300) break block8;
                    this.newTimestamp = connection.getDate();
                    if (DEBUG) {
                        System.out.println("Fetching clipart.xml: New timestamp: " + this.newTimestamp);
                    }
                    return null;
                }
                try {
                    if (respCode >= 300 && respCode < 400) {
                        if (DEBUG) {
                            System.out.println("Fetching clipart.xml: Not modified.");
                        }
                        return Status.OK_STATUS;
                    }
                    return new Status(2, "org.xmind.ui.gallery", "Failed to download Clip Art meta file: " + respCode);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        protected IStatus errorStatus(Throwable e) {
            return new Status(2, "org.xmind.ui.gallery", NLS.bind((String)Messages.DownloadFailed, (Object)this.getSourceURL(), (Object)this.getTargetPath()), e);
        }
    }
}

