/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.audio.internal.device;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.Properties;
import javax.sound.sampled.TargetDataLine;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xmind.core.audio.FileAudioTarget;
import org.xmind.core.audio.IAudioSource;
import org.xmind.core.audio.IAudioTarget;
import org.xmind.core.audio.internal.CoreAudioPlugin;
import org.xmind.core.audio.internal.device.LameMP3Channel;
import org.xmind.core.audio.internal.device.RawDataChannel;
import org.xmind.core.audio.internal.device.RawDataRecorder;

public class LameMP3Recorder
extends RawDataRecorder {
    private static final String KEY_EXECUTABLE_PATH = "lame.executablePath";
    private static final String EXT_RAW = ".tmp";
    private static final String EXT_MP3 = ".mp3";
    private static Properties lameProperties = null;

    public boolean isAvailable() {
        return super.isAvailable() && LameMP3Recorder.isLameAvailable();
    }

    protected RawDataChannel createChannel(IAudioSource source, IAudioTarget target, OutputStream output, TargetDataLine line) throws IOException {
        File tempRawFile = this.createTempRawFile(target);
        File parent = tempRawFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        File tempMp3File = this.createNonExistingFile(parent.getAbsolutePath(), EXT_MP3);
        FileOutputStream tempOutput = new FileOutputStream(tempRawFile);
        return new LameMP3Channel(this, source, target, line, output, tempRawFile, tempMp3File, new BufferedOutputStream(tempOutput), LameMP3Recorder.getLameExecutablePath());
    }

    private File createTempRawFile(IAudioTarget target) {
        try {
            return File.createTempFile("record", ".raw");
        }
        catch (IOException iOException) {
            File parentFile;
            File targetFile;
            if (target instanceof FileAudioTarget && (targetFile = ((FileAudioTarget)target).getTargetFile()) != null && (parentFile = targetFile.getParentFile()) != null) {
                return this.createNonExistingFile(parentFile.getAbsolutePath(), EXT_RAW);
            }
            String userDir = System.getProperty("user.home");
            if (userDir != null) {
                return this.createNonExistingFile(new File(userDir, ".xmind").getAbsolutePath(), ".raw");
            }
            return this.createNonExistingFile(".", EXT_RAW);
        }
    }

    private synchronized File createNonExistingFile(String dir, String suffix) {
        String prefix = String.format("record_%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", Calendar.getInstance());
        File f = new File(dir, String.valueOf(prefix) + suffix);
        int i = 0;
        while (f.exists()) {
            f = new File(dir, String.valueOf(prefix) + "_" + ++i + suffix);
        }
        f.getParentFile().mkdirs();
        try {
            new FileOutputStream(f).close();
        }
        catch (IOException iOException) {}
        return f;
    }

    private static String getLameExecutablePath() {
        return LameMP3Recorder.getLameProperty(KEY_EXECUTABLE_PATH);
    }

    private static boolean isLameAvailable() {
        return LameMP3Recorder.getLameExecutablePath() != null;
    }

    private static String getLameProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            value = LameMP3Recorder.getLameProperties().getProperty(key);
        }
        return value;
    }

    private static Properties getLameProperties() {
        if (lameProperties == null) {
            lameProperties = new Properties();
            LameMP3Recorder.initLameProperties();
        }
        return lameProperties;
    }

    private static void initLameProperties() {
        Bundle bundle = LameMP3Recorder.loadLamePropertiesExtension();
        LameMP3Recorder.initExecutablePath(bundle);
    }

    private static void initExecutablePath(Bundle bundle) {
        String path = lameProperties.getProperty("lame.executablePath." + System.getProperty("os.arch"));
        if (path == null) {
            path = lameProperties.getProperty(KEY_EXECUTABLE_PATH);
        }
        if (path != null) {
            if ((path = LameMP3Recorder.fillParams(path)).startsWith("/")) {
                path = new File(path).getAbsolutePath();
            } else if (bundle != null) {
                path = LameMP3Recorder.getFile(bundle, path);
            }
        }
        if (path == null || !new File(path).exists()) {
            path = "lame";
        }
        lameProperties.setProperty(KEY_EXECUTABLE_PATH, path);
    }

    private static String fillParams(String path) {
        int index = path.indexOf("${");
        if (index >= 0) {
            StringBuilder sb = new StringBuilder(path.length());
            int closeIndex = 0;
            while (index >= 0) {
                sb.append(path.substring(closeIndex, index));
                closeIndex = path.indexOf("}", index);
                if (closeIndex >= 0) {
                    sb.append(System.getProperty(path.substring(index + 2, closeIndex)));
                    index = path.indexOf("${", ++closeIndex);
                    continue;
                }
                sb.append(path.substring(index));
                break;
            }
            if (closeIndex >= 0) {
                sb.append(path.substring(closeIndex));
            }
            path = sb.toString();
        }
        return path;
    }

    private static Bundle loadLamePropertiesExtension() {
        Bundle[] fragments = Platform.getFragments((Bundle)CoreAudioPlugin.getDefault().getBundle());
        if (fragments != null) {
            Bundle[] bundleArray = fragments;
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle fragment = bundleArray[n2];
                URL propUrl = fragment.getEntry("lame.properties");
                if (propUrl != null) {
                    Bundle bundle;
                    InputStream in = propUrl.openStream();
                    try {
                        lameProperties.load(in);
                        bundle = fragment;
                    }
                    catch (Throwable throwable) {
                        try {
                            in.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {}
                    }
                    in.close();
                    return bundle;
                }
                ++n2;
            }
        }
        return null;
    }

    private static String getFile(Bundle bundle, String path) {
        URL entry = bundle.getEntry(path);
        if (entry != null) {
            try {
                URL url = FileLocator.toFileURL((URL)entry);
                File file = new File(url.getFile());
                if (file.exists()) {
                    return file.getCanonicalPath();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }
}

