/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.runtime;

import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xmind.core.io.BundleResource;

public class BundleResourceFinder {
    public static BundleResource resolve(BundleResource res) {
        BundleResource result;
        String first;
        IPath path = res.getPath();
        if (path.isEmpty() || path.isRoot()) {
            path = Path.EMPTY;
        }
        if ((first = path.segment(0)) == null || !first.startsWith("$")) {
            result = BundleResourceFinder.find(res.getBundle(), path);
        } else {
            path = path.removeFirstSegments(1);
            result = "$nl$".equalsIgnoreCase(first) ? BundleResourceFinder.resolveByNL(res.getBundle(), path) : ("$os$".equalsIgnoreCase(first) ? BundleResourceFinder.resolveByOS(res.getBundle(), path) : ("$ws$".equalsIgnoreCase(first) ? BundleResourceFinder.resolveByWS(res.getBundle(), path) : BundleResourceFinder.find(res.getBundle(), path)));
        }
        return result;
    }

    private static BundleResource find(Bundle bundle, IPath path) {
        URL entry = bundle.getEntry(path.toString());
        if (entry != null) {
            return new BundleResource(bundle, (IPath)new Path(entry.getPath()));
        }
        Bundle[] fragments = Platform.getFragments((Bundle)bundle);
        if (fragments == null) {
            return null;
        }
        int i = 0;
        while (i < fragments.length) {
            BundleResource result = BundleResourceFinder.find(fragments[i], path);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private static BundleResource resolveByNL(Bundle bundle, IPath path) {
        String nl = Platform.getNL();
        String[] nlParts = nl.split("_");
        int i = 0;
        while (i < nlParts.length) {
            int count = nlParts.length - i;
            IPath p = Path.ROOT.append("nl");
            int j = 0;
            while (j < count) {
                p = p.append(nlParts[j]);
                ++j;
            }
            BundleResource result = BundleResourceFinder.find(bundle, p = p.append(path));
            if (result != null) {
                return result;
            }
            ++i;
        }
        return BundleResourceFinder.find(bundle, path);
    }

    private static BundleResource resolveByOS(Bundle bundle, IPath path) {
        return null;
    }

    private static BundleResource resolveByWS(Bundle bundle, IPath path) {
        return null;
    }
}

