/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import org.xmind.core.IComment;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.plain.Workbook;

public class Comment
implements IComment,
ICoreEventSource {
    private final Workbook ownerWorkbook;
    private final String author;
    private final long creationTime;
    private final String objectId;
    private String content;
    private boolean orphan;

    public Comment(Workbook ownerWorkbook, String author, long creationTime, String objectId) {
        this.ownerWorkbook = ownerWorkbook;
        this.author = author;
        this.creationTime = creationTime;
        this.objectId = objectId;
        this.content = null;
        this.orphan = true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        if (ICoreEventSupport.class.equals(adapter)) {
            return adapter.cast(this.getCoreEventSupport());
        }
        return null;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerWorkbook;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public int compareTo(IComment that) {
        return (int)(that.getTime() - this.getTime());
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.ownerWorkbook.getCoreEventSupport();
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getAuthor() {
        return this.author;
    }

    public long getTime() {
        return this.creationTime;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        String oldContent = this.content;
        if (content == oldContent || content != null && content.equals(oldContent)) {
            return;
        }
        this.content = content;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "commentContent", (Object)oldContent, (Object)content);
    }

    protected void onParented() {
        this.orphan = false;
    }

    protected void onOrphan() {
        this.orphan = true;
    }
}

