/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.seawind.internal.core;

import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xmind.core.io.IStorage;
import org.xmind.seawind.internal.core.SElement;
import org.xmind.seawind.internal.core.SSerializable;
import org.xmind.seawind.internal.core.STitled;
import org.xmind.seawind.internal.core.SeawindSheet;
import org.xmind.seawind.internal.core.SeawindWorkingSet;

public class SeawindWorkbook
implements SElement<SeawindWorkingSet>,
STitled,
SSerializable {
    public static final String PREFIX_HASH = "__HASH__";
    private static final int TITLE_LENGTH = 50;
    private final PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private final String id;
    private String title;
    private List<SeawindSheet> sheets;
    private long creationTime;
    private long modificationTime;
    private SeawindWorkingSet parent = null;
    private IStorage storage = null;
    private String extensionsRev;
    private String extensionsHash;
    private String updateBy = "";

    public SeawindWorkbook(String id) {
        this(new JSONObject().put("id", (Object)id));
    }

    public SeawindWorkbook(JSONObject json) {
        this.id = json.getString("id");
        this.title = json.optString("title", null);
        this.sheets = new ArrayList<SeawindSheet>();
        this.creationTime = json.has("creationTime") ? json.getLong("creationTime") : System.currentTimeMillis();
        this.modificationTime = json.has("modificationTime") ? json.getLong("modificationTime") : 0L;
        this.updateBy = json.has("updateBy") ? json.getString("updateBy") : "";
        this.loadSheets(json.optJSONArray("sheets"), json.optJSONArray("sheetOrder"));
        this.loadExtensionsRev(json.optJSONObject("extensions"));
        this.loadExtensionsHash(json.optJSONObject("extensions"));
    }

    private void loadSheets(JSONArray sheetArray, JSONArray sheetOrderArray) {
        if (sheetArray == null) {
            return;
        }
        sheetArray = new JSONArray(sheetArray.toString());
        if (sheetOrderArray != null) {
            for (Object o : sheetOrderArray) {
                String id;
                JSONObject sheetObject;
                if (!(o instanceof String) || (sheetObject = SeawindWorkbook.optSheetObject(sheetArray, id = (String)o)) == null) continue;
                SeawindSheet sheet = new SeawindSheet(sheetObject);
                sheet.setParent(this);
                this.sheets.add(sheet);
            }
        }
        for (Object o : sheetArray) {
            if (!(o instanceof JSONObject)) continue;
            JSONObject sheetObject = (JSONObject)o;
            SeawindSheet sheet = new SeawindSheet(sheetObject);
            sheet.setParent(this);
            this.sheets.add(sheet);
        }
    }

    private void loadExtensionsRev(JSONObject extensionsObject) {
        if (extensionsObject == null) {
            return;
        }
        this.extensionsRev = extensionsObject.getString("rev");
    }

    private void loadExtensionsHash(JSONObject extensionsObject) {
        if (extensionsObject == null) {
            return;
        }
        this.extensionsHash = extensionsObject.optString("hash", null);
    }

    private Properties captureProperties() {
        Properties properties = new Properties();
        if (this.title != null) {
            properties.put("title", this.title);
        }
        properties.put("sheets", new ArrayList<SeawindSheet>(this.sheets));
        if (this.extensionsRev != null) {
            properties.put("extensionsRev", this.extensionsRev);
        }
        properties.put("modificationTime", (Object)this.modificationTime);
        return properties;
    }

    private void notifyPropertyChanges(Properties oldProperties, boolean updateModificationTime) {
        Properties newProperties = this.captureProperties();
        if (updateModificationTime && !newProperties.equals(oldProperties)) {
            this.modificationTime = System.currentTimeMillis();
            newProperties.put("modificationTime", (Object)this.modificationTime);
        }
        for (String propertyName : Arrays.asList("title", "sheets", "modificationTime")) {
            this.propertySupport.firePropertyChange(propertyName, oldProperties.get(propertyName), newProperties.get(propertyName));
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject object = new JSONObject().put("id", (Object)this.id);
        if (this.title != null) {
            object.put("title", (Object)this.title);
        }
        JSONArray sheetArray = new JSONArray();
        JSONArray sheetOrderArray = new JSONArray();
        for (SeawindSheet sheet : this.sheets) {
            sheetArray.put((Object)sheet.toJSON());
            sheetOrderArray.put((Object)sheet.getId());
        }
        object.put("sheets", (Object)sheetArray);
        object.put("sheetOrder", (Object)sheetOrderArray);
        object.put("creationTime", this.creationTime);
        object.put("modificationTime", this.modificationTime);
        if (this.updateBy != null && !this.updateBy.equals("")) {
            object.put("updateBy", (Object)this.updateBy);
        }
        if (this.extensionsRev != null) {
            JSONObject extensionsObject = new JSONObject();
            extensionsObject.put("rev", (Object)this.extensionsRev);
            object.put("extensions", (Object)extensionsObject);
        }
        return object;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getModificationTime() {
        return this.modificationTime;
    }

    @Override
    public void setModificationTime(long modificationTime) {
        Properties oldProperties = this.captureProperties();
        this.modificationTime = modificationTime;
        this.notifyPropertyChanges(oldProperties, false);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        Properties oldProperties = this.captureProperties();
        if (title != null && title.length() > 50) {
            title = title.substring(0, 50);
        }
        this.title = title;
        this.notifyPropertyChanges(oldProperties, false);
    }

    public List<SeawindSheet> getSheets() {
        return Collections.unmodifiableList(this.sheets);
    }

    public void addSheet(SeawindSheet sheet) {
        Properties oldProperties = this.captureProperties();
        this.sheets.add(sheet);
        sheet.setParent(this);
        this.notifyPropertyChanges(oldProperties, true);
    }

    public void removeSheet(SeawindSheet sheet) {
        Properties oldProperties = this.captureProperties();
        this.sheets.remove(sheet);
        this.notifyPropertyChanges(oldProperties, true);
        sheet.setParent(null);
    }

    public void moveSheet(SeawindSheet sheet, int newIndex) {
        Properties oldProperties = this.captureProperties();
        this.sheets.remove(sheet);
        if (newIndex < 0) {
            this.sheets.add(sheet);
        } else {
            this.sheets.add(newIndex, sheet);
        }
        sheet.setParent(this);
        this.notifyPropertyChanges(oldProperties, true);
    }

    public List<String> getSheetOrder() {
        ArrayList<String> sheetIds = new ArrayList<String>(this.sheets.size());
        for (SeawindSheet sheet : this.sheets) {
            sheetIds.add(sheet.getId());
        }
        return sheetIds;
    }

    public void reorderSheets(List<String> sheetIds) {
        Properties oldProperties = this.captureProperties();
        int sheetIndex = 0;
        ArrayList<SeawindSheet> cachedSheets = new ArrayList<SeawindSheet>(this.sheets);
        while (sheetIndex < sheetIds.size()) {
            String sheetId = sheetIds.get(sheetIndex);
            if (sheetId != null) {
                SeawindSheet sheet = null;
                for (SeawindSheet s : cachedSheets) {
                    if (!sheetId.equals(s.getId())) continue;
                    sheet = s;
                    break;
                }
                if (sheet != null) {
                    this.sheets.remove(sheet);
                    if (sheetIndex > this.sheets.size()) {
                        this.sheets.add(sheet);
                    } else {
                        this.sheets.add(sheetIndex, sheet);
                    }
                }
            }
            ++sheetIndex;
        }
        this.notifyPropertyChanges(oldProperties, true);
    }

    @Override
    public SeawindWorkingSet getParent() {
        return this.parent;
    }

    public void setParent(SeawindWorkingSet parent) {
        this.parent = parent;
    }

    public PropertyChangeSupport getPropertySupport() {
        return this.propertySupport;
    }

    public SeawindSheet findSheet(String id) {
        int index = this.findSheetIndex(id);
        if (index < 0) {
            return null;
        }
        return this.sheets.get(index);
    }

    private int findSheetIndex(String id) {
        if (id == null) {
            return -1;
        }
        ListIterator<SeawindSheet> it = this.sheets.listIterator();
        while (it.hasNext()) {
            int index = it.nextIndex();
            SeawindSheet sheet = it.next();
            if (!id.equals(sheet.getId())) continue;
            return index;
        }
        return -1;
    }

    public boolean isSameWith(SeawindWorkbook that) {
        if (!(this.id == that.id || this.id != null && this.id.equals(that.id))) {
            return false;
        }
        if (!(this.title == that.title || this.title != null && this.title.equals(that.title))) {
            return false;
        }
        if (!(this.extensionsRev == that.extensionsRev || this.extensionsRev != null && this.extensionsRev.equals(that.extensionsRev))) {
            return false;
        }
        Iterator<SeawindSheet> thisSheetIt = this.sheets.iterator();
        Iterator<SeawindSheet> thatSheetIt = that.sheets.iterator();
        while (thisSheetIt.hasNext() && thatSheetIt.hasNext()) {
            SeawindSheet thatSheet;
            SeawindSheet thisSheet = thisSheetIt.next();
            if (thisSheet.isSameWith(thatSheet = thatSheetIt.next())) continue;
            return false;
        }
        return !thisSheetIt.hasNext() && !thatSheetIt.hasNext();
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    public void setExtensionsRev(String extensionsRev) {
        Properties oldProperties = this.captureProperties();
        this.extensionsRev = extensionsRev;
        this.notifyPropertyChanges(oldProperties, true);
    }

    public String getExtensionsRev() {
        return this.extensionsRev;
    }

    public void setExtensionsRevAsContentHash(String hash) {
        this.setExtensionsRev(PREFIX_HASH + hash);
    }

    public String getExtensionsRevAsContentHash() {
        if (this.extensionsRev != null && this.extensionsRev.startsWith(PREFIX_HASH)) {
            return this.extensionsRev.substring(PREFIX_HASH.length());
        }
        return null;
    }

    public String getExtensionsHash() {
        return this.extensionsHash;
    }

    public String getUpdateBy() {
        return this.updateBy;
    }

    public String toString() {
        return this.toJSON().toString(4);
    }

    private static JSONObject optSheetObject(JSONArray sheetArray, String id) {
        int i = 0;
        while (i < sheetArray.length()) {
            JSONObject sheetObject = sheetArray.optJSONObject(i);
            if (sheetObject != null && id.equals(sheetObject.optString("id", null))) {
                sheetArray.remove(i);
                return sheetObject;
            }
            ++i;
        }
        return null;
    }
}

