/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.net.internal;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class MonitoredOutputStream
extends OutputStream {
    private OutputStream realStream;
    private IProgressMonitor monitor;

    public MonitoredOutputStream(OutputStream realStream, IProgressMonitor monitor) {
        this.realStream = realStream;
        this.monitor = monitor;
    }

    private void closeRealStream() {
        try {
            this.realStream.close();
        }
        catch (IOException iOException) {}
    }

    @Override
    public void close() throws IOException {
        this.realStream.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new OperationCanceledException();
        }
        this.realStream.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new OperationCanceledException();
        }
        this.realStream.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new OperationCanceledException();
        }
        this.realStream.write(b);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new OperationCanceledException();
        }
        this.realStream.write(b);
    }
}

