/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.xmind.ui.internal.presentation.INavigationHistoryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationHistory {
    private List<ISelection> history = new ArrayList<ISelection>();
    private List<INavigationHistoryListener> listeners = null;
    private int current = -1;

    public void add(ISelection selection) {
        if (selection == null) {
            return;
        }
        ++this.current;
        if (this.history.size() <= this.current) {
            this.history.add(selection);
            this.current = this.history.size() - 1;
        } else {
            this.history.set(this.current, selection);
        }
        this.fireHistoryChanged();
    }

    public ISelection prev() {
        if (this.current < 0) {
            return null;
        }
        --this.current;
        if (this.current < 0 || this.current >= this.history.size()) {
            return null;
        }
        return this.history.get(this.current);
    }

    public ISelection next() {
        if (this.current < this.history.size() - 1) {
            ++this.current;
            if (this.current >= 0) {
                return this.history.get(this.current);
            }
        }
        return null;
    }

    public ISelection current() {
        if (this.current >= 0 && this.current < this.history.size()) {
            return this.history.get(this.current);
        }
        return null;
    }

    public List<ISelection> getHistory() {
        return this.history;
    }

    public void addNavigationHistoryListener(INavigationHistoryListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<INavigationHistoryListener>();
        }
        this.listeners.add(listener);
    }

    public void removeNavigationHistoryListener(INavigationHistoryListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    protected void fireHistoryChanged() {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((INavigationHistoryListener)l).navigationHistoryChanged(this);
            ++n2;
        }
    }
}

