/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.core.IAdaptable;
import org.xmind.core.IBoundary;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.part.IPart;
import org.xmind.ui.internal.figures.BranchFigure;
import org.xmind.ui.internal.figures.RelationshipFigure;
import org.xmind.ui.internal.presentation.slide.PresentationSlide;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;

public class SlideBoundsCalculator {
    private IGraphicalViewer viewer;

    public SlideBoundsCalculator(IGraphicalViewer viewer) {
        this.viewer = viewer;
    }

    public Rectangle getSlideBounds(PresentationSlide slide) {
        String type = slide.getType();
        if ("topic".equals(type)) {
            return this.getTopicTypeSlideBounds(slide);
        }
        if ("summary".equals(type)) {
            return this.getSummaryTypeSlideBounds(slide);
        }
        if ("boundary".equals(type)) {
            return this.getBoundaryTypeSlideBounds(slide);
        }
        if ("relationship".equals(type)) {
            return this.getRelationshipTypeSLideBounds(slide);
        }
        throw new IllegalArgumentException();
    }

    private Rectangle getTopicTypeSlideBounds(PresentationSlide slide) {
        if (!(slide.getParent() instanceof ITopic)) {
            throw new IllegalArgumentException();
        }
        ITopic parent = (ITopic)slide.getParent();
        ISheet sheet = parent.getOwnedSheet();
        if (sheet == null) {
            throw new IllegalArgumentException();
        }
        Rectangle parentBounds = SlideBoundsCalculator.getTopicBounds(this.viewer, parent);
        if (parentBounds == null) {
            throw new IllegalArgumentException();
        }
        Rectangle relationshipBounds = null;
        for (IRelationship r : sheet.getRelationships()) {
            Rectangle bounds;
            IRelationshipEnd e1 = r.getEnd1();
            IRelationshipEnd e2 = r.getEnd2();
            if (!this.canReveal(e1, parent) || !this.canReveal(e2, parent) || (bounds = SlideBoundsCalculator.getRelationshipBounds(this.viewer, r)) == null) continue;
            relationshipBounds = Geometry.union(relationshipBounds, (Rectangle)bounds);
        }
        if (relationshipBounds == null) {
            return this.viewer.getZoomManager().getScaled(parentBounds);
        }
        return this.viewer.getZoomManager().getScaled(Geometry.union(relationshipBounds, (Rectangle)parentBounds));
    }

    private boolean canReveal(IRelationshipEnd end, ITopic parent) {
        if (end instanceof ITopic) {
            ITopic t = (ITopic)end;
            return t.equals(parent) || t.getPath().isDescendentOf(parent);
        }
        if (end instanceof IBoundary) {
            IBoundary b = (IBoundary)end;
            for (ITopic t : b.getEnclosingTopics()) {
                if (t.getPath().isDescendentOf(parent) || t.equals(parent)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Rectangle getSummaryTypeSlideBounds(PresentationSlide slide) {
        if (!(slide.getParent() instanceof ISummary)) {
            throw new IllegalArgumentException();
        }
        ISummary parent = (ISummary)slide.getParent();
        IBranchPart summaryParentBranchPart = SlideBoundsCalculator.findBranchPart(this.viewer, parent.getParent());
        ISummaryPart summaryPart = null;
        for (ISummaryPart sp : summaryParentBranchPart.getSummaries()) {
            if (sp.getSummary() != parent) continue;
            summaryPart = sp;
            break;
        }
        if (summaryPart == null) {
            throw new IllegalArgumentException();
        }
        Rectangle bounds = null;
        for (IBranchPart bp : summaryPart.getEnclosingBranches()) {
            bounds = Geometry.union((Rectangle)bounds, (Rectangle)bp.getFigure().getBounds());
        }
        bounds = Geometry.union(bounds, (Rectangle)summaryPart.getFigure().getBounds());
        return (bounds = Geometry.union((Rectangle)bounds, (Rectangle)SlideBoundsCalculator.getTopicBounds(this.viewer, parent.getTopic()))) == null ? null : this.viewer.getZoomManager().getScaled(bounds);
    }

    private Rectangle getBoundaryTypeSlideBounds(PresentationSlide slide) {
        if (!(slide.getParent() instanceof IBoundary)) {
            throw new IllegalArgumentException();
        }
        Rectangle bounds = SlideBoundsCalculator.getBoundaryBounds(this.viewer, (IBoundary)slide.getParent());
        return bounds == null ? null : this.viewer.getZoomManager().getScaled(bounds);
    }

    private Rectangle getRelationshipTypeSLideBounds(PresentationSlide slide) {
        if (!(slide.getParent() instanceof IRelationship)) {
            throw new IllegalArgumentException();
        }
        Rectangle bounds = null;
        for (IAdaptable o : slide.getSelections()) {
            if (!(o instanceof IRelationship)) continue;
            IRelationship r = (IRelationship)o;
            IRelationshipEnd end1 = r.getEnd1();
            IRelationshipEnd end2 = r.getEnd2();
            bounds = Geometry.union(bounds, (Rectangle)SlideBoundsCalculator.getRelationshipEndBounds(this.viewer, end1));
            bounds = Geometry.union((Rectangle)bounds, (Rectangle)SlideBoundsCalculator.getRelationshipEndBounds(this.viewer, end2));
            bounds = Geometry.union((Rectangle)bounds, (Rectangle)SlideBoundsCalculator.getRelationshipBounds(this.viewer, r));
        }
        return bounds == null ? null : this.viewer.getZoomManager().getScaled(bounds);
    }

    private static Rectangle getRelationshipBounds(IGraphicalViewer viewer, IRelationship r) {
        IPart part = viewer.findPart((Object)r);
        if (part instanceof IRelationshipPart) {
            IRelationshipPart rp = (IRelationshipPart)part;
            RelationshipFigure figure = (RelationshipFigure)rp.getFigure();
            return figure.getBounds();
        }
        return null;
    }

    private static Rectangle getRelationshipEndBounds(IGraphicalViewer viewer, IRelationshipEnd end) {
        if (end instanceof ITopic) {
            return SlideBoundsCalculator.getTopicBounds(viewer, (ITopic)end);
        }
        if (end instanceof IBoundary) {
            return SlideBoundsCalculator.getBoundaryBounds(viewer, (IBoundary)end);
        }
        return null;
    }

    private static IBranchPart findBranchPart(IGraphicalViewer viewer, ITopic t) {
        IPart part = viewer.findPart((Object)t);
        if (part != null) {
            return (IBranchPart)part.getAdapter(IBranchPart.class);
        }
        return null;
    }

    private static ITopicPart findTopicPart(IGraphicalViewer viewer, ITopic t) {
        IPart part = viewer.findPart((Object)t);
        if (part instanceof ITopicPart) {
            return (ITopicPart)part;
        }
        return null;
    }

    private static Rectangle getTopicBounds(IGraphicalViewer viewer, ITopic t) {
        IBranchPart branchPart = SlideBoundsCalculator.findBranchPart(viewer, t);
        if (branchPart != null) {
            ITopicPart parentTopicPart;
            BranchFigure figure = (BranchFigure)branchPart.getFigure();
            Rectangle bounds = figure.getBounds();
            for (ITopic subTopic : t.getChildren("detached")) {
                Geometry.union((Rectangle)bounds, (Rectangle)SlideBoundsCalculator.getTopicBounds(viewer, subTopic));
            }
            if ("callout".equals(t.getType()) && (parentTopicPart = SlideBoundsCalculator.findTopicPart(viewer, t.getParent())) != null) {
                Geometry.union((Rectangle)bounds, (Rectangle)parentTopicPart.getFigure().getBounds());
            }
            return bounds;
        }
        return null;
    }

    private static Rectangle getBoundaryBounds(IGraphicalViewer viewer, IBoundary boundary) {
        IPart p = viewer.findPart((Object)boundary);
        if (p instanceof IBoundaryPart) {
            IBoundaryPart boundaryPart = (IBoundaryPart)p;
            return boundaryPart.getFigure().getBounds();
        }
        return null;
    }
}

