/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.Core;
import org.xmind.core.IAdaptable;
import org.xmind.core.IBoundary;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.IRelationship;
import org.xmind.core.IResourceRef;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookExtension;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.internal.presentation.Presentation;
import org.xmind.ui.internal.presentation.slide.PresentationExportSourceProvider;
import org.xmind.ui.internal.presentation.slide.PresentationSlide;
import org.xmind.ui.mindmap.GhostShellProvider;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.mindmap.MindMapExportViewer;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.mindmap.MindMapViewerExportSourceProvider;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.viewers.ICompositeProvider;

public class SlidePreviewGenerator {
    private SlidePreviewGenerator() {
    }

    public static void regeneratePreview(PresentationSlide slide) {
        IResourceRef newRef = SlidePreviewGenerator.generate(slide);
        if (newRef == null) {
            return;
        }
        IWorkbookExtension ext = slide.getElement().getExtension();
        IResourceRef oldRef = slide.getResourceRef();
        if (oldRef != null) {
            ext.removeResourceRef(oldRef);
        }
        slide.setResourceRef(newRef);
        if (newRef != null) {
            ext.addResourceRef(newRef);
        }
    }

    public static IResourceRef generate(PresentationSlide slide) {
        IAdaptable parent = slide.getParent();
        ISheet ownedSheet = SlidePreviewGenerator.getOwnedSheet(parent);
        if (ownedSheet == null) {
            throw new IllegalArgumentException();
        }
        File temp = SlidePreviewGenerator.createTempFile();
        MindMapExportViewer viewer = new MindMapExportViewer((ICompositeProvider)new GhostShellProvider(null), (Object)new MindMap(ownedSheet), null);
        MindMapImageExporter exporter = SlidePreviewGenerator.createImageExporter(SlidePreviewGenerator.createProvider(slide, viewer), temp);
        exporter.export();
        viewer.getControl().dispose();
        IWorkbook wb = slide.getOwnedWorkbook();
        IFileEntry entry = SlidePreviewGenerator.createFileEntry(wb, temp);
        if (entry == null) {
            return null;
        }
        return wb.createResourceRef("file-entry", entry.getPath());
    }

    private static ISheet getOwnedSheet(IAdaptable o) {
        if (o instanceof ITopic) {
            return ((ITopic)o).getOwnedSheet();
        }
        if (o instanceof IBoundary) {
            return ((IBoundary)o).getOwnedSheet();
        }
        if (o instanceof IRelationship) {
            return ((IRelationship)o).getOwnedSheet();
        }
        if (o instanceof ISummary) {
            return ((ISummary)o).getOwnedSheet();
        }
        return null;
    }

    private static MindMapImageExporter createImageExporter(MindMapViewerExportSourceProvider provider, File temp) {
        MindMapImageExporter exporter = new MindMapImageExporter(Display.getDefault());
        exporter.setSourceProvider(provider);
        exporter.setImageFormat(ImageFormat.PNG);
        exporter.setResize(1, 360, 200);
        exporter.setTargetFile(temp);
        return exporter;
    }

    private static File createTempFile() {
        String tempDir = Core.getWorkspace().getTempDir("slide");
        try {
            return File.createTempFile("slide", ".png", new File(tempDir));
        }
        catch (IOException iOException) {
            return new File(tempDir, String.format("slide_%1$tY%1$tm%1$td%1$tH%1$tM%1$tS.mp3", Calendar.getInstance()));
        }
    }

    private static MindMapViewerExportSourceProvider createProvider(PresentationSlide slide, MindMapExportViewer viewer) {
        return new PresentationExportSourceProvider((IGraphicalViewer)viewer, slide);
    }

    private static IFileEntry createFileEntry(IWorkbook workbook, File tempFile) {
        IManifest manifest = workbook.getManifest();
        IFileEntry entry = null;
        try {
            entry = manifest.createAttachmentFromFilePath(tempFile.getAbsolutePath());
        }
        catch (IOException e) {
            Presentation.log(e, "Error occurred while copying temp file into workbook: " + tempFile.getAbsolutePath());
            return null;
        }
        return entry;
    }
}

