/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.List;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.presentation.slide.PresentationSlide;
import org.xmind.ui.internal.presentation.slide.PresentationStory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSlideCommand
extends SourceCommand {
    private PresentationStory story;
    private List<PresentationSlide> slides;
    private int index;
    private int oldIndex = -1;
    private PresentationSlide oldSlide;

    public UpdateSlideCommand(PresentationStory story, List<PresentationSlide> slides, int index) {
        super(slides);
        this.story = story;
        this.slides = slides;
        this.index = index;
        this.oldIndex = index;
        this.oldSlide = story.getSlides().get(this.oldIndex);
    }

    public void redo() {
        this.story.deleteSlide(this.oldSlide);
        int i = this.index;
        for (PresentationSlide slide : this.slides) {
            this.story.addSlide(slide, i++);
        }
        super.redo();
    }

    public void undo() {
        for (PresentationSlide slide : this.slides) {
            this.story.deleteSlide(slide);
        }
        this.story.addSlide(this.oldSlide, this.oldIndex);
        super.undo();
    }
}

