/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.org.freehep.graphicsio.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.xmind.org.freehep.graphics2d.font.CharTable;

public abstract class FontIncluder {
    public static final double FONT_SIZE = 1000.0;
    private FontRenderContext context;
    private Rectangle2D fontBBox;
    private Font font;
    private String fontName;
    private CharTable charTable;
    private char[] unicode;
    private String[] charName;
    private int noDefinedChars;

    protected abstract void openIncludeFont() throws IOException;

    protected abstract void writeEncoding(CharTable var1) throws IOException;

    protected void closeIncludeFont() throws IOException {
    }

    public FontIncluder(FontRenderContext context) {
        this.context = context;
        this.noDefinedChars = -1;
    }

    protected FontRenderContext getContext() {
        return this.context;
    }

    protected String getFontName() {
        return this.fontName;
    }

    protected Font getFont() {
        return this.font;
    }

    protected CharTable getEncodingTable() {
        return this.charTable;
    }

    protected Rectangle2D getFontBBox() {
        return this.fontBBox;
    }

    protected String getCharName(int i) {
        return this.charName[i];
    }

    protected char getUnicode(int i) {
        return this.unicode[i];
    }

    protected char[] getUnicode() {
        return this.unicode;
    }

    protected int getNODefinedChars() {
        return this.noDefinedChars;
    }

    public void includeFont(Font font, CharTable charTable, String name) throws IOException {
        this.unicode = null;
        this.charName = null;
        this.font = font;
        this.charTable = charTable;
        this.fontName = name;
        this.fontBBox = font.getMaxCharBounds(this.context);
        this.noDefinedChars = 0;
        this.unicode = new char[256];
        this.charName = new String[256];
        int i = 0;
        while (i < this.unicode.length) {
            this.charName[i] = charTable.toName(i);
            if (this.charName[i] != null) {
                this.unicode[i] = charTable.toUnicode(this.charName[i]);
                ++this.noDefinedChars;
            } else {
                this.unicode[i] = '\u0000';
            }
            ++i;
        }
        this.openIncludeFont();
        this.writeEncoding(charTable);
        this.closeIncludeFont();
    }

    protected double getUndefinedWidth() {
        return 1000.0;
    }
}

