/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import org.eclipse.core.runtime.Assert;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.SourceCommand;

public class ModifyRightNumberOfUnbalancedStructureCommand
extends SourceCommand {
    private ITopic topic = null;
    private String preNum;
    private int postNum;

    public ModifyRightNumberOfUnbalancedStructureCommand(ITopic topic, String preNum, int postNum) {
        Assert.isNotNull((Object)topic);
        this.topic = topic;
        this.preNum = preNum;
        this.postNum = postNum;
    }

    public void redo() {
        ITopicExtension extension = this.topic.createExtension("org.xmind.ui.map.unbalanced");
        ITopicExtensionElement element = (ITopicExtensionElement)extension.getContent().getCreatedChild("right-number");
        element.setTextContent(String.valueOf(this.postNum));
        this.fireForceStructureChange();
        super.redo();
    }

    public void undo() {
        ITopicExtension extension = this.topic.createExtension("org.xmind.ui.map.unbalanced");
        ITopicExtensionElement element = (ITopicExtensionElement)extension.getContent().getCreatedChild("right-number");
        element.setTextContent(this.preNum);
        this.fireForceStructureChange();
        super.undo();
    }

    private void fireForceStructureChange() {
        if (!(this.topic instanceof ICoreEventSource)) {
            return;
        }
        ICoreEventSource source = (ICoreEventSource)this.topic;
        String eventType = "structureClass";
        String structureClass = this.topic.getStructureClass();
        source.getCoreEventSupport().dispatch(source, new CoreEvent(source, eventType, (Object)structureClass, (Object)structureClass));
    }
}

