/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.editor;

import java.util.List;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Control;
import org.xmind.core.ISettingEntry;
import org.xmind.core.ISheet;
import org.xmind.ui.internal.editor.MindMapEditor;
import org.xmind.ui.resources.ColorUtils;

public class PageTitleTabFolderRenderer
extends CTabFolderRenderer {
    private static final int FLAGS = 9;
    private static final String ELLIPSIS = "...";
    private MindMapEditor editor;
    private ResourceManager resources;

    public PageTitleTabFolderRenderer(CTabFolder parent, MindMapEditor editor) {
        super(parent);
        this.editor = editor;
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
    }

    protected void draw(int part, int state, Rectangle bounds, GC gc) {
        super.draw(part, state, bounds, gc);
        if (part >= 0 && part < this.parent.getItemCount()) {
            if (bounds.width == 0 || bounds.height == 0) {
                return;
            }
            if ((state & 2) != 0) {
                this.drawSelectedItem(part, gc, bounds, state);
            } else {
                this.drawUnselectedItem(part, gc, bounds, state);
            }
        }
    }

    private void drawSelectedItem(int index, GC gc, Rectangle bounds, int state) {
        if ((state & 8) != 0) {
            this.drawItemBackground(index, gc, true);
        }
        if ((state & 0x10) != 0) {
            this.drawItemText(index, gc);
        }
    }

    private void drawUnselectedItem(int index, GC gc, Rectangle bounds, int state) {
        CTabItem item = this.parent.getItem(index);
        if (!item.isShowing()) {
            return;
        }
        Rectangle clipping = gc.getClipping();
        if (!clipping.intersects(bounds)) {
            return;
        }
        if ((state & 8) != 0) {
            this.drawItemBackground(index, gc, false);
        }
    }

    private void drawItemBackground(int index, GC gc, boolean selected) {
        Rectangle bounds = this.parent.getItem(index).getBounds();
        Color gcBackground = gc.getBackground();
        Color background = this.getColor(index);
        if (background != null && !gcBackground.equals((Object)background)) {
            gc.setBackground(background);
            Rectangle paintedArea = selected ? new Rectangle(bounds.x, bounds.y + bounds.height * 6 / 7, bounds.width, bounds.height / 7) : new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height / 7);
            gc.fillRectangle(paintedArea);
            gc.setBackground(gcBackground);
        }
    }

    private void drawItemText(int index, GC gc) {
        Color foreground = this.getColor(index);
        if (foreground == null || foreground.equals((Object)gc.getForeground())) {
            return;
        }
        CTabItem item = this.parent.getItem(index);
        Rectangle bounds = item.getBounds();
        int x = bounds.x;
        int y = bounds.y;
        int height = bounds.height;
        int width = bounds.width;
        Rectangle trim = this.computeTrim(index, 0, 0, 0, 0, 0);
        int xDraw = x - trim.x;
        int textWidth = x + width - xDraw - (trim.width + trim.x);
        if (textWidth > 0) {
            Font gcFont = gc.getFont();
            Color gcForeground = gc.getForeground();
            Color gcBackground = gc.getBackground();
            gc.setFont(item.getFont());
            gc.setBackground(this.parent.getDisplay().getSystemColor(1));
            String shortenedText = this.shortenText2(gc, item.getText(), textWidth);
            Point extent = gc.textExtent(shortenedText, 9);
            int textY = y + (height - extent.y) / 2;
            boolean onBottom = (this.parent.getStyle() & 0x400) != 0;
            int n = onBottom ? -1 : 1;
            gc.setForeground(foreground);
            gc.drawText(shortenedText, xDraw, textY += n, false);
            gc.setFont(gcFont);
            gc.setForeground(gcForeground);
            gc.setBackground(gcBackground);
        }
    }

    private String shortenText2(GC gc, String text, int width) {
        return this.useEllipses2() ? this.shortenText2(gc, text, width, ELLIPSIS) : this.shortenText2(gc, text, width, "");
    }

    private boolean useEllipses2() {
        return this.parent.getSimple();
    }

    private String shortenText2(GC gc, String text, int width, String ellipses) {
        if (gc.textExtent((String)text, (int)9).x <= width) {
            return text;
        }
        int ellipseWidth = gc.textExtent((String)ellipses, (int)9).x;
        int length = text.length();
        TextLayout layout = new TextLayout((Device)this.parent.getDisplay());
        layout.setText(text);
        int end = layout.getPreviousOffset(length, 2);
        while (end > 0) {
            text = text.substring(0, end);
            int l = gc.textExtent((String)text, (int)9).x;
            if (l + ellipseWidth <= width) break;
            end = layout.getPreviousOffset(end, 2);
        }
        layout.dispose();
        return end == 0 ? text.substring(0, 1) : String.valueOf(text) + ellipses;
    }

    private Color getColor(int index) {
        if (index < 0 || index >= this.editor.getPages().length) {
            return null;
        }
        ISheet sheet = (ISheet)this.editor.getPage(index).getAdapter(ISheet.class);
        String rgb = this.getRgb(sheet);
        if (rgb == null || rgb.equals("")) {
            return null;
        }
        return (Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)rgb));
    }

    private String getRgb(ISheet sheet) {
        ISettingEntry entry = this.findEntry(sheet);
        return entry == null ? null : entry.getAttribute("rgb");
    }

    private ISettingEntry findEntry(ISheet sheet) {
        List entries = sheet.getSettings().getEntries("tab-color");
        return entries.size() == 0 ? null : (ISettingEntry)entries.get(0);
    }
}

