/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IMemento;
import org.xmind.core.Core;
import org.xmind.core.IWorkbook;
import org.xmind.core.style.IStyle;
import org.xmind.ui.internal.editor.AbstractWorkbookRef;
import org.xmind.ui.internal.editor.URIParser;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.mindmap.WorkbookInitializer;

public class CreatedWorkbookRef
extends AbstractWorkbookRef {
    protected static final String URI_PATH = "/create";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_STRUCTURE_CLASS = "structureClass";
    private static final String PARAM_THEME_URI = "themeURI";

    private CreatedWorkbookRef(URI uri, IMemento state) {
        super(uri, state);
    }

    public String getName() {
        String name = URIParser.getQueryParameter(this.getURI(), PARAM_NAME);
        if (name != null) {
            return name;
        }
        return null;
    }

    public String getDescription() {
        return this.getName();
    }

    @Override
    protected IWorkbook doLoadWorkbookFromURI(IProgressMonitor monitor, URI uri) throws InterruptedException, InvocationTargetException {
        IWorkbook workbook = Core.getWorkbookBuilder().createWorkbook(this.getTempStorage());
        CreatedWorkbookRef.toInitializer(this.getURI()).initWorkbook(workbook);
        return workbook;
    }

    private static WorkbookInitializer toInitializer(URI uri) {
        WorkbookInitializer initializer = WorkbookInitializer.getDefault();
        Iterator<URIParser.QueryParameter> it = URIParser.iterateQueryParameters(uri);
        while (it.hasNext()) {
            Object theme;
            URIParser.QueryParameter p = it.next();
            if (PARAM_STRUCTURE_CLASS.equals(p.name)) {
                initializer = initializer.withStructureClass(p.value);
                continue;
            }
            if (!PARAM_THEME_URI.equals(p.name) || (theme = MindMapUI.getResourceManager().findResource(p.value)) == null || !(theme instanceof IStyle)) continue;
            initializer = initializer.withTheme((IStyle)theme);
        }
        return initializer;
    }

    public static IWorkbookRef create(URI uri, IMemento state) {
        Assert.isNotNull((Object)uri);
        Assert.isLegal((boolean)"xmind-temp".equals(uri.getScheme()));
        Assert.isLegal((boolean)URI_PATH.equals(uri.getPath()));
        return new CreatedWorkbookRef(uri, state);
    }

    public static IWorkbookRef createFromWorkbookInitializer(WorkbookInitializer initializer, String name) {
        Assert.isNotNull((Object)initializer);
        URI uri = URI.create("xmind-temp:/create");
        if (name != null) {
            uri = URIParser.appendQueryParameter(uri, PARAM_NAME, name);
        }
        if (initializer.getStructureClass() != null) {
            uri = URIParser.appendQueryParameter(uri, PARAM_STRUCTURE_CLASS, initializer.getStructureClass());
        }
        if (initializer.getTheme() != null) {
            uri = URIParser.appendQueryParameter(uri, PARAM_THEME_URI, MindMapUI.getResourceManager().toResourceURI(initializer.getTheme()));
        }
        return new CreatedWorkbookRef(uri, null);
    }
}

