/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.xmind.core.INamed;
import org.xmind.core.ISheet;
import org.xmind.core.ITitled;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.gef.ui.editor.GraphicalEditorActionBarContributor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.internal.IActionBuilder;
import org.xmind.ui.internal.ImageActionExtensionManager;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.actions.CopiedSheetStorageSupport;
import org.xmind.ui.internal.actions.DropDownInsertImageAction;
import org.xmind.ui.internal.actions.FindReplaceAction;
import org.xmind.ui.internal.actions.RenameSheetAction;
import org.xmind.ui.internal.actions.SaveSheetAsAction;
import org.xmind.ui.mindmap.ICategoryAnalyzation;
import org.xmind.ui.mindmap.ICategoryManager;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class MindMapContributor
extends GraphicalEditorActionBarContributor
implements ISelectionListener {
    private ActionFactory.IWorkbenchAction selectBrothersAction;
    private ActionFactory.IWorkbenchAction selectChildrenAction;
    private ActionFactory.IWorkbenchAction goHomeAction;
    private ActionFactory.IWorkbenchAction drillDownAction;
    private ActionFactory.IWorkbenchAction drillUpAction;
    private ActionFactory.IWorkbenchAction insertTopicAction;
    private ActionFactory.IWorkbenchAction insertSubtopicAction;
    private ActionFactory.IWorkbenchAction insertTopicBeforeAction;
    private ActionFactory.IWorkbenchAction insertParentTopicAction;
    private ActionFactory.IWorkbenchAction insertFloatingTopicAction;
    private ActionFactory.IWorkbenchAction insertFloatingCentralTopicAction;
    private ActionFactory.IWorkbenchAction insertSheetAction;
    private ActionFactory.IWorkbenchAction extendAction;
    private ActionFactory.IWorkbenchAction collapseAction;
    private ActionFactory.IWorkbenchAction extendAllAction;
    private ActionFactory.IWorkbenchAction collapseAllAction;
    private ActionFactory.IWorkbenchAction modifyHyperlinkAction;
    private ActionFactory.IWorkbenchAction openHyperlinkAction;
    private ActionFactory.IWorkbenchAction cancelHyperlinkAction;
    private ActionFactory.IWorkbenchAction insertAttachmentAction;
    private ActionFactory.IWorkbenchAction insertImageAction;
    private ActionFactory.IWorkbenchAction newSheetAction;
    private ActionFactory.IWorkbenchAction deleteSheetAction;
    private ActionFactory.IWorkbenchAction deleteOtherSheetAction;
    private ActionFactory.IWorkbenchAction duplicateSheetAction;
    private ActionFactory.IWorkbenchAction copySheetAction;
    private ActionFactory.IWorkbenchAction pasteSheetAction;
    private SaveSheetAsAction saveSheetAsAction;
    private ActionFactory.IWorkbenchAction tileAction;
    private ActionFactory.IWorkbenchAction resetPositionAction;
    private ActionFactory.IWorkbenchAction createRelationshipAction;
    private ActionFactory.IWorkbenchAction editTitleAction;
    private ActionFactory.IWorkbenchAction editLabelAction;
    private ActionFactory.IWorkbenchAction editNotesAction;
    private ActionFactory.IWorkbenchAction traverseAction;
    private ActionFactory.IWorkbenchAction finishAction;
    private ActionFactory.IWorkbenchAction findReplaceAction;
    private RenameSheetAction renameSheetAction;
    private ActionFactory.IWorkbenchAction deleteAction;
    private ActionFactory.IWorkbenchAction copyAction;
    private ActionFactory.IWorkbenchAction cutAction;
    private ActionFactory.IWorkbenchAction pasteAction;
    private ActionFactory.IWorkbenchAction propertiesAction;
    private ActionFactory.IWorkbenchAction duplicateAction;
    private ActionFactory.IWorkbenchAction dropDownInsertImageAction;
    private ActionFactory.IWorkbenchAction removeAllStylesAction;
    private IHandlerService handlerService;
    private Map<IAction, IHandlerActivation> actionHandlerActivations;
    private IGraphicalEditorPage page;
    private ISelectionService selectionService;

    public void init(IActionBars bars, IWorkbenchPage page) {
        this.handlerService = (IHandlerService)page.getWorkbenchWindow().getService(IHandlerService.class);
        this.actionHandlerActivations = this.handlerService != null ? new HashMap<IAction, IHandlerActivation>(33) : null;
        if (this.selectionService != null) {
            this.selectionService.removeSelectionListener((ISelectionListener)this);
        }
        this.selectionService = page.getWorkbenchWindow().getSelectionService();
        this.selectionService.addSelectionListener((ISelectionListener)this);
        super.init(bars, page);
    }

    protected void declareGlobalActionIds() {
        this.addGlobalActionId(ActionFactory.UNDO.getId());
        this.addGlobalActionId(ActionFactory.REDO.getId());
        this.addGlobalActionId(ActionFactory.SELECT_ALL.getId());
        this.addGlobalActionId(ActionFactory.PRINT.getId());
    }

    protected void makeActions() {
        IWorkbenchWindow window = this.getPage().getWorkbenchWindow();
        this.selectBrothersAction = MindMapActionFactory.SELECT_BROTHERS.create(window);
        this.addRetargetAction((RetargetAction)this.selectBrothersAction);
        this.selectChildrenAction = MindMapActionFactory.SELECT_CHILDREN.create(window);
        this.addRetargetAction((RetargetAction)this.selectChildrenAction);
        this.goHomeAction = MindMapActionFactory.GO_HOME.create(window);
        this.addRetargetAction((RetargetAction)this.goHomeAction);
        this.drillDownAction = MindMapActionFactory.DRILL_DOWN.create(window);
        this.addRetargetAction((RetargetAction)this.drillDownAction);
        this.drillUpAction = MindMapActionFactory.DRILL_UP.create(window);
        this.addRetargetAction((RetargetAction)this.drillUpAction);
        this.insertSheetAction = MindMapActionFactory.INSERT_SHEET_FROM.create(window);
        this.addRetargetAction((RetargetAction)this.insertSheetAction);
        this.insertTopicAction = MindMapActionFactory.INSERT_TOPIC.create(window);
        this.addRetargetAction((RetargetAction)this.insertTopicAction);
        this.insertSubtopicAction = MindMapActionFactory.INSERT_SUBTOPIC.create(window);
        this.addRetargetAction((RetargetAction)this.insertSubtopicAction);
        this.insertTopicBeforeAction = MindMapActionFactory.INSERT_TOPIC_BEFORE.create(window);
        this.addRetargetAction((RetargetAction)this.insertTopicBeforeAction);
        this.insertParentTopicAction = MindMapActionFactory.INSERT_PARENT_TOPIC.create(window);
        this.addRetargetAction((RetargetAction)this.insertParentTopicAction);
        this.insertFloatingTopicAction = MindMapActionFactory.INSERT_FLOATING_TOPIC.create(window);
        this.addRetargetAction((RetargetAction)this.insertFloatingTopicAction);
        this.insertFloatingCentralTopicAction = MindMapActionFactory.INSERT_FLOATING_CENTRAL_TOPIC.create(window);
        this.addRetargetAction((RetargetAction)this.insertFloatingCentralTopicAction);
        this.extendAction = MindMapActionFactory.EXTEND.create(window);
        this.addRetargetAction((RetargetAction)this.extendAction);
        this.collapseAction = MindMapActionFactory.COLLAPSE.create(window);
        this.addRetargetAction((RetargetAction)this.collapseAction);
        this.extendAllAction = MindMapActionFactory.EXTEND_ALL.create(window);
        this.addRetargetAction((RetargetAction)this.extendAllAction);
        this.collapseAllAction = MindMapActionFactory.COLLAPSE_ALL.create(window);
        this.addRetargetAction((RetargetAction)this.collapseAllAction);
        this.modifyHyperlinkAction = MindMapActionFactory.MODIFY_HYPERLINK.create(window);
        this.addRetargetAction((RetargetAction)this.modifyHyperlinkAction);
        this.openHyperlinkAction = MindMapActionFactory.OPEN_HYPERLINK.create(window);
        this.addRetargetAction((RetargetAction)this.openHyperlinkAction);
        this.cancelHyperlinkAction = MindMapActionFactory.CANCEL_HYPERLINK.create(window);
        this.addRetargetAction((RetargetAction)this.cancelHyperlinkAction);
        this.insertAttachmentAction = MindMapActionFactory.INSERT_ATTACHMENT.create(window);
        this.addRetargetAction((RetargetAction)this.insertAttachmentAction);
        this.insertImageAction = MindMapActionFactory.INSERT_IMAGE.create(window);
        this.addRetargetAction((RetargetAction)this.insertImageAction);
        this.newSheetAction = MindMapActionFactory.NEW_SHEET.create(window);
        this.addRetargetAction((RetargetAction)this.newSheetAction);
        this.deleteSheetAction = MindMapActionFactory.DELETE_SHEET.create(window);
        this.addRetargetAction((RetargetAction)this.deleteSheetAction);
        this.deleteOtherSheetAction = MindMapActionFactory.DELETE_OTHER_SHEET.create(window);
        this.addRetargetAction((RetargetAction)this.deleteOtherSheetAction);
        this.duplicateSheetAction = MindMapActionFactory.DUPLICATE_SHEET.create(window);
        this.addRetargetAction((RetargetAction)this.duplicateSheetAction);
        this.copySheetAction = MindMapActionFactory.COPY_SHEET.create(window);
        this.addRetargetAction((RetargetAction)this.copySheetAction);
        this.pasteSheetAction = MindMapActionFactory.PASTE_SHEET.create(window);
        this.addRetargetAction((RetargetAction)this.pasteSheetAction);
        this.saveSheetAsAction = new SaveSheetAsAction();
        this.addAction((IAction)this.saveSheetAsAction);
        this.createRelationshipAction = MindMapActionFactory.CREATE_RELATIONSHIP.create(window);
        this.addRetargetAction((RetargetAction)this.createRelationshipAction);
        this.editTitleAction = MindMapActionFactory.EDIT_TITLE.create(window);
        this.addRetargetAction((RetargetAction)this.editTitleAction);
        this.editLabelAction = MindMapActionFactory.EDIT_LABEL.create(window);
        this.addRetargetAction((RetargetAction)this.editLabelAction);
        this.editNotesAction = MindMapActionFactory.EDIT_NOTES.create(window);
        this.addRetargetAction((RetargetAction)this.editNotesAction);
        this.traverseAction = MindMapActionFactory.TRAVERSE.create(window);
        this.addRetargetAction((RetargetAction)this.traverseAction);
        this.finishAction = MindMapActionFactory.FINISH.create(window);
        this.addRetargetAction((RetargetAction)this.finishAction);
        this.removeAllStylesAction = MindMapActionFactory.REMOVE_ALL_STYLES.create(window);
        this.addRetargetAction((RetargetAction)this.removeAllStylesAction);
        this.tileAction = MindMapActionFactory.TILE.create(window);
        this.addRetargetAction((RetargetAction)this.tileAction);
        this.resetPositionAction = MindMapActionFactory.RESET_POSITION.create(window);
        this.addRetargetAction((RetargetAction)this.resetPositionAction);
        this.findReplaceAction = new FindReplaceAction(window);
        this.addAction((IAction)this.findReplaceAction);
        this.renameSheetAction = new RenameSheetAction();
        this.addAction((IAction)this.renameSheetAction);
        this.deleteAction = ActionFactory.DELETE.create(window);
        this.addRetargetAction((RetargetAction)this.deleteAction);
        this.copyAction = ActionFactory.COPY.create(window);
        this.addRetargetAction((RetargetAction)this.copyAction);
        this.cutAction = ActionFactory.CUT.create(window);
        this.addRetargetAction((RetargetAction)this.cutAction);
        this.pasteAction = ActionFactory.PASTE.create(window);
        this.addRetargetAction((RetargetAction)this.pasteAction);
        this.propertiesAction = ActionFactory.PROPERTIES.create(window);
        this.addRetargetAction((RetargetAction)this.propertiesAction);
        this.duplicateAction = MindMapActionFactory.DUPLICATE.create(window);
        this.addRetargetAction((RetargetAction)this.duplicateAction);
        this.addRetargetAction((RetargetAction)MindMapActionFactory.MOVE_UP.create(window));
        this.addRetargetAction((RetargetAction)MindMapActionFactory.MOVE_DOWN.create(window));
        this.addRetargetAction((RetargetAction)MindMapActionFactory.MOVE_LEFT.create(window));
        this.addRetargetAction((RetargetAction)MindMapActionFactory.MOVE_RIGHT.create(window));
        List<IActionBuilder> imageActionBuilders = ImageActionExtensionManager.getInstance().getActionBuilders();
        ArrayList<ActionFactory.IWorkbenchAction> imageActionExtensions = new ArrayList<ActionFactory.IWorkbenchAction>(imageActionBuilders.size());
        for (IActionBuilder builder : imageActionBuilders) {
            ActionFactory.IWorkbenchAction imageActionExtension = builder.createAction(this.getPage());
            imageActionExtensions.add(imageActionExtension);
            this.addAction((IAction)imageActionExtension);
        }
        if (imageActionExtensions.size() > 0) {
            imageActionExtensions.add(0, this.insertImageAction);
            this.dropDownInsertImageAction = new DropDownInsertImageAction((IAction)this.insertImageAction, imageActionExtensions);
            this.addAction((IAction)this.dropDownInsertImageAction);
            this.dropDownInsertImageAction.setText(this.insertImageAction.getText());
            this.dropDownInsertImageAction.setToolTipText(this.insertImageAction.getToolTipText());
            this.dropDownInsertImageAction.setImageDescriptor(this.insertImageAction.getImageDescriptor());
            this.dropDownInsertImageAction.setDisabledImageDescriptor(this.insertImageAction.getDisabledImageDescriptor());
            this.insertImageAction.setText(MindMapMessages.InsertImageFromFile_text);
            this.insertImageAction.setToolTipText(MindMapMessages.InsertImageFromFile_toolTip);
            this.insertImageAction.setImageDescriptor(null);
            this.insertImageAction.setDisabledImageDescriptor(null);
        }
    }

    public void init(IActionBars bars) {
        super.init(bars);
        bars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.findReplaceAction);
    }

    protected void addAction(IAction action) {
        super.addAction(action);
        this.activateHandler(action);
    }

    protected void activePageChanged(IGraphicalEditorPage page) {
        this.page = page;
        if (this.saveSheetAsAction != null) {
            this.saveSheetAsAction.setActivePage(page);
        }
        if (this.renameSheetAction != null) {
            this.renameSheetAction.setActivePage(page);
        }
    }

    protected void activateHandler(IAction action) {
        String commandId;
        if (this.handlerService != null && this.actionHandlerActivations != null && (commandId = action.getActionDefinitionId()) != null) {
            IHandlerActivation handlerActivation = this.handlerService.activateHandler(commandId, (IHandler)new ActionHandler(action));
            this.actionHandlerActivations.put(action, handlerActivation);
        }
    }

    protected void deactivateHandler(IAction action) {
        IHandlerActivation activation;
        if (this.handlerService != null && this.actionHandlerActivations != null && (activation = this.actionHandlerActivations.remove(action)) != null) {
            this.handlerService.deactivateHandler(activation);
        }
    }

    public void contributeToPagePopupMenu(IMenuManager menu) {
        menu.add((IAction)this.renameSheetAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.copySheetAction);
        if (this.isCopiedSheetAvailable()) {
            menu.add((IAction)this.pasteSheetAction);
        }
        menu.add((IAction)this.duplicateSheetAction);
        menu.add((IAction)this.deleteSheetAction);
        menu.add((IAction)this.deleteOtherSheetAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.saveSheetAsAction);
        menu.add((IContributionItem)new Separator());
        IAction createSheetAction = this.getActionRegistry().getAction(MindMapActionFactory.NEW_SHEET.getId());
        menu.add(createSheetAction);
        menu.add((IContributionItem)new Separator("new.ext"));
        super.contributeToPagePopupMenu(menu);
        if (this.getSheetsCountOfCurrentWorkbook() < 2) {
            this.deleteSheetAction.setEnabled(false);
            this.deleteOtherSheetAction.setEnabled(false);
        } else {
            this.deleteSheetAction.setEnabled(true);
            this.deleteOtherSheetAction.setEnabled(true);
        }
    }

    private int getSheetsCountOfCurrentWorkbook() {
        if (this.page == null || this.page.isDisposed()) {
            return -1;
        }
        IWorkbook workbook = ((ISheet)this.page.getAdapter(ISheet.class)).getOwnedWorkbook();
        return workbook.getSheets().size();
    }

    public void contributeToSheetCompositePopupMenu(MenuManager menuManager) {
        super.contributeToSheetCompositePopupMenu(menuManager);
    }

    private boolean isCopiedSheetAvailable() {
        return CopiedSheetStorageSupport.getInstance().isCopiedSheetExist();
    }

    public void dispose() {
        if (this.handlerService != null) {
            if (this.getActionRegistry() != null) {
                for (IAction action : this.getActionRegistry().getActions()) {
                    this.deactivateHandler(action);
                }
            }
            this.handlerService = null;
            this.actionHandlerActivations = null;
        }
        if (this.selectionService != null) {
            this.selectionService.removeSelectionListener((ISelectionListener)this);
            this.selectionService = null;
        }
        this.page = null;
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        ICategoryManager manager = MindMapUI.getCategoryManager();
        Object[] elements = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toArray() : null;
        ICategoryAnalyzation categories = elements == null ? null : manager.analyze(elements);
        this.updateStatusLine(manager, categories);
    }

    private void updateStatusLine(ICategoryManager categoryManager, ICategoryAnalyzation categories) {
        IStatusLineManager sl = this.getActionBars().getStatusLineManager();
        if (sl != null) {
            sl.setMessage(MindMapContributor.getStatusMessage(categoryManager, categories));
        }
    }

    private static String getStatusMessage(ICategoryManager categoryManager, ICategoryAnalyzation categories) {
        String m;
        if (categories == null) {
            return null;
        }
        if (categories.isEmpty()) {
            return null;
        }
        int size = categories.getElements().length;
        if (categories.isMultiple()) {
            m = MindMapMessages.StatusLine_MultipleItems;
        } else {
            String type = categories.getMainCategory();
            if ("unknown category".equals(type)) {
                m = "";
            } else {
                Object ele;
                String title;
                String name = categoryManager.getCategoryName(type);
                m = size == 1 ? ((title = MindMapUtils.trimSingleLine(MindMapContributor.getTitle(ele = categories.getElements()[0]))) != null ? NLS.bind((String)MindMapMessages.StatusLine_OneItemPattern, (Object)name, (Object)title) : NLS.bind((String)MindMapMessages.StatusLine_OneItemNoTitlePattern, (Object)name)) : NLS.bind((String)MindMapMessages.StatusLine_MultipleItemPattern, (Object)size, (Object)name);
            }
        }
        return m;
    }

    private static String getTitle(Object ele) {
        if (ele instanceof ITitled) {
            return ((ITitled)ele).getTitleText();
        }
        if (ele instanceof INamed) {
            return ((INamed)ele).getName();
        }
        if (ele instanceof IMarkerRef) {
            return ((IMarkerRef)ele).getDescription();
        }
        return "";
    }
}

