/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.xmind.core.ITopic;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.internal.editpolicies.MindMapPolicyBase;
import org.xmind.ui.internal.editpolicies.SortTopicCommandBuilder;
import org.xmind.ui.util.MindMapUtils;

public class TopicSortablePolicy
extends MindMapPolicyBase {
    public boolean understands(String requestType) {
        return super.understands(requestType) || "sort".equals(requestType);
    }

    public void handle(Request request) {
        String requestType = request.getType();
        if ("sort".equals(requestType)) {
            this.sortTopics(request);
        }
    }

    private void sortTopics(Request request) {
        ICommandStack commandStack;
        List<ITopic> topics = MindMapUtils.getTopics(request.getTargets());
        if (topics.isEmpty()) {
            return;
        }
        ITopic parent = topics.get(0);
        IViewer viewer = request.getTargetViewer();
        SortTopicCommandBuilder builder = new SortTopicCommandBuilder(viewer, commandStack = request.getTargetCommandStack());
        if (!builder.canStart()) {
            return;
        }
        String sortType = (String)request.getParameter("comparand");
        String label = this.getSortCommandLabel(sortType);
        builder.setLabel(label);
        builder.setSortType(sortType);
        builder.sort(parent);
        builder.end();
        CompoundCommand command = builder.getCommand();
        if (command != null) {
            List sources = command.getSources();
            viewer.setSelection((ISelection)new StructuredSelection(sources));
        }
    }

    private String getSortCommandLabel(String sortType) {
        if ("org.xmind.ui.sort_title".equals(sortType)) {
            return CommandMessages.Command_SortByTitle;
        }
        if ("org.xmind.ui.sort_priority".equals(sortType)) {
            return CommandMessages.Command_SortByPriority;
        }
        if ("org.xmind.ui.sort_modified".equals(sortType)) {
            return CommandMessages.Command_SortByModifiedTime;
        }
        return CommandMessages.Command_Sort;
    }
}

