/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IInputChangedListener;
import org.xmind.gef.IViewer;
import org.xmind.gef.IZoomListener;
import org.xmind.gef.ZoomManager;
import org.xmind.gef.ZoomObject;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.ScaledGraphics;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.resources.ColorUtils;

public class Overview
implements ISelectionChangedListener,
IInputChangedListener,
PropertyChangeListener,
IZoomListener,
Listener,
IPropertyChangeListener,
IPageChangedListener {
    private IGraphicalEditor sourceEditor;
    private IGraphicalViewer sourceViewer;
    private RangeModel sourceHorizontalRangeModel;
    private RangeModel sourceVerticalRangeModel;
    private ZoomManager sourceZoomManager;
    private IFigure sourceContents;
    private FigureCanvas canvas;
    private IFigure contents;
    private IFigure feedback;
    private boolean updating = false;
    private ContentsLayoutListener contentsListener;
    private Point moveStart = null;
    private Point sourceStart = null;
    private double zoomScale = 1.0;
    private ResourceManager resources;
    private IPreferenceStore ps;
    private Composite overviewContainer;
    private FigureCanvas sourceFigureCanvas;

    public Overview(Composite container, IGraphicalEditor editor) {
        if (editor == null) {
            return;
        }
        this.sourceEditor = editor;
        this.overviewContainer = container;
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)this.overviewContainer);
        this.sourceEditor.addPageChangedListener((IPageChangedListener)this);
        this.setSourceViewer(this.sourceEditor.getActivePageInstance());
        this.overviewContainer.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Overview.this.dispose();
            }
        });
        this.ps = MindMapUIPlugin.getDefault().getPreferenceStore();
        this.ps.addPropertyChangeListener((IPropertyChangeListener)this);
        this.setOverviewVisible("showOverview");
    }

    private void setSourceViewer(IGraphicalEditorPage page) {
        IGraphicalViewer viewer = page.getViewer();
        if (this.sourceViewer == viewer) {
            return;
        }
        if (this.sourceViewer != null) {
            this.removeAllListener();
        }
        this.sourceViewer = viewer;
        if (this.sourceViewer != null) {
            FigureCanvas fc;
            this.sourceZoomManager = this.sourceViewer.getZoomManager();
            this.sourceFigureCanvas = fc = (FigureCanvas)viewer.getAdapter(FigureCanvas.class);
            this.sourceViewer.addInputChangedListener((IInputChangedListener)this);
            this.sourceViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.sourceZoomManager.addZoomListener((IZoomListener)this);
            this.hookViewport();
            this.hookContents();
        }
    }

    private Control createContents(Composite parent) {
        this.canvas = new FigureCanvas(parent, 0x20000800);
        this.canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        this.canvas.setSize(300, 180);
        this.canvas.addListener(11, (Listener)this);
        this.canvas.addListener(3, (Listener)this);
        this.canvas.addListener(5, (Listener)this);
        this.canvas.addListener(4, (Listener)this);
        this.canvas.addListener(37, (Listener)this);
        this.canvas.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#f9fcfe")));
        this.contents = new ContentsFigure();
        this.contents.setCursor(Cursors.HAND);
        this.canvas.setContents(this.contents);
        this.feedback = this.createFeedback();
        this.contents.add(this.feedback);
        if (this.sourceViewer != null) {
            this.update();
        }
        return this.canvas;
    }

    public void dispose() {
        this.unhookContents();
        this.unhookViewport();
        if (this.sourceZoomManager != null) {
            this.sourceZoomManager.removeZoomListener((IZoomListener)this);
            this.sourceZoomManager = null;
        }
        if (this.sourceViewer != null) {
            this.sourceViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.sourceViewer = null;
        }
        if (this.sourceEditor != null) {
            this.sourceEditor.removePageChangedListener((IPageChangedListener)this);
            this.sourceEditor = null;
        }
        if (this.ps != null) {
            this.ps.removePropertyChangeListener((IPropertyChangeListener)this);
            this.ps = null;
        }
    }

    private void moveStarted(int x, int y) {
        this.moveStart = new Point(x, y);
        this.sourceStart = new Point(this.sourceViewer.getScrollPosition());
    }

    private void moveEnded(int x, int y) {
        if (this.moveStart != null && this.moveStart.x == x && this.moveStart.y == y) {
            this.directMove(x, y);
        }
        this.moveStart = null;
        this.sourceStart = null;
    }

    private void directMove(int x, int y) {
        Point start = this.feedback.getBounds().getCenter();
        Dimension offset = new PrecisionDimension((double)(x - start.x), (double)(y - start.y)).scale(this.sourceZoomManager.getScale() / this.zoomScale).toDraw2DDimension();
        this.sourceViewer.scrollDelta(offset);
    }

    private void feedbackMoved(int x, int y) {
        int dx = x - this.moveStart.x;
        int dy = y - this.moveStart.y;
        Dimension offset = new PrecisionDimension((double)dx, (double)dy).scale(this.sourceZoomManager.getScale() / this.zoomScale).toDraw2DDimension();
        this.sourceViewer.scrollTo(this.sourceStart.getTranslated(offset));
    }

    private void changeZoom(int value) {
        if (value > 0) {
            this.sourceZoomManager.zoomIn();
        } else if (value < 0) {
            this.sourceZoomManager.zoomOut();
        }
    }

    private void update() {
        if (this.updating || this.sourceViewer == null || this.contents == null) {
            return;
        }
        this.updating = true;
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                Overview.this.doUpdate();
                Overview.this.updating = false;
            }
        });
    }

    private void doUpdate() {
        Rectangle feedbackBounds;
        Insets margins;
        Rectangle sourceBounds = this.sourceContents.getBounds();
        Dimension source = sourceBounds.getSize();
        Rectangle area = this.contents.getParent().getClientArea();
        if (area.width == 0 || area.height == 0 || source.width == 0 || source.height == 0) {
            this.zoomScale = -1.0;
            margins = IFigure.NO_INSETS;
            feedbackBounds = null;
        } else {
            int m;
            double wScale = (double)source.width * 1.0 / (double)area.width;
            double hScale = (double)source.height * 1.0 / (double)area.height;
            if (wScale > hScale) {
                this.zoomScale = 1.0 / wScale;
                m = (int)(((double)area.height - (double)source.height / wScale) / 2.0);
                margins = new Insets(m, 0, m, 0);
            } else {
                this.zoomScale = 1.0 / hScale;
                m = (int)(((double)area.width - (double)source.width / hScale) / 2.0);
                margins = new Insets(0, m, 0, m);
            }
            Viewport sourceViewport = this.sourceViewer.getCanvas().getViewport();
            PrecisionPoint loc = new PrecisionPoint(sourceViewport.getViewLocation());
            Dimension size = sourceViewport.getSize();
            double sourceScale = this.sourceZoomManager.getScale();
            feedbackBounds = new Rectangle(loc.scale(1.0 / sourceScale).translate(new PrecisionPoint(sourceBounds.getLocation()).negate()).scale(this.zoomScale).translate((double)margins.left, (double)margins.top).toDraw2DPoint(), size.scale(this.zoomScale / sourceScale));
        }
        this.contents.setBounds(area.getShrinked(margins));
        this.contents.repaint();
        if (feedbackBounds == null) {
            this.feedback.setBounds(new Rectangle(1, 1, 0, 0));
            this.feedback.setVisible(false);
        } else {
            this.feedback.setBounds(feedbackBounds);
            this.feedback.setVisible(true);
        }
    }

    private void hookViewport() {
        Viewport sourceViewport = this.sourceFigureCanvas.getViewport();
        this.sourceHorizontalRangeModel = sourceViewport.getHorizontalRangeModel();
        this.sourceHorizontalRangeModel.addPropertyChangeListener((PropertyChangeListener)this);
        this.sourceVerticalRangeModel = sourceViewport.getVerticalRangeModel();
        this.sourceVerticalRangeModel.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void unhookViewport() {
        if (this.sourceHorizontalRangeModel != null) {
            this.sourceHorizontalRangeModel.removePropertyChangeListener((PropertyChangeListener)this);
            this.sourceHorizontalRangeModel = null;
        }
        if (this.sourceVerticalRangeModel != null) {
            this.sourceVerticalRangeModel.removePropertyChangeListener((PropertyChangeListener)this);
            this.sourceVerticalRangeModel = null;
        }
    }

    private void hookContents() {
        if (this.contentsListener == null) {
            this.contentsListener = new ContentsLayoutListener();
        }
        this.sourceContents = this.sourceViewer.getLayer(GEF.LAYER_CONTENTS);
        this.sourceContents.addLayoutListener((LayoutListener)this.contentsListener);
    }

    private void unhookContents() {
        if (this.contentsListener != null && this.sourceContents != null) {
            this.sourceContents.removeLayoutListener((LayoutListener)this.contentsListener);
        }
    }

    private IFigure createFeedback() {
        RectangleFigure figure = new RectangleFigure();
        figure.setForegroundColor((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#44c0ff")));
        figure.setLineWidth(1);
        figure.setFill(false);
        figure.setOutline(true);
        return figure;
    }

    public void handleEvent(Event event) {
        if (event.type == 3) {
            this.moveStarted(event.x, event.y);
        } else if (event.type == 5) {
            if (this.moveStart != null) {
                this.feedbackMoved(event.x, event.y);
            }
        } else if (event.type == 4) {
            this.moveEnded(event.x, event.y);
        } else if (event.type == 37) {
            this.changeZoom(event.count);
        } else if (event.type == 11) {
            this.update();
        }
    }

    public void scaleChanged(ZoomObject source, double oldValue, double newValue) {
        this.update();
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        this.update();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.update();
    }

    public void inputChanged(IViewer viewer, Object newInput, Object oldInput) {
        this.unhookContents();
        this.unhookViewport();
        this.hookViewport();
        this.hookContents();
        this.update();
    }

    public void removeAllListener() {
        this.unhookContents();
        this.unhookViewport();
        if (this.sourceViewer != null) {
            this.sourceViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.sourceViewer.removeInputChangedListener((IInputChangedListener)this);
        }
        if (this.sourceZoomManager != null) {
            this.sourceZoomManager.removeZoomListener((IZoomListener)this);
        }
    }

    public void recoverAllListener() {
        if (this.sourceViewer != null) {
            this.sourceViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.sourceViewer.removeInputChangedListener((IInputChangedListener)this);
            this.sourceViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.sourceViewer.addInputChangedListener((IInputChangedListener)this);
        }
        this.unhookContents();
        this.unhookViewport();
        this.hookViewport();
        this.hookContents();
        this.update();
    }

    public void propertyChange(final PropertyChangeEvent event) {
        if (!"showOverview".equals(event.getProperty())) {
            return;
        }
        if (this.overviewContainer == null || this.overviewContainer.isDisposed()) {
            return;
        }
        this.overviewContainer.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Overview.this.setOverviewVisible(event.getProperty());
            }
        });
    }

    private void setOverviewVisible(String id) {
        if ("showOverview".equals(id)) {
            boolean showOverview = this.ps.getBoolean(id);
            if (showOverview) {
                if (this.canvas != null && !this.canvas.isDisposed()) {
                    this.recoverAllListener();
                }
                if (this.canvas == null || this.canvas.isDisposed()) {
                    this.createContents(this.overviewContainer);
                    this.overviewContainer.layout(true, true);
                }
            } else if (this.canvas != null && !this.canvas.isDisposed()) {
                this.removeAllListener();
            }
            this.overviewContainer.setVisible(showOverview);
        }
    }

    public void pageChanged(PageChangedEvent event) {
        final IGraphicalEditorPage page = (IGraphicalEditorPage)event.getSelectedPage();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (page.isDisposed() || page.getControl() == null || page.getControl().isDisposed()) {
                    return;
                }
                Overview.this.setSourceViewer(page);
            }
        });
    }

    private class ContentsFigure
    extends Figure {
        public ContentsFigure() {
            this.setOpaque(true);
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            if (Overview.this.sourceContents == null || Overview.this.zoomScale <= 0.0) {
                return;
            }
            graphics.setAntialias(1);
            graphics.pushState();
            try {
                Point offset = this.getBounds().getLocation();
                graphics.translate(offset);
                Graphics g = graphics;
                ScaledGraphics sg = null;
                if (ScaledGraphics.SCALED_GRAPHICS_ENABLED) {
                    sg = new ScaledGraphics(graphics);
                    sg.scale(Overview.this.zoomScale);
                    g = sg;
                } else {
                    g.scale(Overview.this.zoomScale);
                }
                try {
                    this.paintDelegate(g, Overview.this.sourceContents);
                }
                finally {
                    if (sg != null) {
                        sg.dispose();
                    }
                }
            }
            finally {
                graphics.popState();
            }
        }

        private void paintDelegate(Graphics graphics, IFigure figure) {
            Point loc = figure.getBounds().getLocation();
            graphics.translate(-loc.x, -loc.y);
            try {
                figure.paint(graphics);
            }
            finally {
                graphics.translate(loc.x, loc.y);
            }
        }
    }

    private class ContentsLayoutListener
    extends LayoutListener.Stub {
        private ContentsLayoutListener() {
        }

        public void postLayout(IFigure container) {
            Overview.this.update();
        }
    }
}

