/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.Core;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerResource;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.prefs.PrefMessages;
import org.xmind.ui.internal.wizards.MarkerExportWizard;
import org.xmind.ui.internal.wizards.MarkerGroupContentProvider;
import org.xmind.ui.internal.wizards.MarkerGroupLabelProvider;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.Logger;

public class MarkerManagerPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    public static final String ID = "org.xmind.ui.MarkersPrefPage";
    private TableViewer groupViewer;
    private TableViewer markerViewer;
    private Button addGroupButton;
    private Button removeGroupButton;
    private Button renameGroupButton;
    private Button exportGroupButton;
    private Button addMarkerButton;
    private Button removeMarkerButton;
    private Button renameMarkerButton;

    public MarkerManagerPrefPage() {
        super(PrefMessages.MarkersPage_title);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 20;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createGroupGroup(composite);
        this.createMarkerGroup(composite);
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IMarkerSheet sheet = MarkerManagerPrefPage.getSheet();
                MarkerManagerPrefPage.this.groupViewer.setInput((Object)sheet);
                List groups = sheet.getMarkerGroups();
                if (!groups.isEmpty()) {
                    MarkerManagerPrefPage.this.groupViewer.setSelection((ISelection)new StructuredSelection(groups.get(0)));
                }
                MarkerManagerPrefPage.this.refreshButtons();
            }
        });
        return composite;
    }

    private void createGroupGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(PrefMessages.MarkersPage_Groups_label);
        Composite groupContainer = new Composite(composite, 0);
        groupContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.verticalSpacing = 5;
        gridLayout2.horizontalSpacing = 5;
        groupContainer.setLayout((Layout)gridLayout2);
        this.createGroupViewer(groupContainer);
        this.createGroupControls(groupContainer);
    }

    private void createGroupViewer(Composite parent) {
        this.groupViewer = new TableViewer(parent, 2052);
        this.groupViewer.getTable().setLinesVisible(true);
        this.groupViewer.setContentProvider((IContentProvider)new MarkerGroupContentProvider());
        final MarkerGroupLabelProvider labelProvider = new MarkerGroupLabelProvider();
        this.groupViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.groupViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.groupViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MarkerManagerPrefPage.this.markerViewer.setInput(((IStructuredSelection)event.getSelection()).getFirstElement());
                MarkerManagerPrefPage.this.refreshButtons();
            }
        });
        this.groupViewer.setColumnProperties(new String[]{"NAME"});
        this.groupViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.groupViewer.getTable(), 4)});
        this.groupViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                if (element instanceof Widget) {
                    element = ((Widget)element).getData();
                }
                if (element instanceof IMarkerGroup) {
                    MarkerManagerPrefPage.this.changeGroupName((IMarkerGroup)element, value.toString());
                }
            }

            public Object getValue(Object element, String property) {
                return labelProvider.getText(element);
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
        this.groupViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MarkerManagerPrefPage.this.renameGroup();
            }
        });
    }

    private void createGroupControls(Composite parent) {
        Composite outer = new Composite(parent, 0);
        outer.setLayoutData((Object)new GridData(4, 4, false, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        outer.setLayout((Layout)gridLayout);
        Composite inner = new Composite(outer, 0);
        inner.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.verticalSpacing = 5;
        gridLayout2.horizontalSpacing = 0;
        inner.setLayout((Layout)gridLayout2);
        this.addGroupButton = new Button(inner, 8);
        this.addGroupButton.setText(PrefMessages.MarkersPage_AddGroup_text);
        this.addGroupButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hookWidget((Widget)this.addGroupButton, 13);
        this.removeGroupButton = new Button(inner, 8);
        this.removeGroupButton.setText(PrefMessages.MarkersPage_RemoveGroup_text);
        this.removeGroupButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hookWidget((Widget)this.removeGroupButton, 13);
        this.renameGroupButton = new Button(inner, 8);
        this.renameGroupButton.setText(PrefMessages.MarkersPage_RenameGroup_text);
        this.renameGroupButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hookWidget((Widget)this.renameGroupButton, 13);
        this.exportGroupButton = new Button(inner, 8);
        this.exportGroupButton.setText(PrefMessages.MarkersPage_ExportGroup_text);
        this.exportGroupButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hookWidget((Widget)this.exportGroupButton, 13);
    }

    private void createMarkerGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(PrefMessages.MarkersPage_Markers_label);
        Composite markerContainer = new Composite(composite, 0);
        markerContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.verticalSpacing = 5;
        gridLayout2.horizontalSpacing = 5;
        markerContainer.setLayout((Layout)gridLayout2);
        this.createMarkerViewer(markerContainer);
        this.createMarkerControls(markerContainer);
    }

    private void createMarkerViewer(Composite parent) {
        this.markerViewer = new TableViewer(parent, 2052);
        this.markerViewer.setContentProvider((IContentProvider)new MarkerGroupContentProvider());
        final MarkerGroupLabelProvider labelProvider = new MarkerGroupLabelProvider();
        this.markerViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.markerViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.markerViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MarkerManagerPrefPage.this.refreshButtons();
            }
        });
        this.markerViewer.setColumnProperties(new String[]{"NAME"});
        this.markerViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.markerViewer.getTable(), 4)});
        this.markerViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                if (element instanceof Widget) {
                    element = ((Widget)element).getData();
                }
                if (element instanceof IMarker) {
                    MarkerManagerPrefPage.this.changeMarkerName((IMarker)element, value.toString());
                }
            }

            public Object getValue(Object element, String property) {
                return labelProvider.getText(element);
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
        this.markerViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MarkerManagerPrefPage.this.renameMarker();
            }
        });
    }

    private void createMarkerControls(Composite parent) {
        Composite outer = new Composite(parent, 0);
        outer.setLayoutData((Object)new GridData(4, 4, false, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        outer.setLayout((Layout)gridLayout);
        Composite inner = new Composite(outer, 0);
        inner.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.verticalSpacing = 5;
        gridLayout2.horizontalSpacing = 0;
        inner.setLayout((Layout)gridLayout2);
        this.addMarkerButton = new Button(inner, 8);
        this.addMarkerButton.setText(PrefMessages.MarkersPage_AddMarker_text);
        this.addMarkerButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hookWidget((Widget)this.addMarkerButton, 13);
        this.removeMarkerButton = new Button(inner, 8);
        this.removeMarkerButton.setText(PrefMessages.MarkersPage_RemoveMarker_text);
        this.removeMarkerButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hookWidget((Widget)this.removeMarkerButton, 13);
        this.renameMarkerButton = new Button(inner, 8);
        this.renameMarkerButton.setText(PrefMessages.MarkersPage_RenameMarker_text);
        this.renameMarkerButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hookWidget((Widget)this.renameMarkerButton, 13);
    }

    private void hookWidget(Widget widget, int eventType) {
        widget.addListener(eventType, (Listener)this);
    }

    public boolean performOk() {
        MarkerManagerPrefPage.saveSheet();
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    public void handleEvent(Event event) {
        if (event.widget == this.addGroupButton) {
            this.addGroup();
        } else if (event.widget == this.removeGroupButton) {
            this.removeGroup();
        } else if (event.widget == this.renameGroupButton) {
            this.renameGroup();
        } else if (event.widget == this.exportGroupButton) {
            this.exportGroup();
        } else if (event.widget == this.addMarkerButton) {
            this.addMarker();
        } else if (event.widget == this.removeMarkerButton) {
            this.removeMarker();
        } else if (event.widget == this.renameMarkerButton) {
            this.renameMarker();
        }
    }

    private void addGroup() {
        String name = this.createGroupName();
        IMarkerGroup group = MarkerManagerPrefPage.getSheet().createMarkerGroup(false);
        group.setName(name);
        MarkerManagerPrefPage.getSheet().addMarkerGroup(group);
        this.groupViewer.refresh();
        this.groupViewer.setSelection((ISelection)new StructuredSelection((Object)group), true);
        this.groupViewer.editElement((Object)group, 0);
    }

    private String createGroupName() {
        int index = MarkerManagerPrefPage.getSheet().getMarkerGroups().size() + 1;
        String name = NLS.bind((String)PrefMessages.MarkersPage_DefaultGroupName, (Object)index);
        while (this.isNameExisting(name)) {
            name = NLS.bind((String)PrefMessages.MarkersPage_DefaultGroupName, (Object)(++index));
        }
        return name;
    }

    private boolean isNameExisting(String name) {
        for (IMarkerGroup group : MarkerManagerPrefPage.getSheet().getMarkerGroups()) {
            if (!name.equals(group.getName())) continue;
            return true;
        }
        return false;
    }

    private void removeGroup() {
        IStructuredSelection selection = (IStructuredSelection)this.groupViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        List markerGroups = ((IMarkerSheet)this.groupViewer.getInput()).getMarkerGroups();
        int index = markerGroups.indexOf(selection.getFirstElement());
        IMarkerSheet sheet = MarkerManagerPrefPage.getSheet();
        for (Object group : selection.toList()) {
            List markers = ((IMarkerGroup)group).getMarkers();
            for (IMarker marker : markers) {
                if (MindMapUI.getResourceManager().getRecentMarkerGroup().getMarker(marker.getId()) != null) {
                    MindMapUI.getResourceManager().getRecentMarkerGroup().removeMarker(marker);
                }
                this.removeMarkerFile(marker);
            }
            sheet.removeMarkerGroup((IMarkerGroup)group);
        }
        this.groupViewer.refresh();
        markerGroups = ((IMarkerSheet)this.groupViewer.getInput()).getMarkerGroups();
        if (index >= markerGroups.size()) {
            index = markerGroups.size() - 1;
        }
        if (index >= 0 && !markerGroups.isEmpty()) {
            this.groupViewer.setSelection((ISelection)new StructuredSelection(markerGroups.get(index)));
        }
    }

    private void renameGroup() {
        IStructuredSelection selection = (IStructuredSelection)this.groupViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        this.groupViewer.editElement(selection.getFirstElement(), 0);
    }

    private void exportGroup() {
        MarkerExportWizard wizard = new MarkerExportWizard();
        wizard.init(PlatformUI.getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private void addMarker() {
        IStructuredSelection groupSelection = (IStructuredSelection)this.groupViewer.getSelection();
        if (groupSelection.isEmpty()) {
            return;
        }
        IMarkerGroup targetGroup = (IMarkerGroup)groupSelection.getFirstElement();
        String[] sourcePaths = this.selectImageFile();
        if (sourcePaths == null) {
            return;
        }
        ArrayList<IMarker> newMarkers = new ArrayList<IMarker>(sourcePaths.length);
        String[] stringArray = sourcePaths;
        int n = sourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String sourcePath = stringArray[n2];
            if (this.imageValid(sourcePath)) {
                OutputStream os;
                String path = String.valueOf(Core.getIdFactory().createId()) + FileUtils.getExtension((String)sourcePath);
                IMarker marker = MarkerManagerPrefPage.getSheet().createMarker(path);
                marker.setName(FileUtils.getFileName((String)sourcePath));
                IMarkerResource resource = marker.getResource();
                if (resource != null && (os = resource.getOutputStream()) != null) {
                    try {
                        FileInputStream is = new FileInputStream(sourcePath);
                        FileUtils.transfer((InputStream)is, (OutputStream)os, (boolean)true);
                    }
                    catch (IOException e) {
                        Logger.log(e);
                    }
                }
                targetGroup.addMarker(marker);
                newMarkers.add(marker);
            }
            ++n2;
        }
        this.markerViewer.refresh();
        this.markerViewer.setSelection((ISelection)new StructuredSelection(newMarkers), true);
    }

    private boolean imageValid(String sourcePath) {
        try {
            new Image((Device)Display.getCurrent(), sourcePath).dispose();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private String[] selectImageFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 4098);
        DialogUtils.makeDefaultImageSelectorDialog(dialog, true);
        String open = dialog.open();
        if (open == null) {
            return null;
        }
        String parent = dialog.getFilterPath();
        String[] fileNames = dialog.getFileNames();
        String[] paths = new String[fileNames.length];
        int i = 0;
        while (i < fileNames.length) {
            paths[i] = new File(parent, fileNames[i]).getAbsolutePath();
            ++i;
        }
        return paths;
    }

    private void removeMarker() {
        IStructuredSelection selection = (IStructuredSelection)this.markerViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        IStructuredSelection groupSelection = (IStructuredSelection)this.groupViewer.getSelection();
        if (groupSelection.isEmpty()) {
            return;
        }
        List markers = ((IMarkerGroup)this.markerViewer.getInput()).getMarkers();
        int index = markers.indexOf(selection.getFirstElement());
        IMarkerGroup group = (IMarkerGroup)groupSelection.getFirstElement();
        for (Object marker : selection.toList()) {
            group.removeMarker((IMarker)marker);
            if (MindMapUI.getResourceManager().getRecentMarkerGroup().getMarker(((IMarker)marker).getId()) != null) {
                MindMapUI.getResourceManager().getRecentMarkerGroup().removeMarker((IMarker)marker);
            }
            this.removeMarkerFile((IMarker)marker);
        }
        this.markerViewer.refresh();
        markers = ((IMarkerGroup)this.markerViewer.getInput()).getMarkers();
        if (index >= markers.size()) {
            index = markers.size() - 1;
        }
        if (index >= 0 && !markers.isEmpty()) {
            this.markerViewer.setSelection((ISelection)new StructuredSelection(markers.get(index)));
        }
    }

    private void removeMarkerFile(IMarker marker) {
        if (marker == null) {
            return;
        }
        String path = Core.getWorkspace().getAbsolutePath("markers/" + marker.getResourcePath());
        new File(path).delete();
    }

    private void renameMarker() {
        IStructuredSelection selection = (IStructuredSelection)this.markerViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        this.markerViewer.editElement(selection.getFirstElement(), 0);
    }

    private void changeGroupName(IMarkerGroup group, String newName) {
        group.setName(newName);
        this.groupViewer.update((Object)group, null);
    }

    private void refreshButtons() {
        IStructuredSelection groupSelection = (IStructuredSelection)this.groupViewer.getSelection();
        this.removeGroupButton.setEnabled(!groupSelection.isEmpty());
        this.renameGroupButton.setEnabled(!groupSelection.isEmpty());
        this.exportGroupButton.setEnabled(!groupSelection.isEmpty());
        this.addMarkerButton.setEnabled(!groupSelection.isEmpty());
        IStructuredSelection markerSelection = (IStructuredSelection)this.markerViewer.getSelection();
        this.removeMarkerButton.setEnabled(!markerSelection.isEmpty());
        this.renameMarkerButton.setEnabled(!markerSelection.isEmpty());
    }

    private void changeMarkerName(IMarker marker, String newName) {
        marker.setName(newName);
        this.markerViewer.update((Object)marker, null);
    }

    private static IMarkerSheet getSheet() {
        return MindMapUI.getResourceManager().getUserMarkerSheet();
    }

    private static void saveSheet() {
        MindMapUI.getResourceManager().saveUserMarkerSheet();
    }
}

